This operation is used to return all the clinical information related to a single patient described in the resource or context on which this operation is invoked. The response is a bundle of type “searchset”. At a minimum, the patient resource(s) itself is returned, along with any other clinical (as defined by USCDI) resources that the server has that are related to the patient, and that are available for the given user. The server also returns whatever resources are needed to support the records - e.g., linked practitioners, medications, locations, organizations etc. It should be noted that the server may need to filter resources to exclude resource profiles that fall outside of the clinical context. For example, excluding Blue Button claims that use the ExplanationOfBenefit resource, while including PDex Prior Authorizations that use the same base resource.

The list of resources related to a single patient can be found in the [Data Retrieval Methods](payertopayerexchange.html#data-retrieval-methods) section of the [Payer-to-Payer Exchange](payertopayerexchange.html) page of this IG.

The intended use for this operation is to provide a payer with access to the entire clinical record. The server SHOULD return at least all resources that it has that are in the patient compartment for the identified patient(s), and any resource referenced from those, including binaries and attachments. In the US Realm, at a minimum, the resources returned SHALL include all the data covered by the meaningful use common data elements as defined in the US Core [3.1.1]({{site.data.fhir.ver.uscore3}}) or [6.1.0]({{site.data.fhir.ver.uscore6}}) Implementation Guide. The PDex Implementation Guide adds Pdex-Device, Pdex-MedicationDispense and Pdex-PriorAuthorization to the clinical resource set. Other applicable implementation guides may make additional rules about how much information that is returned.
