# PDex Implementation Guide - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* **PDex Implementation Guide**

## PDex Implementation Guide

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

[Previous Page - Introduction](introduction.md)

| | |
| :--- | :--- |
| **Official URL**: http://hl7.org/fhir/us/davinci-pdex | **Version**: 2.1.0 |
| **NPM package name**: hl7.fhir.us.davinci-pdex | **ComputableName**: DaVinciPayerDataExchange |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License |   |
| **Other Identifiers**: OID:2.16.840.1.113883.4.642.40.8 |   |

* [XML](ImplementationGuide-hl7.fhir.us.davinci-pdex.xml)
* [JSON](ImplementationGuide-hl7.fhir.us.davinci-pdex.json)

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.davinci-pdex.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.davinci-pdex.r4b)](package.r4b.tgz) are available. 

### IG Dependencies

This IG Contains the following dependencies on other IGs.
























### Global Profiles

*There are no Global profiles defined*

### Copyrights

This publication includes IP covered under the following statements.

* All X12 products are subject to this IP policy, including published and draft works.X12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.Additional IP information can be found [here](https://x12.org/products/ip-use) Send an email to ip@x12.org to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.Additional information on X12 licensing program can be found [here](https://x12.org/products/licensing-program) To purchase code list subscriptions call (425) 562-2245 or email admin@wpc-edi.com.

* [X12 Claim Adjustment Reason Codes](http://terminology.hl7.org/6.3.0/CodeSystem-X12ClaimAdjustmentReasonCodes.html): [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md) and [X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes](ValueSet-X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes.md)


* All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.Please see [[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)](https://x12.org/products/licensing-program) 

* [X12 Service Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-X12ServiceTypeCodes.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md) and [PriorAuthServiceTypeCodes](ValueSet-PriorAuthServiceTypeCodes.md)


* CMS maintains HIPPS. There are no known constraints on the use of HIPPS.

* [Health Insurance Prospective Payment System (HIPPS)](http://terminology.hl7.org/6.3.0/CodeSystem-HIPPS.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PDexPAInstitutionalProcedureCodes](ValueSet-PDexPAInstitutionalProcedureCodes.md), [PDexPAInstitutionalProcedureCodesVS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.3.0/CodeSystem-ISO3166Part1.html): [AssociatedServers](StructureDefinition-base-ext-associatedServers.md), [AttestationProvisionTypeValueSet](ValueSet-attestation-provision-type-valueset.md)...Show 102 more,[AttestationStatusValueSet](ValueSet-attestation-status-valueset.md),[BulkMemberMatch](OperationDefinition-BulkMemberMatch.md),[BulkMemberMatchDataExport](OperationDefinition-BulkMemberMatchDataExport.md),[ContactPointAvailableTime](StructureDefinition-base-ext-contactpoint-availabletime.md),[DaVinciPayerDataExchange](index.md),[DispenseRefill](StructureDefinition-DispenseRefill.md),[DynamicRegistration](StructureDefinition-base-ext-dynamicRegistration.md),[EndpointAccessControlMechanism](StructureDefinition-base-ext-endpointAccessControlMechanism.md),[EndpointPayloadTypeCS](CodeSystem-EndpointPayloadTypeCS.md),[EndpointPayloadTypeVS](ValueSet-EndpointPayloadTypeVS.md),[EndpointRank](StructureDefinition-base-ext-endpoint-rank.md),[EndpointUsecase](StructureDefinition-base-ext-endpoint-usecase.md),[ExplanationOfBenefit_Identifier](SearchParameter-explanationofbenefit-identifier.md),[ExplanationOfBenefit_Patient](SearchParameter-explanationofbenefit-patient.md),[ExplanationOfBenefit_ServiceDate](SearchParameter-explanationofbenefit-service-date.md),[ExplanationOfBenefit_Type](SearchParameter-explanationofbenefit-type.md),[ExplanationOfBenefit_Use](SearchParameter-explanationofbenefit-use.md),[FDANationalDrugCode](ValueSet-FDANationalDrugCode.md),[FhirIg](StructureDefinition-base-ext-fhir-ig.md),[Group_Code](SearchParameter-group-code.md),[IdentifierStatus](StructureDefinition-base-ext-identifier-status.md),[LastFilters](StructureDefinition-base-ext-last-typefilter.md),[LastTransmission](StructureDefinition-base-ext-last-transmission.md),[LastTypes](StructureDefinition-base-ext-last-types.md),[LevelOfServiceCode](StructureDefinition-extension-levelOfServiceCode.md),[MatchParameters](StructureDefinition-base-ext-match-parameters.md),[MemberOptOut](StructureDefinition-member-opt-out-group.md),[MemberProviderTreatmentRelationship](StructureDefinition-member-provider-treatment-relationship-group.md),[MembersOptedOut](StructureDefinition-base-ext-members-opted-out.md),[MtlsBundle](StructureDefinition-mtls-bundle.md),[MtlsEndpoint](StructureDefinition-mtls-endpoint.md),[MtlsObjectCodeCS](CodeSystem-MtlsObjectCodeCS.md),[MtlsObjectTypeVS](ValueSet-MtlsObjectTypeVS.md),[MtlsOrganization](StructureDefinition-mtls-organization.md),[MtlsSignedObject](StructureDefinition-pdex-mtls-signedobject-extension.md),[OptOutDetails](StructureDefinition-opt-out-details.md),[OptOutReason](StructureDefinition-opt-out-reason.md),[OptOutReasonCodeSystem](CodeSystem-opt-out-reason.md),[OptOutReasonValueSet](ValueSet-opt-out-reason-valueset.md),[OptOutScopeCodeSystem](CodeSystem-opt-out-scope.md),[OptOutScopeValueSet](ValueSet-opt-out-scope-valueset.md),[OrgTypeCS](CodeSystem-OrgTypeCS.md),[OrgTypeVS](ValueSet-OrgTypeVS.md),[PDexAdjudication](ValueSet-PDexAdjudication.md),[PDexAdjudicationCategoryDiscriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md),[PDexAdjudicationDiscriminator](CodeSystem-PDexAdjudicationDiscriminator.md),[PDexIdentifierType](CodeSystem-PDexIdentifierType.md),[PDexMemberCharacteristicCode](CodeSystem-pdex-member-characteristic-code.md),[PDexMemberMatchGroup](StructureDefinition-pdex-member-match-group.md),[PDexMemberNoMatchGroup](StructureDefinition-pdex-member-no-match-group.md),[PDexMultiMemberMatchRequestParameters](StructureDefinition-pdex-parameters-multi-member-match-bundle-in.md),[PDexMultiMemberMatchResponseParameters](StructureDefinition-pdex-parameters-multi-member-match-bundle-out.md),[PDexMultiMemberMatchResultVS](ValueSet-PDexMultiMemberMatchResultVS.md),[PDexPAInstitutionalProcedureCodes](ValueSet-PDexPAInstitutionalProcedureCodes.md),[PDexPAInstitutionalProcedureCodesVS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md),[PDexPayerAdjudicationStatus](CodeSystem-PDexPayerAdjudicationStatus.md),[PDexPayerBenefitPaymentStatus](ValueSet-PDexPayerBenefitPaymentStatus.md),[PDexProviderGroup](StructureDefinition-pdex-provider-group.md),[PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md),[PDexServerCapabilityStatement61](CapabilityStatement-pdex-server-6-1.md),[PDexSupportingInfoType](ValueSet-PDexSupportingInfoType.md),[PDexSupportingInfoTypeCS](CodeSystem-PDexSupportingInfoTypeCS.md),[PdexDevice](StructureDefinition-pdex-device.md),[PdexMedicationDispense](StructureDefinition-pdex-medicationdispense.md),[PdexMedicationDispensePatient](SearchParameter-pdex-medicationdispense-patient.md),[PdexMedicationDispenseStatus](SearchParameter-pdex-medicationdispense-status.md),[PdexMemberAttributionCS](CodeSystem-PdexMemberAttributionCS.md),[PdexMultiMemberMatchResultCS](CodeSystem-PdexMultiMemberMatchResultCS.md),[PdexPayerAccessServerCapabilityStatement](CapabilityStatement-pdex-payer-access-server.md),[PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md),[PdexProviderAccessServerCapabilityStatement](CapabilityStatement-pdex-provider-access-server.md),[PdexServerCapabilityStatement](CapabilityStatement-pdex-server.md),[PriorAuthServiceTypeCodes](ValueSet-PriorAuthServiceTypeCodes.md),[PriorAuthorizationAmounts](ValueSet-PriorAuthorizationAmounts.md),[PriorAuthorizationUtilization](StructureDefinition-PriorAuthorizationUtilization.md),[PriorAuthorizationValueCodes](CodeSystem-PriorAuthorizationValueCodes.md),[Provenance](StructureDefinition-pdex-provenance.md),[ProvenanceAgentRoleType](CodeSystem-ProvenanceAgentRoleType.md),[ProvenanceAgentType](ValueSet-ProvenanceAgentType.md),[ProvenancePayerDataSource](CodeSystem-ProvenancePayerDataSource.md),[ProvenancePayerSourceFormat](ValueSet-ProvenancePayerSourceFormat.md),[ProvenanceSourceFrom](StructureDefinition-ProvenanceSourceFrom.md),[ProviderMemberMatch](OperationDefinition-ProviderMemberMatch.md),[ProviderMemberMatchGroup](StructureDefinition-provider-member-match-group.md),[ProviderMemberNoMatchGroup](StructureDefinition-provider-member-no-match-group.md),[ProviderMultiMemberMatchRequestParameters](StructureDefinition-provider-parameters-multi-member-match-bundle-in.md),[ProviderMultiMemberMatchResponseParameters](StructureDefinition-provider-parameters-multi-member-match-bundle-out.md),[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md),[ReviewAction](StructureDefinition-extension-reviewAction.md),[ReviewActionCode](StructureDefinition-extension-reviewActionCode.md),[SecureExchangeArtifacts](StructureDefinition-base-ext-secureExchangeArtifacts.md),[TreatmentRelationshipDetails](StructureDefinition-treatment-relationship-details.md),[TreatmentRelationshipTypeCodeSystem](CodeSystem-treatment-relationship-type.md),[TreatmentRelationshipTypeValueSet](ValueSet-treatment-relationship-type-valueset.md),[TrustFramework](StructureDefinition-base-ext-trustFramework.md),[TrustFrameworkTypeCS](CodeSystem-TrustFrameworkTypeCS.md),[TrustFrameworkTypeVS](ValueSet-TrustFrameworkTypeVS.md),[TrustProfileCS](CodeSystem-TrustProfileCS.md),[VerificationStatus](StructureDefinition-base-ext-verification-status.md),[WhenAdjudicated](StructureDefinition-base-ext-when-adjudicated.md),[X12278ReviewDecisionReasonCode](ValueSet-X12278ReviewDecisionReasonCode.md)and[X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes](ValueSet-X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [Bundle/example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md)


* This CodeSystem is not copyrighted.

* [C4BB Adjudication Code System](http://hl7.org/fhir/us/carin-bb/STU2.1/CodeSystem-C4BBAdjudication.html): [PDexAdjudication](ValueSet-PDexAdjudication.md), [PDexAdjudicationCategoryDiscriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [PDex Adjudication Discriminator](CodeSystem-PDexAdjudicationDiscriminator.md): [PDexAdjudicationCategoryDiscriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [PDex Payer Adjudication Status](CodeSystem-PDexPayerAdjudicationStatus.md): [PDexPayerBenefitPaymentStatus](ValueSet-PDexPayerBenefitPaymentStatus.md)
* [PDex Supporting Info Type](CodeSystem-PDexSupportingInfoTypeCS.md): [PDexSupportingInfoType](ValueSet-PDexSupportingInfoType.md)


* This is an example set based on ASTM Standard, E1762-95 (2013) HL7 RoleClass OID 2.16.840.1.113883.5.110, HL7 Role Code 2.16.840.1.113883.5.111, HL7 ParticipationType OID: 2.16.840.1.113883.5.90, HL7 ParticipationFunction codes at OID: 2.16.840.1.113883.5.88, and HL7 Security and Privacy Domain Analysis Model roles classes.

* [Contract Signer Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-contractsignertypecodes.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md), [Bundle/1000000-3](Bundle-1000000-3.md) and [Provenance/1000017](Provenance-1000017.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.3.0/CodeSystem-v3-loinc.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md), [Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md)...Show 6 more,[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[DocumentReference/123456](DocumentReference-123456.md),[DocumentReference/provider-attestation-doc-1](DocumentReference-provider-attestation-doc-1.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 7 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/3000003](Bundle-3000003.md),[Device/543210](Device-543210.md),[Encounter/6](Encounter-6.md),[Encounter/7](Encounter-7.md),[Encounter/8](Encounter-8.md)and[PdexDevice](StructureDefinition-pdex-device.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/6.3.0/CodeSystem-adjudication.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PDexAdjudication](ValueSet-PDexAdjudication.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [Claim Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-claim-type.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Condition Category Codes](http://terminology.hl7.org/6.3.0/CodeSystem-condition-category.html): [Bundle/3000003](Bundle-3000003.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.3.0/CodeSystem-condition-clinical.html): [Bundle/3000003](Bundle-3000003.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.3.0/CodeSystem-condition-ver-status.html): [Bundle/3000003](Bundle-3000003.md)
* [Consent Action Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentaction.html): [Consent/consent-2](Consent-consent-2.md), [Consent/no-consent-1](Consent-no-consent-1.md), [PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md) and [Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md)
* [Consent Category Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentcategorycodes.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md), [Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md)...Show 5 more,[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[DocumentReference/provider-attestation-doc-1](DocumentReference-provider-attestation-doc-1.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)
* [Consent PolicyRule Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentpolicycodes.html): [Consent/no-consent-1](Consent-no-consent-1.md) and [PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md)
* [Consent Scope Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentscope.html): [Consent/consent-2](Consent-consent-2.md), [Consent/no-consent-1](Consent-no-consent-1.md)...Show 8 more,[Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md),[Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md),[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)
* [Coverage Class Codes](http://terminology.hl7.org/6.3.0/CodeSystem-coverage-class.html): [Coverage/CoverageLinkExample1](Coverage-CoverageLinkExample1.md), [Coverage/CoverageMatchExample1](Coverage-CoverageMatchExample1.md)...Show 5 more,[Coverage/CoverageMatchExample2](Coverage-CoverageMatchExample2.md),[Coverage/coverage-2](Coverage-coverage-2.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)and[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)
* [DataAbsentReason](http://terminology.hl7.org/6.3.0/CodeSystem-data-absent-reason.html): [Bundle/example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md), [MtlsEndpoint](StructureDefinition-mtls-endpoint.md)...Show 4 more,[PDexPAInstitutionalProcedureCodes](ValueSet-PDexPAInstitutionalProcedureCodes.md),[PDexPAInstitutionalProcedureCodesVS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md),[Payer-Payer Exchange](Endpoint-diamond-mtls-endpoint2.md)and[PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [Endpoint Connection Type](http://terminology.hl7.org/6.3.0/CodeSystem-endpoint-connection-type.html): [Bundle/example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md), [MtlsEndpoint](StructureDefinition-mtls-endpoint.md) and [Payer-Payer Exchange](Endpoint-diamond-mtls-endpoint2.md)
* [Example Diagnosis Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-ex-diagnosistype.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Example Related Claim Relationship Codes](http://terminology.hl7.org/6.3.0/CodeSystem-ex-relatedclaimrelationship.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Funds Reservation Codes](http://terminology.hl7.org/6.3.0/CodeSystem-fundsreserve.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Organization type](http://terminology.hl7.org/6.3.0/CodeSystem-organization-type.html): [DiamondOnyxHealth](Organization-DiamondOnyxHealth1.md)
* [Process Priority Codes](http://terminology.hl7.org/6.3.0/CodeSystem-processpriority.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [Professional Credential Status](http://terminology.hl7.org/6.3.0/CodeSystem-professional-credential-status.html): [IdentifierStatus](StructureDefinition-base-ext-identifier-status.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/6.3.0/CodeSystem-subscriber-relationship.html): [Coverage/883210](Coverage-883210.md), [Coverage/Coverage1](Coverage-Coverage1.md)...Show 8 more,[Coverage/CoverageLinkExample1](Coverage-CoverageLinkExample1.md),[Coverage/CoverageMatchExample1](Coverage-CoverageMatchExample1.md),[Coverage/CoverageMatchExample2](Coverage-CoverageMatchExample2.md),[Coverage/coverage-2](Coverage-coverage-2.md),[Coverage/coverage-link-2](Coverage-coverage-link-2.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)and[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)
* [identifierType](http://terminology.hl7.org/6.3.0/CodeSystem-v2-0203.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 28 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Coverage/883210](Coverage-883210.md),[Coverage/Coverage1](Coverage-Coverage1.md),[Coverage/coverage-2](Coverage-coverage-2.md),[Coverage/coverage-link-2](Coverage-coverage-link-2.md),[Group/example-pdex-member-consent-constraint-group](Group-example-pdex-member-consent-constraint-group.md),[Group/example-pdex-member-no-match-group](Group-example-pdex-member-no-match-group.md),[Matched Members](Group-07e72a15407547bf9d03f522aa536a72.1.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/payer-multi-member-match-out](Parameters-payer-multi-member-match-out.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-bulk-member-match-out](Parameters-provider-bulk-member-match-out.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md),[Patient/1](Patient-1.md),[Patient/1-2](Patient-1-2.md),[Patient/100](Patient-100.md),[Patient/1001](Patient-1001.md),[Patient/2002](Patient-2002.md),[Patient/PatientMemberMatchExample1](Patient-PatientMemberMatchExample1.md),[Patient/PatientMemberMatchExample2](Patient-PatientMemberMatchExample2.md),[Patient/patient-2](Patient-patient-2.md),[Patient/payer-patient-1001](Patient-payer-patient-1001.md),[Patient/payer-patient-2002](Patient-payer-patient-2002.md),[Payer 1](Organization-Payer1.md),[Payer 2](Organization-Payer2.md),[Practitioner/4](Practitioner-4.md),[Provider 1](Organization-ProviderOrg1.md)and[Provider 2](Organization-ProviderOrg2.md)
* [ActCode](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ActCode.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 16 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/2000002](Bundle-2000002.md),[Bundle/3000002](Bundle-3000002.md),[Consent/consent-2](Consent-consent-2.md),[Consent/no-consent-1](Consent-no-consent-1.md),[Coverage/CoverageLinkExample1](Coverage-CoverageLinkExample1.md),[Coverage/CoverageMatchExample1](Coverage-CoverageMatchExample1.md),[Coverage/CoverageMatchExample2](Coverage-CoverageMatchExample2.md),[Encounter/6](Encounter-6.md),[Encounter/7](Encounter-7.md),[Encounter/8](Encounter-8.md),[MedicationDispense/1000001](MedicationDispense-1000001.md),[PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[PdexMedicationDispense](StructureDefinition-pdex-medicationdispense.md)
* [ActReason](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ActReason.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md), [Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md)...Show 5 more,[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md),[Provenance/1000101](Provenance-1000101.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)
* [DataOperation](http://terminology.hl7.org/6.3.0/CodeSystem-v3-DataOperation.html): [Provenance/1000101](Provenance-1000101.md)
* [NullFlavor](http://terminology.hl7.org/6.3.0/CodeSystem-v3-NullFlavor.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 4 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Patient/1](Patient-1.md),[Patient/1-2](Patient-1-2.md)and[Patient/100](Patient-100.md)
* [ParticipationType](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ParticipationType.html): [Consent/consent-2](Consent-consent-2.md), [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md)...Show 5 more,[Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md),[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)and[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)
* [RoleClass](http://terminology.hl7.org/6.3.0/CodeSystem-v3-RoleClass.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md) and [Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core DocumentReferences Category Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-documentreference-category.html): [DocumentReference/123456](DocumentReference-123456.md)
* [US Core Provenance Participant Type Extension Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-provenance-participant-type.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 8 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/3000002](Bundle-3000002.md),[Provenance](StructureDefinition-pdex-provenance.md),[Provenance/1000001](Provenance-1000001.md),[Provenance/1000016](Provenance-1000016.md),[Provenance/1000017](Provenance-1000017.md),[Provenance/1000101](Provenance-1000101.md)and[ProvenanceAgentType](ValueSet-ProvenanceAgentType.md)
* [Endpoint Payload Types Code System](CodeSystem-EndpointPayloadTypeCS.md): [EndpointPayloadTypeVS](ValueSet-EndpointPayloadTypeVS.md)
* [mTLS Object Type Code](CodeSystem-MtlsObjectCodeCS.md): [MtlsObjectTypeVS](ValueSet-MtlsObjectTypeVS.md), [MtlsSignedObject](StructureDefinition-pdex-mtls-signedobject-extension.md) and [Payer-Payer Exchange](Endpoint-diamond-mtls-endpoint2.md)
* [Organization Type](CodeSystem-OrgTypeCS.md): [Acme of CT](Organization-Acme.md) and [OrgTypeVS](ValueSet-OrgTypeVS.md)
* [PDex Provider Access API Attribution Code System](CodeSystem-PdexMemberAttributionCS.md): [Attributed List of Health Plan Members for Practitioner 1122334455.](Group-Example-PDex-Provider-Group.md), [MemberOptOut](StructureDefinition-member-opt-out-group.md)...Show 7 more,[MemberProviderTreatmentRelationship](StructureDefinition-member-provider-treatment-relationship-group.md),[PDexMemberMatchGroup](StructureDefinition-pdex-member-match-group.md),[PDexMemberNoMatchGroup](StructureDefinition-pdex-member-no-match-group.md),[PDexMultiMemberMatchResultVS](ValueSet-PDexMultiMemberMatchResultVS.md),[PDexProviderGroup](StructureDefinition-pdex-provider-group.md),[ProviderMemberMatchGroup](StructureDefinition-provider-member-match-group.md)and[ProviderMemberNoMatchGroup](StructureDefinition-provider-member-no-match-group.md)
* [PDex Multi-Member Match Result Code System](CodeSystem-PdexMultiMemberMatchResultCS.md): [Group/example-pdex-member-consent-constraint-group](Group-example-pdex-member-consent-constraint-group.md), [Group/example-pdex-member-no-match-group](Group-example-pdex-member-no-match-group.md)...Show 11 more,[Matched Members](Group-07e72a15407547bf9d03f522aa536a72.1.md),[MemberOptOut](StructureDefinition-member-opt-out-group.md),[MemberProviderTreatmentRelationship](StructureDefinition-member-provider-treatment-relationship-group.md),[PDexMemberMatchGroup](StructureDefinition-pdex-member-match-group.md),[PDexMemberNoMatchGroup](StructureDefinition-pdex-member-no-match-group.md),[PDexMultiMemberMatchResultVS](ValueSet-PDexMultiMemberMatchResultVS.md),[PDexProviderGroup](StructureDefinition-pdex-provider-group.md),[Parameters/payer-multi-member-match-out](Parameters-payer-multi-member-match-out.md),[Parameters/provider-bulk-member-match-out](Parameters-provider-bulk-member-match-out.md),[ProviderMemberMatchGroup](StructureDefinition-provider-member-match-group.md)and[ProviderMemberNoMatchGroup](StructureDefinition-provider-member-no-match-group.md)
* [Prior Authorization Values](CodeSystem-PriorAuthorizationValueCodes.md): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md) and [PriorAuthorizationAmounts](ValueSet-PriorAuthorizationAmounts.md)
* [Provenance Roles](CodeSystem-ProvenanceAgentRoleType.md): [Provenance](StructureDefinition-pdex-provenance.md) and [ProvenanceAgentType](ValueSet-ProvenanceAgentType.md)
* [Provenance Payer Data Source Format](CodeSystem-ProvenancePayerDataSource.md): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 13 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/3000002](Bundle-3000002.md),[Bundle/3000003](Bundle-3000003.md),[Provenance](StructureDefinition-pdex-provenance.md),[Provenance/1000001](Provenance-1000001.md),[Provenance/1000002](Provenance-1000002.md),[Provenance/1000003](Provenance-1000003.md),[Provenance/1000004](Provenance-1000004.md),[Provenance/1000005](Provenance-1000005.md),[Provenance/1000006](Provenance-1000006.md),[Provenance/1000016](Provenance-1000016.md),[ProvenancePayerSourceFormat](ValueSet-ProvenancePayerSourceFormat.md)and[ProvenanceSourceFrom](StructureDefinition-ProvenanceSourceFrom.md)
* [Trust FrameworkType Code System](CodeSystem-TrustFrameworkTypeCS.md): [TrustFramework](StructureDefinition-base-ext-trustFramework.md) and [TrustFrameworkTypeVS](ValueSet-TrustFrameworkTypeVS.md)
* [Opt-Out Reason](CodeSystem-opt-out-reason.md): [OptOutReason](StructureDefinition-opt-out-reason.md) and [OptOutReasonValueSet](ValueSet-opt-out-reason-valueset.md)
* [Opt-Out Scope](CodeSystem-opt-out-scope.md): [MemberOptOut](StructureDefinition-member-opt-out-group.md) and [OptOutScopeValueSet](ValueSet-opt-out-scope-valueset.md)
* [Treatment Relationship Type](CodeSystem-treatment-relationship-type.md): [TreatmentRelationshipTypeValueSet](ValueSet-treatment-relationship-type-valueset.md)


[Next Page - Security and Privacy](securityandprivacy.md)

