# example-pdex-member-consent-constraint-group - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **example-pdex-member-consent-constraint-group**

## Example Group: example-pdex-member-consent-constraint-group

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Default Generated text for resource.



## Resource Content

```json
{
  "resourceType" : "Group",
  "id" : "example-pdex-member-consent-constraint-group",
  "meta" : {
    "lastUpdated" : "2024-03-20T09:00:00.000Z",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-member-no-match-group"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Patient",
      "id" : "4",
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "MB"
              }
            ]
          },
          "system" : "http://example.org/old-payer/identifiers/member",
          "value" : "45567",
          "assigner" : {
            "display" : "Old Payer"
          }
        }
      ],
      "name" : [
        {
          "use" : "official",
          "family" : "Noway",
          "given" : ["Janis", "Noelle"]
        }
      ],
      "gender" : "female",
      "birthDate" : "1956-12-25"
    }
  ],
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "0123456789"
    }
  ],
  "type" : "person",
  "actual" : true,
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
        "code" : "consentconstraint",
        "display" : "Consent Constraint"
      }
    ]
  },
  "managingEntity" : {
    "identifier" : {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9876543210"
    },
    "display" : "Old Health Plan"
  },
  "member" : [
    {
      "entity" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
            "valueReference" : {
              "reference" : "#4"
            }
          }
        ],
        "reference" : "#4"
      }
    }
  ]
}

```
