# example-pdex-member-match-group - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **example-pdex-member-match-group**

## Example Group: example-pdex-member-match-group

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Default Generated text for resource.



## Resource Content

```json
{
  "resourceType" : "Group",
  "id" : "07e72a15407547bf9d03f522aa536a72.1",
  "meta" : {
    "lastUpdated" : "2024-03-20T09:00:00.000Z",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-member-match-group"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Patient",
      "id" : "1",
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "MB"
              }
            ]
          },
          "system" : "http://example.org/old-payer/identifiers/member",
          "value" : "55678",
          "assigner" : {
            "display" : "Old Payer"
          }
        }
      ],
      "name" : [
        {
          "use" : "official",
          "family" : "Person",
          "given" : ["Patricia", "Ann"]
        }
      ],
      "gender" : "female",
      "birthDate" : "1974-12-25"
    },
    {
      "resourceType" : "Patient",
      "id" : "2",
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "MB"
              }
            ]
          },
          "system" : "http://example.org/old-payer/identifiers/member",
          "value" : "45567",
          "assigner" : {
            "display" : "Old Payer"
          }
        }
      ],
      "name" : [
        {
          "use" : "official",
          "family" : "Smith",
          "given" : ["William", "John"]
        }
      ],
      "gender" : "male",
      "birthDate" : "1958-12-25"
    }
  ],
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "0123456789"
    }
  ],
  "type" : "person",
  "actual" : true,
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
        "code" : "match",
        "display" : "Matched"
      }
    ]
  },
  "name" : "Matched Members",
  "managingEntity" : {
    "identifier" : {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9876543210"
    },
    "display" : "Old Health Plan"
  },
  "characteristic" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
            "code" : "match",
            "display" : "Matched"
          }
        ]
      },
      "valueReference" : {
        "identifier" : {
          "system" : "http://hl7.org/fhir/sid/us-npi",
          "value" : "0123456789"
        }
      },
      "exclude" : false,
      "period" : {
        "start" : "2024-03-20"
      }
    }
  ],
  "member" : [
    {
      "entity" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
            "valueReference" : {
              "reference" : "#1"
            }
          }
        ],
        "reference" : "Patient/1001"
      }
    },
    {
      "entity" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
            "valueReference" : {
              "reference" : "#2"
            }
          }
        ],
        "reference" : "Patient/2002"
      }
    }
  ]
}

```
