# diamond-mtls-endpoint1 - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **diamond-mtls-endpoint1**

## Example Endpoint: diamond-mtls-endpoint1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2022-07-04 15:00:00+0000

Profile: [mTLS Endpoint](StructureDefinition-mtls-endpoint.md)

> **mTLS Signed Object**
* ObjectType: mTLS signed Object
* Object: (base64 data - 1,708 base64 chars)

> **NDH Endpoint Usecase**
* endpointUsecasetype: Payer to Payer
* standard: [hl7.org/fhir/us/davinci-pdex](https://simplifier.net/resolve?scope=hl7.fhir.us.core.3.1.1@3.1.1&canonical=http://hl7.org/fhir/us/core/hl7.org/fhir/us/davinci-pdex)

> **NDH FHIR IG**
* ig-publication: [hl7.org/fhir/us/davinci-pdex](https://simplifier.net/resolve?scope=hl7.fhir.us.core.3.1.1@3.1.1&canonical=http://hl7.org/fhir/us/core/hl7.org/fhir/us/davinci-pdex)
* ig-name: Da Vinci Payer Data Exchange
* ig-version: 2.0.0

> **NDH Trust Framework**
* trustFrameworkType: Payer to Payer Trust Network
* qualifier: Yes
* signedArtifact: (base64 data - 1,904 base64 chars)
* publicCertificate: `LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUE1TFA2YXNiZVRuUVlOaEtOUTg3VApUOTZMYkY1ZXVFVEVpMTZXZXR6K1pka1p6dHZ6TnVKQ0hFdUZDTUFCSEMrb25iMGpad3Y1Mk5zU2xkRHRjUjZDCkdzM2xpRzdCUHVUeExTaVgrRTZnbzhBQ0lqSDFCTkZNMC90WmFpZEo5RTRvWnhab09VUm05RFFMN0xUa0M1eGYKMWt0a3k0NHFWck9SWTg3bk1pNHZPc3dSOXZwcVZDNzlYa3lyK3ZlZWJtbFFhVG9NajBpaWVxNDk1Y3hYTmtINgpNZ0Z3Yy9FQTRpdFVZU2E3RzltMmdScmcwVlJrbGw1bTVBaGxWNHduQzZHQ1RmS1NDVmwxM1NFN1hvRm5LNjdYCnlla2E4dDRlcWY3aEVhZEp5WWlVOGNzUkFHT1Q3bm5kNThMcnlheTVxS0FmdEV1bmNEQ2dNbVhWeE9CcDRSb1QKS3dJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==`

> **NDH Dynamic Registration**
* trustProfile: SMART
* version: 1.0

> **NDH Secure Exchange Artifacts**
* secureExchangeArtifactsType: X509 SSL/TLS certificates
* certificate: (base64 data - 10,624 base64 chars)
* expirationDate: 2024-07-07 13:26:22+0000

> **NDH Associated Servers**
* associatedServersType: Authorization/Authentication Server
* serverURL: https://example.com/oauth/registration/

**NDH Endpoint Access Control Mechanism**: Mutual TLS

**NDH Endpoint Connection Type Version**: REST (not FHIR)

**NDH Endpoint Rank**: 1

**NDH Verification Status**: Not Required

**identifier**: Diamond-mtls-endpoint1

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/6.3.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: Payer-Payer Exchange

**managingOrganization**: [Organization DiamondOnyxHealth](Organization-DiamondOnyxHealth1.md)

**payloadType**: Not Applicable

**address**: [https://p2p.diamondonyx.example.com/mtlsendpoint](https://simplifier.net/resolve?scope=hl7.fhir.us.core.3.1.1@3.1.1&canonical=https://p2p.diamondonyx.example.com/mtlsendpoint)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "diamond-mtls-endpoint1",
  "meta" : {
    "lastUpdated" : "2022-07-04T15:00:00.000Z",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/mtls-endpoint"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ObjectType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/MtlsObjectCodeCS",
                "code" : "MTLS",
                "display" : "mTLS signed Object"
              }
            ]
          }
        },
        {
          "url" : "Object",
          "valueBase64Binary" : "MIIE+zCCA+OgAwIBAgISA/DY57CPqtRoFlG0JOdQZnRzMA0GCSqGSIb3DQEBCwUAMDIxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1MZXQncyBFbmNyeXB0MQswCQYDVQQDEwJSMzAeFw0yMzA3MjcwMTU2NTBaFw0yMzEwMjUwMTU2NDlaMCIxIDAeBgNVBAMTF210bHMtZGV2LWRtZGguc2FmaGlyLmlvMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArgSWqFdWPDyX93O9ERnzAzfCqKLFrEsAnOSS5/fyil2qAE85y3/1v8VsrSsiUHz2SUXxQQ0dJGBT3jlZB+KZ9AtNhEAvvQiWtuzNNgO8Q7iVeh/8C+WP7XazGXzaEcpbtOqoM+JGqwWkRu2zlpJmFjAhIIasQMFH2HOWOukRN+8J4n6xy1JqqpDiUc3N77trY+R3PbuEfv0vOLwUYTBq+k1y3gQOy/Xl7l5J9+ugC3ftk+PMmByTbU6+ZDAK6QAGoY2SdwzY4dG36KlYsWA08cvgLUs3IaMxPK008YVx27a6/mJua3xhTnh/6muGyOUpmlYBCJJg43FOskeqNIIxaQIDAQABo4ICGTCCAhUwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMBAf8EAjAAMB0GA1UdDgQWBBT2H5abr3gkO0t5KpwP0K966DCuZTAfBgNVHSMEGDAWgBQULrMXt1hWy65QCUDmH6+dixTCxjBVBggrBgEFBQcBAQRJMEcwIQYIKwYBBQUHMAGGFWh0dHA6Ly9yMy5vLmxlbmNyLm9yZzAiBggrBgEFBQcwAoYWaHR0cDovL3IzLmkubGVuY3Iub3JnLzAiBgNVHREEGzAZghdtdGxzLWRldi1kbWRoLnNhZmhpci5pbzATBgNVHSAEDDAKMAgGBmeBDAECATCCAQQGCisGAQQB1nkCBAIEgfUEgfIA8AB1ALc++yTfnE26dfI5xbpY9Gxd/ELPep81xJ4dCYEl7bSZAAABiZVHEwAAAAQDAEYwRAIgVM1RAExo1mO7EDQ11PFzE6ewkx9TBzSrQMsxX9dkC5QCIA2tta+kt2aSk8lwqLBCEiSSSPXLg/1sbHrODtCjACsZAHcAejKMVNi3LbYg6jjgUh7phBZwMhOFTTvSK8E6V6NS61IAAAGJlUcTCAAABAMASDBGAiEAl1l1FIWpFnVupbIKz+PlPLmgKAtxkJiK6s9uVD1P81MCIQDRsPgnSaFlQbr4KdMc/B3KWZwjkXqoUmI6x1XApPY6gjANBgkqhkiG9w0BAQsFAAOCAQEAhELGwBfs7GsABz5kCUyLunMbdsb6VKjPrBABVTbG9amFcBVxDBSRBNx/NC8itT5k4u2JRnvjVQ/N2vtRqRZR564TwVnMow2ZIW2v9vUhQeX3LkIzzJq0CCLDO39PX1YPUDVCkzH1RV4AxuM26+We4+xmnXixNK6iKJjCvW2S0Q9CA6lQ2COi/tgUq8IIoKy5vFfjHsXul9aGMdzK39fxmO8QRysKBIVWfzb62bUNFO9FGVc7GbEGocqy20TiKBkUjR27T97Q1cMDwtzLwS/G2YKnEVtIJLk/cKG4UKcWx+pCHqvDaHRWUNQ2kofypCS+lLBQFQhXpSG8IwzOww54Kg=="
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-mtls-signedobject-extension"
    },
    {
      "extension" : [
        {
          "url" : "endpointUsecasetype",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhFhirEndpointUseCaseCS",
                "code" : "payerToPayer",
                "display" : "Payer to Payer"
              }
            ]
          }
        },
        {
          "url" : "standard",
          "valueUri" : "hl7.org/fhir/us/davinci-pdex"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-endpoint-usecase"
    },
    {
      "extension" : [
        {
          "url" : "ig-publication",
          "valueUri" : "hl7.org/fhir/us/davinci-pdex"
        },
        {
          "url" : "ig-name",
          "valueString" : "Da Vinci Payer Data Exchange"
        },
        {
          "url" : "ig-version",
          "valueString" : "2.0.0"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-fhir-ig"
    },
    {
      "extension" : [
        {
          "url" : "trustFrameworkType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhTrustFrameworkTypeCS",
                "code" : "PayerToPayer",
                "display" : "Payer to Payer Trust Network"
              }
            ]
          }
        },
        {
          "url" : "qualifier",
          "valueString" : "Yes"
        },
        {
          "url" : "signedArtifact",
          "valueBase64Binary" : "TUlJRUdEQ0NBd0FDRkRadnUxQTdWWTJlT083b2h3Q2ZvMmxFS1hORU1BMEdDU3FHU0liM0RRRUJDd1VBTUlIUQpNUXN3Q1FZRFZRUUdFd0pWVXpFUk1BOEdBMVVFQ0F3SVRXRnllV3hoYm1ReEZUQVRCZ05WQkFjTURGZHBibVJ6CmIzSWdUV2xzYkRFZE1Cc0dBMVVFQ2d3VVQyNTVlQ0JVWldOb2JtOXNiMmQ1TENCTVRFTXhGekFWQmdOVkJBc00KRGxCaGVXVnlMWFJ2TFZCaGVXVnlNVEV3THdZRFZRUUREQ2gwY25WemRDMXRZVzVoWjJWeUxYQmhlV1Z5ZEc5dwpZWGxsY2k1dmJubDRhR1ZoYkhSb0xtbHZNU3d3S2dZSktvWklodmNOQVFrQkZoMXRZWEpyTG5OamNtbHRjMmhwCmNtVkFiMjU1ZUdobFlXeDBhQzVwYnpBZUZ3MHlNekE0TVRFeE5qSTBNakZhRncweU5EQTRNVEF4TmpJME1qRmEKTUlHL01Rc3dDUVlEVlFRR0V3SlZVekVSTUE4R0ExVUVDQXdJVFdGeWVXeGhibVF4RlRBVEJnTlZCQWNNREZkcApibVJ6YjNJZ1RXbHNiREVXTUJRR0ExVUVDZ3dOVDI1NWVFaGxZV3gwYUM1cGJ6RWVNQndHQTFVRUN3d1ZUMjU1CmVFOVRMVkJoZVdWeUxYUnZMVkJoZVdWeU1TQXdIZ1lEVlFRRERCZHRkR3h6TFdSbGRpMWtiV1JvTG5OaFptaHAKY2k1cGJ6RXNNQ29HQ1NxR1NJYjNEUUVKQVJZZGJXRnlheTV6WTNKcGJYTm9hWEpsUUc5dWVYaG9aV0ZzZEdndQphVzh3Z2dFaU1BMEdDU3FHU0liM0RRRUJBUVVBQTRJQkR3QXdnZ0VLQW9JQkFRQ3VCSmFvVjFZOFBKZjNjNzBSCkdmTUROOEtvb3NXc1N3Q2M1SkxuOS9LS1hhb0FUem5MZi9XL3hXeXRLeUpRZlBaSlJmRkJEUjBrWUZQZU9Wa0gKNHBuMEMwMkVRQys5Q0phMjdNMDJBN3hEdUpWNkgvd0w1WS90ZHJNWmZOb1J5bHUwNnFnejRrYXJCYVJHN2JPVwprbVlXTUNFZ2hxeEF3VWZZYzVZNjZSRTM3d25pZnJITFVtcXFrT0pSemMzdnUydGo1SGM5dTRSKy9TODR2QlJoCk1HcjZUWExlQkE3TDllWHVYa24zNjZBTGQrMlQ0OHlZSEpOdFRyNWtNQXJwQUFhaGpaSjNETmpoMGJmb3FWaXgKWURUeHkrQXRTemNob3pFOHJUVHhoWEhidHJyK1ltNXJmR0ZPZUgvcWE0Ykk1U21hVmdFSWttRGpjVTZ5UjZvMApnakZwQWdNQkFBRXdEUVlKS29aSWh2Y05BUUVMQlFBRGdnRUJBS1JpMGlabTFuellmbmZlTXRycjlYaStTQlRFCm1lbktjMlB2N2pEWjRnU1dsejByTXRnTHg2Q2JhMzlwTm03L2drSmZMT2VaUG1kMFJzOVh5a1RQWXVXM0k0VWoKZGprUUk2MVpDZkxGS0szRXVmYVUxYXM1RUQvK1FIQmM2Y25ETVlsMk9nbVJqU1VCVGJkMDByZUR0TjlnUEdXOQpoYzY4cXZpOEhNRDhFZnBOQ1ZWR2lGMlRtdjh3RU1VL0p3TDM0eHJZMmh1bmJ3SWJwOHM2NTJGblQ1Sk93eWUzCjN0c1lENE9zNkVrTnlsY0RjdlRtOFk0ZnEwc0RQbGF3ZFREa3FVNldtTkZUVCtwQzEvNFhTanlzbTV2STd0eTUKd0hLWkVnOXBZS05yVW9YYWpYdzB1WTJIVzdXcy8xUW5aS3gyalFGb1lQRG0xOXRPdXRjY0RoSDRYdDA9Cg=="
        },
        {
          "url" : "publicCertificate",
          "valueBase64Binary" : "LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUE1TFA2YXNiZVRuUVlOaEtOUTg3VApUOTZMYkY1ZXVFVEVpMTZXZXR6K1pka1p6dHZ6TnVKQ0hFdUZDTUFCSEMrb25iMGpad3Y1Mk5zU2xkRHRjUjZDCkdzM2xpRzdCUHVUeExTaVgrRTZnbzhBQ0lqSDFCTkZNMC90WmFpZEo5RTRvWnhab09VUm05RFFMN0xUa0M1eGYKMWt0a3k0NHFWck9SWTg3bk1pNHZPc3dSOXZwcVZDNzlYa3lyK3ZlZWJtbFFhVG9NajBpaWVxNDk1Y3hYTmtINgpNZ0Z3Yy9FQTRpdFVZU2E3RzltMmdScmcwVlJrbGw1bTVBaGxWNHduQzZHQ1RmS1NDVmwxM1NFN1hvRm5LNjdYCnlla2E4dDRlcWY3aEVhZEp5WWlVOGNzUkFHT1Q3bm5kNThMcnlheTVxS0FmdEV1bmNEQ2dNbVhWeE9CcDRSb1QKS3dJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg=="
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-trustFramework"
    },
    {
      "extension" : [
        {
          "url" : "trustProfile",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhTrustProfileCS",
                "code" : "smart",
                "display" : "SMART"
              }
            ]
          }
        },
        {
          "url" : "version",
          "valueString" : "1.0"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-dynamicRegistration"
    },
    {
      "extension" : [
        {
          "url" : "secureExchangeArtifactsType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhSecureExchangeArtifactsCS",
                "code" : "x509-ssl-tls-certificates"
              }
            ]
          }
        },
        {
          "url" : "certificate",
          "valueBase64Binary" : "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"
        },
        {
          "url" : "expirationDate",
          "valueDateTime" : "2024-07-07T13:26:22.0314215+00:00"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-secureExchangeArtifacts"
    },
    {
      "extension" : [
        {
          "url" : "associatedServersType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhAssociatedServersTypeCS",
                "code" : "authorization-authentication-server",
                "display" : "Authorization/Authentication Server"
              }
            ]
          }
        },
        {
          "url" : "serverURL",
          "valueString" : "https://example.com/oauth/registration/"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-associatedServers"
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-endpointAccessControlMechanism",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/EndpointAccessControlMechanismCS",
            "code" : "mutual-tls",
            "display" : "Mutual TLS"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/ndh/StructureDefinition/base-ext-endpoint-connection-type-version",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhEndpointConnectionTypeCS",
            "code" : "rest-non-fhir",
            "display" : "REST (not FHIR)"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-endpoint-rank",
      "valuePositiveInt" : 1
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-verification-status",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/ndh/CodeSystem/NdhVerificationStatusCS",
            "code" : "not-required",
            "display" : "Not Required"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "value" : "Diamond-mtls-endpoint1"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest",
    "display" : "HL7 FHIR"
  },
  "name" : "Payer-Payer Exchange",
  "managingOrganization" : {
    "reference" : "Organization/DiamondOnyxHealth1"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
          "code" : "not-applicable",
          "display" : "Not Applicable"
        }
      ]
    }
  ],
  "address" : "https://p2p.diamondonyx.example.com/mtlsendpoint"
}

```
