# example-mtls-endpoint-bundle - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **example-mtls-endpoint-bundle**

## Example Bundle: example-mtls-endpoint-bundle



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-mtls-endpoint-bundle",
  "meta" : {
    "lastUpdated" : "2022-07-04T15:00:00.000Z",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/mtls-bundle"
    ]
  },
  "type" : "collection",
  "timestamp" : "2022-07-04T15:00:00.000Z",
  "link" : [
    {
      "relation" : "self",
      "url" : "https://example.com/base/fhir/Bundle?ct=W3sidG9rZW4iOiIrUklEOn53MThjQUk5RlVPZ0lEQUFBQUFBQU"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://example.com/base/fhir/Organization/DiamondOnyxHealth2",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "DiamondOnyxHealth2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_DiamondOnyxHealth2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization DiamondOnyxHealth2</b></p><a name=\"DiamondOnyxHealth2\"> </a><a name=\"hcDiamondOnyxHealth2\"> </a><p><b>identifier</b>: DiamondOnyxHealth2</p></div>"
        },
        "identifier" : [
          {
            "value" : "DiamondOnyxHealth2"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/base/fhir/Endpoint/Diamond-mtls-endpoint2",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "Diamond-mtls-endpoint2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_Diamond-mtls-endpoint2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint Diamond-mtls-endpoint2</b></p><a name=\"Diamond-mtls-endpoint2\"> </a><a name=\"hcDiamond-mtls-endpoint2\"> </a><p><b>identifier</b>: Diamond-mtls-endpoint2</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.3.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: Payer-Payer Exchange</p><p><b>managingOrganization</b>: <a href=\"Organization-DiamondOnyxHealth1.html\">Organization DiamondOnyxHealth</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/data-absent-reason not-applicable}\">Not Applicable</span></p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=hl7.fhir.us.core.3.1.1@3.1.1&amp;canonical=https://mtls-dev-dmdh.safhir.io/mtlsendpoint\">https://mtls-dev-dmdh.safhir.io/mtlsendpoint</a></p></div>"
        },
        "identifier" : [
          {
            "value" : "Diamond-mtls-endpoint2"
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest",
          "display" : "HL7 FHIR"
        },
        "name" : "Payer-Payer Exchange",
        "managingOrganization" : {
          "reference" : "Organization/DiamondOnyxHealth1"
        },
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
                "code" : "not-applicable",
                "display" : "Not Applicable"
              }
            ]
          }
        ],
        "address" : "https://mtls-dev-dmdh.safhir.io/mtlsendpoint"
      }
    },
    {
      "fullUrl" : "https://example.com/base/fhir/Organization/DiamondOnyxHealth3",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "DiamondOnyxHealth3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_DiamondOnyxHealth3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization DiamondOnyxHealth3</b></p><a name=\"DiamondOnyxHealth3\"> </a><a name=\"hcDiamondOnyxHealth3\"> </a><p><b>identifier</b>: DiamondOnyxHealth3</p></div>"
        },
        "identifier" : [
          {
            "value" : "DiamondOnyxHealth3"
          }
        ]
      }
    }
  ],
  "signature" : {
    "type" : [
      {
        "system" : "urn:iso-astm:E1762-95:2013",
        "code" : "1.2.840.10065.1.12.1.1",
        "display" : "Author's Signature"
      }
    ],
    "when" : "2022-07-04T15:00:00.000Z",
    "who" : {
      "reference" : "Organization/DiamondOnyxHealth2"
    },
    "sigFormat" : "application/x-x509-ca-cert",
    "data" : "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"
  }
}

```
