# BundleConditionWithProvenance - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **BundleConditionWithProvenance**

## Example Bundle: BundleConditionWithProvenance



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "3000003",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/Bundle"]
  },
  "type" : "searchset",
  "timestamp" : "2020-09-28T23:26:23.217+00:00",
  "total" : 2,
  "link" : [
    {
      "relation" : "self",
      "url" : "https://example.com/base/fhir/Condition?ct=W1sidG9rZW4iOiIrUklEOn53MThjQUk5RlVPZ0lEQUFBQUFBQU"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://example.com/base/Condition/101",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "101",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_101\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition 101</b></p><a name=\"101\"> </a><a name=\"hc101\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 442311008}\">liveborn born in hospital</span></p><p><b>subject</b>: <a href=\"Patient-1.html\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</a></p><p><b>onset</b>: 1995-09-20</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "442311008",
              "display" : "liveborn born in hospital"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/1"
        },
        "onsetDateTime" : "1995-09-20"
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Condition/102",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "102",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_102\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition 102</b></p><a name=\"102\"> </a><a name=\"hc102\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 247824007}\">Fear of becoming fat</span></p><p><b>subject</b>: <a href=\"Patient-1.html\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</a></p><p><b>onset</b>: 2020-03-13</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "247824007",
              "display" : "Fear of becoming fat"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/1"
        },
        "onsetDateTime" : "2020-03-13"
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Provenance/3101",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "3101",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2020-09-28T23:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-provenance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_3101\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance 3101</b></p><a name=\"3101\"> </a><a name=\"hc3101\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2020-09-28 23:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-pdex-provenance.html\">PDex Provenance</a></p></div><p>Provenance for <a href=\"Bundle-3000003.html#Condition_101\">Condition liveborn born in hospital</a></p><p>Summary</p><table class=\"grid\"><tr><td>Recorded</td><td>1995-09-20 18:26:23+0000</td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td><a href=\"Organization-ProviderOrg2.html\">Organization Provider 2</a></td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "Condition/101"
          }
        ],
        "recorded" : "1995-09-20T18:26:23.217+00:00",
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author",
                  "display" : "Author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/ProviderOrg2"
            }
          }
        ],
        "entity" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/ProvenanceSourceFrom",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/ProvenancePayerDataSource",
                      "code" : "hl7ccda",
                      "display" : "HL7 C-CDA"
                    }
                  ]
                }
              }
            ],
            "role" : "source",
            "what" : {
              "display" : "No reference available"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    }
  ]
}

```
