<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile MeasureReport
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:MeasureReport</sch:title>
    <sch:rule context="f:MeasureReport">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingProgram']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingProgram': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-category|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-category|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-inputParameters|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-inputParameters|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingVendor']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingVendor': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-certificationIdentifier']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-certificationIdentifier': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-messages|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-messages|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:date) &gt;= 1">date: minimum cardinality of 'date' is 1</sch:assert>
      <sch:assert test="count(f:reporter) &gt;= 1">reporter: minimum cardinality of 'reporter' is 1</sch:assert>
      <sch:assert test="count(f:group) &gt;= 1">group: minimum cardinality of 'group' is 1</sch:assert>
      <sch:assert test="count(f:evaluatedResource) &lt;= 0">evaluatedResource: maximum cardinality of 'evaluatedResource' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:extension</sch:title>
    <sch:rule context="f:MeasureReport/f:extension">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:url) &gt;= 1">url: minimum cardinality of 'url' is 1</sch:assert>
      <sch:assert test="count(f:url) &lt;= 1">url: maximum cardinality of 'url' is 1</sch:assert>
      <sch:assert test="count(f:value[x]) &gt;= 1">value[x]: minimum cardinality of 'value[x]' is 1</sch:assert>
      <sch:assert test="count(f:value[x]) &lt;= 1">value[x]: maximum cardinality of 'value[x]' is 1</sch:assert>
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:url) &gt;= 1">url: minimum cardinality of 'url' is 1</sch:assert>
      <sch:assert test="count(f:url) &lt;= 1">url: maximum cardinality of 'url' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:extension/f:value[x] 1</sch:title>
    <sch:rule context="f:MeasureReport/f:extension/f:value[x]">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 1">reference: maximum cardinality of 'reference' is 1</sch:assert>
      <sch:assert test="count(f:type) &lt;= 1">type: maximum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:identifier) &lt;= 1">identifier: maximum cardinality of 'identifier' is 1</sch:assert>
      <sch:assert test="count(f:display) &lt;= 1">display: maximum cardinality of 'display' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:reporter</sch:title>
    <sch:rule context="f:MeasureReport/f:reporter">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reporterGroup']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reporterGroup': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 1">reference: maximum cardinality of 'reference' is 1</sch:assert>
      <sch:assert test="count(f:type) &lt;= 1">type: maximum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:identifier) &lt;= 1">identifier: maximum cardinality of 'identifier' is 1</sch:assert>
      <sch:assert test="count(f:display) &lt;= 1">display: maximum cardinality of 'display' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:period</sch:title>
    <sch:rule context="f:MeasureReport/f:period">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:start) &gt;= 1">start: minimum cardinality of 'start' is 1</sch:assert>
      <sch:assert test="count(f:start) &lt;= 1">start: maximum cardinality of 'start' is 1</sch:assert>
      <sch:assert test="count(f:end) &gt;= 1">end: minimum cardinality of 'end' is 1</sch:assert>
      <sch:assert test="count(f:end) &lt;= 1">end: maximum cardinality of 'end' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group</sch:title>
    <sch:rule context="f:MeasureReport/f:group">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-calculatedDate']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-calculatedDate': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-groupImprovementNotation']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-groupImprovementNotation': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:population</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:population">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-countQuantity|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-countQuantity|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:subjectResults) &gt;= 1">subjectResults: minimum cardinality of 'subjectResults' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:measureScore</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:measureScore">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:comparator) &lt;= 1">comparator: maximum cardinality of 'comparator' is 1</sch:assert>
      <sch:assert test="count(f:unit) &lt;= 1">unit: maximum cardinality of 'unit' is 1</sch:assert>
      <sch:assert test="count(f:system) &lt;= 1">system: maximum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:stratifier</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:stratifier">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:stratifier/f:stratum/f:population</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:stratifier/f:stratum/f:population">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-countQuantity|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-countQuantity|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:count) &gt;= 1">count: minimum cardinality of 'count' is 1</sch:assert>
      <sch:assert test="count(f:subjectResults) &gt;= 1">subjectResults: minimum cardinality of 'subjectResults' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:stratifier/f:stratum/f:measureScore</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:stratifier/f:stratum/f:measureScore">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:comparator) &lt;= 1">comparator: maximum cardinality of 'comparator' is 1</sch:assert>
      <sch:assert test="count(f:unit) &lt;= 1">unit: maximum cardinality of 'unit' is 1</sch:assert>
      <sch:assert test="count(f:system) &lt;= 1">system: maximum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
