
Payers and providers need common data specification, measure specification, report initiation, and transport to share the data required to reflect accurate quality measures. Existing QI-Core and CQFM profiles are used as well as DEQM profiles derived from QI-Core and CQFM profiles and defined in this guide. All of these profiles provide a common foundation for building, sharing, and evaluating knowledge artifacts across quality improvement efforts in the US Realm.  For elements added in FHIR R4, extensions have been created for the STU3 version.

### Profiles

|Resource Type|Profile Name|Link to Profile|
|---|---|---|
|MeasureReport|DEQM Data Exchange MeasureReport Profile|[DEQM Data Exchange MeasureReport Profile]|
|MeasureReport|DEQM Individual MeasureReport Profile|[DEQM Individual MeasureReport Profile]|
|MeasureReport|DEQM Summary MeasureReport Profile|[DEQM Summary MeasureReport Profile]|
|List|DEQM Individual MeasureReport List|[DEQM Individual MeasureReport List]|
|MeasureReport|DEQM Subject List MeasureReport Profile|[DEQM Subject List MeasureReport Profile]|
|Bundle|DEQM Gaps In Care Bundle Profile|[DEQM Gaps In Care Bundle Profile]|
|Composition|DEQM Gaps In Care Composition Profile|[DEQM Gaps In Care Composition Profile]|
|DetectedIssue|DEQM Gaps In Care DetectedIssue Profile|[DEQM Gaps In Care DetectedIssue Profile]|
|Group|DEQM Gaps In Care Group Profile|[DEQM Gaps In Care Group Profile]|
|GuidanceResponse|DEQM Care Gap Guidance Response|[DEQM Care Gap Guidance Response]|

### Extensions

| Link to Profile                                                                                     |
|-----------------------------------------------------------------------------------------------------|
| [DEQM Measure Scoring Extension](StructureDefinition-extension-measureScoring.html)                 |
| [DEQM Alternate Score Type Extension](StructureDefinition-extension-alternateScoreType.html)        |
| [DEQM Reporter Group Extension Extension](StructureDefinition-extension-reporterGroup.html)         |
| [DEQM Reporting Vendor Extension](StructureDefinition-extension-reportingVendor.html)               |
| [DEQM Certification Identifier Extension](StructureDefinition-extension-certificationIdentifier.html) |
| [DEQM Submit Data Update Type Extension](StructureDefinition-extension-submitDataUpdateType.html)   |
| [DEQM Criteria Reference Extension](StructureDefinition-extension-criteriaReference.html)           |
| [DEQM Gap Status Extension (Modifier)](StructureDefinition-extension-gapStatus.html)                |
| [DEQM Data Location Extension](StructureDefinition-extension-dataLocation.html)                |
| [DEQM Group Improvement Notation Extension](StructureDefinition-extension-groupImprovementNotation.html)                |
| [DEQM Reporting Program Extension](StructureDefinition-extension-reportingProgram.html) |
| [DEQM Calculated Date Extension](StructureDefinition-extension-calculatedDate.html)                |  
| [DEQM Measure Report Population Description Extension](StructureDefinition-extension-populationDescription.html) |
| [DEQM Care Gap Remark Extension](StructureDefinition-extension-careGapRemark.html) |

{% include link-list.md %}
