
## All DEQM examples can be downloaded as a zip on the [Downloads page](downloads.html)

### MeasureReports

#### General MeasureReports
* [Example MeasureReport: Datax Measurereport01](MeasureReport-datax-measurereport01.html)
* [Example MeasureReport: Gaps Individual MeasureReport04](MeasureReport-gaps-indv-measurereport04.html)
* [Example MeasureReport: Indv Measurereport01](MeasureReport-indv-measurereport01.html)
* [Example MeasureReport: Subject List MeasureReport01](MeasureReport-subjectlist-measurereport01.html)
* [Example MeasureReport: Summ Measurereport02](MeasureReport-summ-measurereport02.html)

#### Stratification MeasureReports
* [Example MeasureReport: Indv Measurreport Stratification Example](MeasureReport-indv-measurreport-stratification-example.html)
* [Example MeasureReport: Summ Medicare Stratification Example](MeasureReport-summ-medicare-stratification-example.html)

#### Supplemental Data Element (SDE) Measure Report
* [Example MeasureReport: Additional Supplemental Data Example](MeasureReport-sde-example.html)

#### Scoring Type MeasureReports
* [Example MeasureReport: Gaps Ratio MeasureReport01](MeasureReport-ratio-measurereport01.html)
* [Example MeasureReport: Summary MeasureReport Date of Last Power Outage](MeasureReport-date-of-last-power-outage.html)
* [Example MeasureReport: MeasureReport Attestation Boolean](MeasureReport-attestation-boolean-example.html)
* [Example MeasureReport: MeasureReport-PI-example](MeasureReport-MeasureReport-PI-example.html)

### Bundles
Below are examples of Bundle resources.

#### MeasureReport Bundles
* [Example Bundle: Single Indv Vte Report Option 1](Bundle-single-indv-vte-report-option1.html)
* [Example Bundle: Single Indv Vte Report Option 7](Bundle-single-indv-vte-report-option7.html)
* [Example Bundle: Single Indv Mrp Task Report](Bundle-single-indv-mrp-task-report.html)
* [Example Bundle: Single Indv Mrp Obs Report](Bundle-single-indv-mrp-obs-report.html)
* [Example Bundle: Single Indv Col Obs Report](Bundle-single-indv-col-obs-report.html)
* [Example Bundle: Multiple Summ Report](Bundle-multiple-summ-report.html)

#### Gaps In Care Bundles
* [Example Bundle: Gaps Bundle Open Individual MeasureReports](Bundle-single-gaps-open-indv-report01.html)
* [Example Bundle: Gaps Bundle Closed Individual MeasureReport01](Bundle-single-gaps-closed-indv-report01.html)
* [Example Bundle: Gaps Non-Document Gaps In Care Report](Bundle-non-document-gaps-in-care.html)

### Ad-hoc Organization
* [Example Organization: Ad Hoc Operation Input Example](Organization-ad-hoc-organization.html)

### Measures
Below are the Measures used by the MeasureReports above that are defined in this IG.
* [Measure: Immunization Registry Reporting (Experimental)](Measure-attestation-boolean-example.html)
* [Measure: EXM124 - Cervical Cancer Screening (Experimental) ](https://hl7.org/fhir/us/cqfmeasures/Measure-EXM124-FHIR.html)
* [COL Colorectal Cancer Screening EXM130](https://hl7.org/fhir/us/cqfmeasures/Measure-EXM130-FHIR.html)
* [Measure: Measure Date of Last Power Outage (Experimental)](Measure-date-of-last-power-outage.html)
* [Measure: EXM55 - Median Emergency Department Visit Duration (Experimental)](https://hl7.org/fhir/us/cqfmeasures/Measure-EXM55-FHIR.html)
* [Measure: Measure Mrp Example (Experimental)](Measure-measure-mrp-example.html)
* [Measure: EXMPromotingInteroperabilityMeasure (Experimental) ](Measure-measure-pi-example.html)
* [Measure: EXM108 - Venous Thromboembolism Prophylaxis (Experimental) ](https://hl7.org/fhir/us/cqfmeasures/Measure-EXM108-FHIR.html)

#### Da Vinci VBPR Examples
The Da Vinci Value-Based Performance Reporting IG uses DEQM as a dependency. In addition to the above DEQM examples, 
the [Value-Based Performance Reporting Examples](https://build.fhir.org/ig/HL7/davinci-vbpr/examples.html) provides additional 
measure report examples based on the [DEQM Summary MeasureReport Profile](StructureDefinition-summary-measurereport-deqm.html).

### Other Support Resources
Below are the resources that are referenced by the examples above.
#### Composition
* [Example Composition: Gaps Composition01](Composition-gaps-composition01.html)
* [Example Composition: Gaps Composition02](Composition-gaps-composition02.html)
* [Example Composition: Gaps Composition03](Composition-gaps-composition03.html)

#### Coverage
* [Example Coverage: Coverage01](Coverage-coverage01.html)

#### DetectedIssue
* [Example DetectedIssue: Gaps DetectedIssue01](DetectedIssue-gaps-detectedissue01.html)
* [Example DetectedIssue: Gaps DetectedIssue02](DetectedIssue-gaps-detectedissue02.html)
* [Example DetectedIssue: Gaps DetectedIssue03](DetectedIssue-gaps-detectedissue03.html)
* [Example DetectedIssue: Gaps DetectedIssue04](DetectedIssue-gaps-detectedissue04.html)
* [Example DetectedIssue: Gaps DetectedIssue05](DetectedIssue-gaps-detectedissue05.html)

#### Device
* [Example Device: DEQM Software System Example](Device-deqm-software-system-example.html)

#### Encounter
* [Example Encounter: Encounter01](Encounter-encounter01.html)
* [Example Encounter: Encounter02](Encounter-encounter02.html)
* [Example Encounter: Encounter03](Encounter-encounter03.html)
* [Example Encounter: Gaps Encounter01](Encounter-gaps-encounter01.html)
* [Example Encounter: Gaps Encounter02](Encounter-gaps-encounter02.html)
* [Example Encounter: Gaps Encounter03](Encounter-gaps-encounter03.html)

#### Group
* [Example Group: Group01](Group-group01.html)
* [Example Group: Gaps Group01 subject](Group-gaps-subject-group01.html)

#### GuidanceResponse
* [Example GuidanceResponse: Guidance Response Example](GuidanceResponse-guidanceresponse01.html)
* [Example GuidanceResponse: DetailedGuidanceResponse01](GuidanceResponse-detailedguidanceresponse01.html)
* [Example GuidanceResponse: DetailedGuidanceResponse02](GuidanceResponse-detailedguidanceresponse02.html)

#### Library
* [Library: Library Mrp Example](Library-library-mrp-example.html)
* [Library: Library Colorectal Cancer Screening (EXM130) (Experimental)](Library-library-exm130-example.html)
* [Library: Library Cervical Cancer Screening (EXM124) (Experimental)](Library-library-exm124-example.html)

#### Location
* [Example Location: Location01](Location-location01.html)
* [Example Location: Location02](Location-location02.html)
* [Example Location: Location03](Location-location03.html)

#### Observation
* [Example Observation: Observation01](Observation-observation01.html)
* [Example Observation: Observation02](Observation-observation02.html)
* [Example Observation: Observation03](Observation-observation03.html)
* [Example Observation: DNA Occult Blood](Observation-DNA-occultblood.html)

#### Organization
* [Example Organization: Organization01](Organization-organization01.html)
* [Example Organization: Organization02](Organization-organization02.html)
* [Example Organization: Organization03](Organization-organization03.html)
* [Example Organization: Organization04](Organization-organization04.html)
* [Example Organization: Gaps Reporting Vendor Organization](Organization-gaps-organization-reportingvendor.html)

#### Parameters
* [Example Parameters: Mrp Submit Task](Parameters-mrp-submit-task.html)
* [Example Parameters: Col Collect Obs](Parameters-col-collect-obs.html)
* [Example Parameters: Col Submit Obs](Parameters-col-submit-obs.html)
* [Example Parameters: Mrp Submit Obs](Parameters-mrp-submit-obs.html)
* [Example Parameters: Gaps Parameters Open Individual MeasureReports](Parameters-single-gaps-open-indv-report01.html)
* [Example Parameters: Gaps Parameters Closed Individual MeasureReport01](Parameters-single-gaps-closed-indv-report01.html)
* [Example Parameters: Gaps Parameters Closed Individual MeasureReport02](Parameters-single-gaps-closed-indv-report02.html)
* [Example Parameters: Gaps Multiple Parameters Individual MeasureReports01](Parameters-multiple-gaps-indv-report01.html)
* [Example Parameters: Gaps Multiple Parameters Individual MeasureReports02](Parameters-multiple-gaps-indv-report02.html)

#### Patient
* [Example Patient: Patient02](Patient-patient02.html)
* [Example Patient: Patient03](Patient-patient03.html)
* [Example Patient: Gaps Patient01](Patient-gaps-patient01.html)
* [Example Patient: Gaps Patient02](Patient-gaps-patient02.html)
* [Example Patient: Patient01](Patient-patient01.html)

#### Practitioner
* [Example Practitioner: Practitioner01](Practitioner-practitioner01.html)
* [Example Practitioner: Practitioner02](Practitioner-practitioner02.html)
* [Example Practitioner: Practitioner03](Practitioner-practitioner03.html)

#### Procedure
* [Example Procedure: Gaps Procedure01](Procedure-gaps-procedure01.html)
* [Example Procedure: Gaps Procedure02](Procedure-gaps-procedure02.html)

#### Task
* [Example Task: Task01](Task-task01.html)
* [Example Task: Task02](Task-task02.html)
* [Example Task: Task03](Task-task03.html)

<!-- ================================================ -->
<!--  use this line to include an autogenerated list of all examples from the remove it if you would like to hand generate it -->

<!-- {% include example-list-generator.md %} -->
<!-- ================================================ -->
