<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile MeasureReport
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:MeasureReport</sch:title>
    <sch:rule context="f:MeasureReport">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-submitDataUpdateType']) &gt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-submitDataUpdateType': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-submitDataUpdateType']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-submitDataUpdateType': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-category|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-category|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingVendor']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingVendor': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-messages|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-messages|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-inputParameters|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-inputParameters|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:subject) &gt;= 1">subject: minimum cardinality of 'subject' is 1</sch:assert>
      <sch:assert test="count(f:date) &gt;= 1">date: minimum cardinality of 'date' is 1</sch:assert>
      <sch:assert test="count(f:reporter) &gt;= 1">reporter: minimum cardinality of 'reporter' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:reporter</sch:title>
    <sch:rule context="f:MeasureReport/f:reporter">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reporterGroup']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reporterGroup': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 1">reference: maximum cardinality of 'reference' is 1</sch:assert>
      <sch:assert test="count(f:type) &lt;= 1">type: maximum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:identifier) &lt;= 1">identifier: maximum cardinality of 'identifier' is 1</sch:assert>
      <sch:assert test="count(f:display) &lt;= 1">display: maximum cardinality of 'display' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:period</sch:title>
    <sch:rule context="f:MeasureReport/f:period">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:start) &gt;= 1">start: minimum cardinality of 'start' is 1</sch:assert>
      <sch:assert test="count(f:start) &lt;= 1">start: maximum cardinality of 'start' is 1</sch:assert>
      <sch:assert test="count(f:end) &gt;= 1">end: minimum cardinality of 'end' is 1</sch:assert>
      <sch:assert test="count(f:end) &lt;= 1">end: maximum cardinality of 'end' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group</sch:title>
    <sch:rule context="f:MeasureReport/f:group">
      <sch:assert test="count(f:measureScore) &lt;= 0">measureScore: maximum cardinality of 'measureScore' is 0</sch:assert>
      <sch:assert test="count(f:stratifier) &lt;= 0">stratifier: maximum cardinality of 'stratifier' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:population</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:population">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-populationDescription|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
