# CRD Metrics - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CRD Metrics

This Implementation Guide (IG) is one of 4 HL7 Da Vinci IGs that are designed to address the challenges of automating the exchange of information between a provider and the responsible payer to determine coverage of services, items, and referrals. In particular, these IGs standardize the exchange of information required to automate the Prior Authorization (PA) process. The specific IG are:

1. Coverage Requirements Discovery (CRD) (this IG)
1. [Documentation Templates and Rules (DTR)](http://hl7.org/fhir/us/davinci-dtr)
1. [Prior Authorization Support (PAS)](http://hl7.org/fhir/us/davinci-pas)
1. [Clinical Documentation Exchange (CDex)](http://hl7.org/fhir/us/davinci-cdex)

Each guide supports a specific set of functions and exchanges required to determine payer coverage for specific services, items, and referrals.

To maximize the value of these IGs, it is imperative that each IG is integrated into clinical workflow at the appropriate point and all the exchanges required by each IG are fully supported by all the participants (providers, intermediaries, and payers).

§metric-1^crd-client,crd-server^storage:Each of these IGs recommends a set of metrics that **SHOULD** or **MAY** be collected by their respective implementations to facilitate the evaluation of adoption, functionality, processes, and improved outcomes.§ While there are current and proposed state requirements for prior authorization metric reporting, at the time of publication there is no requirement to report on the metrics defined here. However, it is reasonable to believe that in the future interested entities (providers, payers, regulators, quality organizations, certification agencies, states, etc.) will ask for these metrics to evaluate the ongoing automation of the supported processes / exchanges. While this guide will not require these metrics to be captured in this release, the authors strongly recommend that each implementation do so with the expectation that collection and dissemination of these metrics may become a requirement ('SHALL') in future version of these IGs.

The table below defines a set of measures with a short name, purpose, conformance, stakeholder, and collection/calculation instructions that represent what the project group designing this IG felt would be both reasonably collectable and useful in evaluating implementations of this IG. These measures are based on the [metric data model logical model](StructureDefinition-CRDMetricData.md) also published in this IG.

### Suggested Metrics

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| 1 | Volume/% of orders/appointments with results (coverage info) returned | Adoption Process | Both | *For volume:*`CRDMetricData.request.exists(response.coverageInfo).count()`*For percent:*Divide volume above by`CRDMetricData.where(httpResponse=200).request.count()`and express as percentage |
| 2 | % of orders/appointments by coverage response type (covered, not covered, conditional) | Segmentation | Both | *For volume:*Iterate where $ResponseType is one of covered, not-covered, conditional`CRDMetricData.request.exists(response.coverageInfo.where(covered=$ResponseType)).count()`*For percent:*Divide volume above by`CRDMetricData.where(httpResponse=200).request.count()`and express as percentage |
| 3 | Volume/% of orders/appointments with PA required with DTR launch context | Process Compliance | Both | *For volume:*`CRDMetricData.request.exists(response.coverageInfo.where(paNeeded = "auth-needed" and questionnaire.exists())).count()`*For percent:*divide volume above by`CRDMetricData.request.exists(response.coverageInfo.where(paNeeded = 'auth-needed')).count()`and express as percentage |
| 4 | Volume/% of orders/appointments with Documentation required with DTR launch context | Adoption | Both | *For volume:*`CRDMetricData.request.where(response.coverageInfo.where((docNeeded='clinical' or docNeeded='admin' or docNeeded='both') and questionnaire.exists())).count()`*For percent:*divide volume above by`CRDMetricData.request.exists(response.coverageInfo.where(docNeeded='clinical' or docNeeded='admin' or docNeeded='both')).count()`and express as percentage |
| 5 | Volume/% orders/appointments with (potentially conditional) service determination | Adoption Process | Both | *For volume:*`CRDMetricData.request.where(response.coverageInfo.exists(paNeeded = 'satisfied')).count()`*For percent:*divide volume above by`CRDMetricData.where(httpResponse=200).request.count()`and express as percentage |
| 6 | % requests with resposnes in under 5 seconds | Process Compliance | Both | `CRDMetricData.where(httpResponse=200 and (requestTime + 5 seconds > responseTime)).count() / CRDMetricData.where(httpResponse=200).count()`and express as percentage |
| 7 | Reduction in PA submission (relative to current practice) | Outcome | Both | Needs information external to CRD metric data |
| 8 | All the above by payer for provider metrics and for provider for payer metrics | Segmentation | Both | Segmentation based on CRDMetricData.source and (CRDMetricData.payerID or CRDMetricData.groupID) |
| 9 | All the above by hook type | Segmentation | Both | Segmentation based on CRDMetricData.hookType |

