# CRD IG Home Page - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CRD IG Home Page

> Welcome to the post-ballot public review for the STU 2.2 release of the Da Vinci Coverage Requirements Discovery (CRD) implementation guide.As a result of ballot feedback, a number of [additional changes](history.md#release-220-snapshot) have been made to the IG, some of them substantive. Because of these substantive changes, we're providing an opportunity for the community to perform an additional layer of review to the changes. Feedback on this release should be limited to only those aspects of the specification changed since the ballot, though technical corrections identifying issues with spelling, grammar, formatting, broken links, etc. are welcome for any portion of the specification. Feedback submitted against other parts of the specification will likely be deferred to a future release, particularly if they would involve substantive change, though all feedback provided will be considered at some point.Feedback on changes made since the ballot will generally fall into one of two categories:
* The change was not made as agreed or accidentally introduced a new issue. (Please check for situations where an agreed change was subsequently overridden by a subsequent change.)
* The commenter disagrees with some of the changes made. While the project **can** revisit decisions, doing so requires convincing new arguments not already discussed and considered by the regular project calls. Therefore, be sure to provide clear justification for any request to revisit and be aware that those attending the calls may quickly find the issue non-persuasive if there have not been new, not previously discussed, considerations identified.
Feedback should be provided using HL7's [Jira mechanism](https://jira.hl7.org/secure/CreateIssueDetails!init.jspa?pid=10405&issuetype=10600&customfield_11302=FHIR-us-davinci-crd), though discussion on the [HRex Zulip stream](https://chat.fhir.org/#narrow/stream/180803-Da-Vinci-CRD) is also welcome.

> This STU update of the specification reflects several changes based on implementer feedback about the Coverage Requirements Discovery (hereafter, CRD) specification arising from detailed review, connectathons and implementation experience. "STU notes" call out additional key considerations where feedback is desired.This specification is a Standard for Trial Use. It is expected to continue to evolve and improve through connectathon testing and feedback from early adopters.Feedback is welcome and may be submitted through the [FHIR change tracker](http://hl7.org/fhir-issues) indicating "US Da Vinci CRD" as the specification.This implementation guide is dependent on other specifications. Please submit any comments you have on these base specifications as follows:
* Feedback on CDS Hooks should be posted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "CDS Hooks" as the specification.
* Feedback on the FHIR Core specification should be submitted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "FHIR Core" as the specification.
* Feedback on the US Core profiles should be submitted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "US Core" as the specification.
Individuals interested in participating in the Coverage Requirements Discovery implementation guide project or other HL7 Da Vinci projects can find information about Da Vinci [here](http://www.hl7.org/about/davinci).A summary of the major changes from the previous release can be found [here](history.md).

### Overview

The process of billing a patient's insurance provider is complex and costly, particularly in the United States. Healthcare providers work with a range of payers who provide coverage for the products and clinical services provided to patients. Each payer offers distinct insurance plans for healthcare products and services, and each has its own unique process to determine whether each service is necessary and appropriate. These processes have many different requirements for documentation, prior authorization, or other approval steps. Claims submitted for payment that do not meet payer requirements will typically be denied, which may result in service delay, resubmission, or appeal. These delays and additional processes may result in negative health outcomes or financial costs for patients, as well as financial and productivity losses for providers.

This Coverage Requirements Discovery (CRD) implementation guide defines a workflow in which a payer makes coverage requirement information available to a healthcare provider within the provider's software system at the point of care where treatment decisions are made. This will help clinicians and administrative staff make informed recommendations to their patients and meet payer submission requirements.

This implementation guide supports both Protected Health Information (PHI)-specific and non-PHI mechanisms for CRD to meet the needs and privileges of different payer organizations. These mechanisms will allow payers to share a wide variety of information with providers in a context-sensitive manner including:

* updates to coverage information
* alternative (e.g. first-line, lower-cost, etc.) services or products
* documentation requirements and rules related to coverage
* forms and templates to complete
* indications of whether a therapy is covered and if prior authorization is required, including propagating this information into the relevant order/appointment

This implementation guide is designed to allow for initial support of basic capabilities and to subsequently build new features over time.

> The scope of this specification has increased to also support prior authorization process earlier in the workflow by allowing prior authorization to be returned during the CRD interaction. Specifically:On Feb 28, 2024, the Office of Burden Reduction and Health Informatics (OBRHI) National Standards Group (NSG) announced an [enforcement discretion](https://www.cms.gov/files/document/discretion-x12-278-enforcement-guidance-letter-remediated-2024-02-28.pdf) that they would not enforce the requirement to use the X12 278 for prior authorization if the covered entities were using the FHIR-based Prior Authorization API as described in the CMS Interoperability and Prior Authorization final rule (CMS-0057-F). This allows payers to return a prior authorization number for use in the X12 837 in coverage extension of the CRD and DTR IGs or as part of the all-FHIR exchange of the Prior Authorization Response Bundle in the PAS IG. For CRD, this specifically means that the satisfied-pa-id in the [Coverage Information extension](StructureDefinition-ext-coverage-information.md) can be used as an X12 prior authorization number.

### Systems

This implementation guide sets expectations for two types of systems:

CRD clients are typically systems that healthcare providers use at the point of care, including electronic medical records systems, pharmacy systems, and other provider and administrative systems used for ordering, documenting, and executing patient-related services. Users of these systems need coverage requirements information to support care planning.

Examples of potential CRD clients include EHRs, EMRs, practice management systems, scheduling systems, patient registration systems, etc.

The CRD client may actually involve multiple systems. For example, the systems that handle order entry may be different from what is used for appointment booking and different again from the system that exposes information over the FHIR interface. It is possible that a provider environment might use an intermediary to coordinate CRD client calls from multiple systems. Such an architecture is sufficient provided that:

* Calls are triggered from within the system the user is interacting with at the time when the 'hook event' (entering an order, booking an appointment, etc.) occurs.
* Cards returned are displayed to the user, or in the event of system actions, user-notifications associated with the system actions are presented to the user within the same application.
* The 'access token' and FHIR endpoint exposed to the CRD server has access to all relevant data, independent of which physical data store it resides.
* The intermediary could take responsibility for the FHIR interface, such as determining which payer should receive a coverage request.

There are three distinct sets of capabilities for CRD clients, one for [USCDI v1 (US-Core 3.1.1)](CapabilityStatement-crd-client3.1.md), one for [USCDI v3 (US-Core 6.1.0)](CapabilityStatement-crd-client6.1.md), and one for [USCDI v4 (US-Core 7.0.0)](CapabilityStatement-crd-client7.0.md). Typically, a client would support only one of these, based on which US Core release the client supports internally. There is a single CRD server set of capabilities which must be able to handle data from any of the three supported USCDI versions.

> When CRD clients are made up of multiple systems, there will be orchestration requirements to allow each system to interact in a way that together they appear as a single monolithic system from the perspective of the CRD server. This IG provides some discussion of this on the [electronic prior authorization (ePA) Coordinators page](epa.md), though it does not yet provide any standardization about how components should interoperate to achieve the intended monolithic behavior. If there is industry interest, future releases of this IG may work to standardize some of these "intra-client" interactions.

CRD servers (or servers) are systems that act on behalf of payer organizations to share information with healthcare providers about rules and requirements related to healthcare products and services covered by a patient's health plan. A CRD server will provide coverage information related to one or more insurance plans. CRD servers are a type of CDS service as defined in the CDS Hooks Specification.

There are is a single [set of capabilities for CRD servers](CapabilityStatement-crd-server.md) that spans USCDI v1 (US-Core 3.1.1) USCDI v3 (US-Core 6.1.0), and USCDI v4 (US-Core 7.0.0) expectations. Payers will need to handle content from any of the releases, as CRD clients will be transitioning support for the versions at different times - and in some cases may provide content that spans a mixture of versions.

### Content and Organization

This implementation guide (and the menu for it) is organized into the following sections:

* **Background** - Supporting informative pages that do not set conformance expectations 
* [Reading this IG](background.md) points to key pages in the FHIR spec and other source specifications that must be understood to understand this guide
* [Use Cases](usecases.md) describes the intent of the implementation guide, gives examples of its use, and provides a high-level overview of expected process flow
* [Project and Participants](credits.md) gives a high-level overview of Da Vinci and identifies the individuals and organizations involved in developing this implementation guide
* [Burden Reduction](burden.md) identifies related specifications this implementation guide builds upon that developers should read and understand prior to implementing this specification
* [ePA Coordinators](epa.md) acknowledges that neither the payer nor provider systems involved in CRD are monolithic and shows how the various components of provider and payer systems might interact with "ePA Coordinator" systems to satisfy the requirements of this IG
* [Operational Recommendations](operational.md) highlights topics that organizations should take into account when implementing the specification that fall outside the boundaries of conformance validation.
 
* **Specification** - Pages that set conformance expectations 
* [Conformance Expectations](conformance.md) defines base language and expectations for declaring conformance with the guide
* [Privacy, Safety, and Security](security.md) covers considerations around data access, protection, and similar concepts that apply to all implementations
* [Foundational Guidance](foundation.md) covers high-level conformance expectations that apply to all implementations
* [Deviations and Enhancements](deviations.md) covers detailed implementation requirements and conformance expectations that are independent of specific hooks or cards
* [Supported Hooks](hooks.md) identifies the expectations for support for specific CDS hooks
* [Hook Response Profiles](cards.md) defines patterns for CDS Hooks cards and system actions that can be returned as part of this specification
* [Implementation Guidance](implementation.md) provides recommendations for implementation that fall outside the technical scope of the specification
* [CRD Metrics](metrics.md) provides a logical model describing how to capture data that may be relevant to measuring or reporting on CRD use
 
* **FHIR Artifacts** 
* [Artifacts Overview](allartifacts.md) introduces and provides links to the profiles, search parameters and other FHIR artifacts used in this implementation guide
* Additional links point to complete lists of all artifacts defined in this guide as well as ancestor guides
 
* **Base Specifications** - Quick links to the various specifications this guide derives from
* **Support** - Links to help with use of this guide 
* **Discussion Forum** is a place to ask questions about the guide, discuss potential issues, and search through prior discussions
* **Project Home** includes information about project calls, agendas, past minutes, and instructions for how to participate
* **Implementer Support** provides information about reference implementations, resources for testing, known errata, regulatory considerations, and practical implementation pathways
* **Project Dashboard** shows new and historical issues that have been logged against the specification, proposed dispositions, unapplied changes, etc.
* **Propose a Change** allows formal submission of requests for change to the specification. (Consider raising the issue on the discussion forum first.)
* [Downloads](downloads.md) allows downloading this and other specifications, as well as other useful files
 

### Dependencies

This guide is based on the [FHIR R4](http://hl7.org/fhir/R4/) specification that is mandated for use in the U.S. It also leverages the [SMART on FHIR](http://hl7.org/fhir/smart-app-launch) specification for CRD clients that opt to use that approach for "what-if" scenarios.

In addition, this guide also relies on several ancestor implementation guides:

| | | |
| :--- | :--- | :--- |
| [CDS Hooks](http://cds-hooks.hl7.org/2026Jan) | [3.0.0-ballot](https://simplifier.net/packages/hl7.fhir.uv.cds-hooks/3.0.0-ballot) | The CDS Hooks specification the CRD architecture is based on |
| [CDS Hooks Library](http://cds-hooks.hl7.org/hooks/STU1) | [1.0.1](https://simplifier.net/packages/hl7.fhir.uv.cds-hooks-library/1.0.1) | Provides the hook definitions for CDS Hooks |
| [Da Vinci Health Record Exchange (HRex)](https://build.fhir.org/ig/HL7/davinci-ehrx/) | [current](https://simplifier.net/packages/hl7.fhir.us.davinci-hrex/current) | Defines common conformance rules across all Da Vinci IGs, as well as additional constraints and profiles beyond U.S. Core |
| [FHIR Extensions Pack](http://hl7.org/fhir/extensions/5.2.0) | [5.2.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.2.0) | Automatically added as a dependency - all IGs depend on the HL7 Extension Pack |
| [FHIR R4 package : Core](http://hl7.org/fhir/R4) | [4.0.1](https://simplifier.net/packages/hl7.fhir.r4.core/4.0.1) | Imported by HL7 Terminology (THO) (and potentially others) |
| [FHIR Tooling Extensions IG](http://hl7.org/fhir/tools/1.0.0) | [1.0.0](https://simplifier.net/packages/hl7.fhir.uv.tools.r4/1.0.0) | Defines the CDS Hooks logical models |
| [HL7 Terminology (THO)](http://terminology.hl7.org/7.0.1) | [7.0.1](https://simplifier.net/packages/hl7.terminology.r4/7.0.1) | Automatically added as a dependency - all IGs depend on HL7 Terminology |
| [6.2.0](https://simplifier.net/packages/hl7.terminology.r4/6.2.0) | Imported by CDS Hooks Library (and potentially others) | |
| [5.5.0](https://simplifier.net/packages/hl7.terminology.r4/5.5.0) | Imported by US Core (and potentially others) | |
| [Public Health Information Network Vocabulary Access and Distribution System (PHIN VADS)](http://fhir.org/packages/us.cdc.phinvads) | [0.12.0](https://simplifier.net/packages/us.cdc.phinvads/0.12.0) | Imported by US Core (and potentially others) |
| [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2) | [2.0.0](https://simplifier.net/packages/hl7.fhir.uv.smart-app-launch/2.0.0) | Imported by US Core (and potentially others) |
| [Structured Data Capture](http://hl7.org/fhir/uv/sdc/STU3) | [3.0.0](https://simplifier.net/packages/hl7.fhir.uv.sdc/3.0.0) | Defines expectations for Questionnaires prompted by cards |
| [US Core](http://hl7.org/fhir/us/core/STU7) | [7.0.0](https://simplifier.net/packages/hl7.fhir.us.core/7.0.0) | Defines USCDI v4 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers. |
| [6.1.0](https://simplifier.net/packages/hl7.fhir.us.core/6.1.0) | Defines USCDI v3 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers | |
| [3.1.1](https://simplifier.net/packages/hl7.fhir.us.core/3.1.1) | Defines USCDI v1 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers. | |
| [Value Set Authority Center (VSAC)](http://fhir.org/packages/us.nlm.vsac) | [0.19.0](https://simplifier.net/packages/us.nlm.vsac/0.19.0) | Uses the latest version of the VSAC codes |
| [0.18.0](https://simplifier.net/packages/us.nlm.vsac/0.18.0) | Imported by US Core (and potentially others) | |

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

* CPT © Copyright 2026 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association.

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r4/ValueSet/nucc-provider-taxonomy): [CRDServiceRequest](StructureDefinition-profile-servicerequest.md), [NUCCCareProviderTaxonomyIndividualOrGroups](ValueSet-NUCCCareProviderTaxonomyIndividualOrGroups.md) and [NUCCCareProviderTaxonomyNonIndividual](ValueSet-NUCCCareProviderTaxonomyNonIndividual.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.2.0/CodeSystem-ISO3166Part1.html): [CDSHookCardActionType](ValueSet-cardActions.md), [CDSHookServiceRequestExtensionRequestCRDVersion](StructureDefinition-CDSHookServiceRequestExtensionRequestCRDVersion.md)... Show 91 more, [CDSHookServiceRequestExtensionRequestConfig](StructureDefinition-CDSHookServiceRequestExtensionRequestConfig.md), [CDSHookServiceResponseExtensionAssociatedResource](StructureDefinition-CDSHookServiceResponseExtensionAssociatedResource.md), [CDSHookServiceResponseExtensionIfNoneExist](StructureDefinition-CDSHookServiceResponseExtensionIfNoneExist.md), [CDSHookServicesExtensionCRDVersion](StructureDefinition-CDSHookServicesExtensionCRDVersion.md), [CDSHookServicesExtensionConfiguration](StructureDefinition-CDSHookServicesExtensionConfiguration.md), [CDSHookType](ValueSet-cdsHookType.md), [CMSLocationCodes](ValueSet-cmslocationcodes.md), [CRDAdditionalDoc](ValueSet-AdditionalDocumentation.md), [CRDAppointmentBase](StructureDefinition-profile-appointment-base.md), [CRDAppointmentBookContext](StructureDefinition-CRDAppointmentBookContext.md), [CRDAppointmentBundle](StructureDefinition-profile-bundle-appointment.md), [CRDAppointmentNoOrder](StructureDefinition-profile-appointment-no-order.md), [CRDAppointmentWithOrder](StructureDefinition-profile-appointment-with-order.md), [CRDBaseBundle](StructureDefinition-profile-bundle-base.md), [CRDBillingCodes](ValueSet-billingCodes.md), [CRDBillingOptions](StructureDefinition-ext-billing-options.md), [CRDCardType](ValueSet-cardType.md), [CRDClient3_1](CapabilityStatement-crd-client3.1.md), [CRDClient6_1](CapabilityStatement-crd-client6.1.md), [CRDClient7_0](CapabilityStatement-crd-client7.0.md), [CRDClientActor](ActorDefinition-crd-client.md), [CRDClientOrgActor](ActorDefinition-crd-client-org.md), [CRDCommunicationRequest](StructureDefinition-profile-communicationrequest.md), [CRDConfigTypes](ValueSet-configTypes.md), [CRDConformanceStatementCategories](ValueSet-cs-categories.md), [CRDCoverage](StructureDefinition-profile-coverage.md), [CRDCoverageAssertionReasons](ValueSet-coverageAssertionReasons.md), [CRDCoverageClasses](ValueSet-coverageClass.md), [CRDCoverageDetailCategories](ValueSet-coverageDetailCategories.md), [CRDCoverageDetailCodes](ValueSet-coverageDetail.md), [CRDCoverageDetailCodesNew](ValueSet-coverageDetailNew.md), [CRDCoverageInformation](StructureDefinition-ext-coverage-information.md), [CRDCoveragePaDetail](ValueSet-coveragePaDetail.md), [CRDCoveredInfo](ValueSet-coverageInfo.md), [CRDDevice](StructureDefinition-profile-device.md), [CRDDeviceRequest](StructureDefinition-profile-devicerequest.md), [CRDDeviceRequests](ValueSet-deviceRequest.md), [CRDDocReason](ValueSet-DocReason.md), [CRDEncounter](StructureDefinition-profile-encounter.md), [CRDHooksRequest](StructureDefinition-CRDHooksRequest.md), [CRDHooksResponse](StructureDefinition-CRDHooksResponse.md), [CRDHooksResponseAdditionalOrders](StructureDefinition-CRDHooksResponse-additionalOrders.md), [CRDHooksResponseAdjustCoverage](StructureDefinition-CRDHooksResponse-adjustCoverage.md), [CRDHooksResponseAlternateRequest](StructureDefinition-CRDHooksResponse-alternateRequest.md), [CRDHooksResponseBase](StructureDefinition-CRDHooksResponseBase.md), [CRDHooksResponseCoverageInformation](StructureDefinition-CRDHooksResponse-coverageInformation.md), [CRDHooksResponseExternalReference](StructureDefinition-CRDHooksResponse-externalReference.md), [CRDHooksResponseFormCompletion](StructureDefinition-CRDHooksResponse-formCompletion.md), [CRDHooksResponseInstructions](StructureDefinition-CRDHooksResponse-instructions.md), [CRDHooksResponseLaunchSMART](StructureDefinition-CRDHooksResponse-launchSMART.md), [CRDInformationNeeded](ValueSet-informationNeeded.md), [CRDLocation](StructureDefinition-profile-location.md), [CRDLocationAddressTypes](ValueSet-locationAddressType.md), [CRDMedication](StructureDefinition-profile-medication.md), [CRDMedicationRequest](StructureDefinition-profile-medicationrequest.md), [CRDMetricCodes](CodeSystem-crd-metric-codes.md), [CRDMetricData](StructureDefinition-CRDMetricData.md), [CRDNutritionOrder](StructureDefinition-profile-nutritionorder.md), [CRDOrderDispatchContext](StructureDefinition-CRDOrderDispatchContext.md), [CRDOrderSelectContext](StructureDefinition-CRDOrderSelectContext.md), [CRDOrderSignContext](StructureDefinition-CRDOrderSignContext.md), [CRDOrganization](StructureDefinition-profile-organization.md), [CRDPatient](StructureDefinition-profile-patient.md), [CRDPractitioner](StructureDefinition-profile-practitioner.md), [CRDRequestBundle](StructureDefinition-profile-bundle-request.md), [CRDServer](CapabilityStatement-crd-server.md), [CRDServerActor](ActorDefinition-crd-server.md), [CRDServerOrgActor](ActorDefinition-crd-server-org.md), [CRDServiceRequest](StructureDefinition-profile-servicerequest.md), [CRDServiceRequestCodes](ValueSet-serviceRequestCodes.md), [CRDTaskBundle](StructureDefinition-profile-bundle-task.md), [CRDTaskDispatch](StructureDefinition-profile-task-dispatch.md), [CRDTaskQuestionnaire](StructureDefinition-profile-taskquestionnaire.md), [CRDTempCodes](CodeSystem-temp.md), [CRDTiming](StructureDefinition-profile-timing.md), [CRDVisionPrescription](StructureDefinition-profile-visionprescription.md), [CoverageInformationCodes](CodeSystem-coverage-information-codes.md), [CoverageRequirementsDiscovery](index.md), [DietCodes](ValueSet-diet-type.md), [FromNarrative](Requirements-fromNarrative.md), [ICD10CM](ValueSet-ICD10CM.md), [MetricDataSource](ValueSet-metricDataSource.md), [MetricOrderDetail](ValueSet-orderDetail.md), [MetricTokenUse](ValueSet-metricTokenUse.md), [NUBCTypeOfBill](ValueSet-NUBCTypeOfBill.md), [NUCCCareProviderTaxonomyIndividualOrGroups](ValueSet-NUCCCareProviderTaxonomyIndividualOrGroups.md), [NUCCCareProviderTaxonomyNonIndividual](ValueSet-NUCCCareProviderTaxonomyNonIndividual.md), [NutrientCodes](ValueSet-nutrient-code.md), [RequestCategory](StructureDefinition-ext-request-category.md), [TypesOfEdibleSubstances](ValueSet-edible-substance-type.md) and [X12ServiceType](ValueSet-X12ServiceType.md)


* Licensing information can be found [here](https://www.nubc.org/license) These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA’s licensing manager, Tim Carlson, at 312.893.6816 or tcarlson@aha.org

* [AHA NUBC Type Of Bill Codes](http://terminology.hl7.org/6.2.0/CodeSystem-AHANUBCTypeOfBill.html): [CRDServiceRequest](StructureDefinition-profile-servicerequest.md) and [NUBCTypeOfBill](ValueSet-NUBCTypeOfBill.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.2.0/CodeSystem-v3-ucum.html): [NutritionOrder/example](NutritionOrder-example.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.2.0/CodeSystem-v3-loinc.html): [CRDAppointmentNoOrder](StructureDefinition-profile-appointment-no-order.md), [CRDServiceRequest](StructureDefinition-profile-servicerequest.md), [CRDServiceRequestCodes](ValueSet-serviceRequestCodes.md) and [CommunicationRequest/example](CommunicationRequest-example.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Appointment/example2](Appointment-example2.md), [CRDAppointmentNoOrder](StructureDefinition-profile-appointment-no-order.md)... Show 10 more, [CRDNutritionOrder](StructureDefinition-profile-nutritionorder.md), [CRDServiceRequest](StructureDefinition-profile-servicerequest.md), [CRDServiceRequestCodes](ValueSet-serviceRequestCodes.md), [DietCodes](ValueSet-diet-type.md), [Encounter/example](Encounter-example.md), [MedicationRequest/example](MedicationRequest-example.md), [NutrientCodes](ValueSet-nutrient-code.md), [NutritionOrder/example](NutritionOrder-example.md), [ServiceRequest/example](ServiceRequest-example.md) and [TypesOfEdibleSubstances](ValueSet-edible-substance-type.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [CDS Hooks Card Types](http://terminology.hl7.org/7.0.1/CodeSystem-cdshooks-card-type.html): [CDSHookServiceRequestExtensionRequestConfig](StructureDefinition-CDSHookServiceRequestExtensionRequestConfig.md), [CDSHookServicesExtensionConfiguration](StructureDefinition-CDSHookServicesExtensionConfiguration.md), [CRDCardType](ValueSet-cardType.md), [CRDHooksResponseBase](StructureDefinition-CRDHooksResponseBase.md) and [CRDMetricData](StructureDefinition-CRDMetricData.md)
* [CommunicationCategory](http://terminology.hl7.org/7.0.1/CodeSystem-communication-category.html): [CommunicationRequest/example](CommunicationRequest-example.md)
* [Coverage Class Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-class.html): [CRDCoverage](StructureDefinition-profile-coverage.md), [CRDCoverageClasses](ValueSet-coverageClass.md) and [Coverage/example](Coverage-example.md)
* [CRD Coverage Detail Codes](http://terminology.hl7.org/7.0.1/CodeSystem-crd-coverage-detail.html): [CRDCoverageDetailCodesNew](ValueSet-coverageDetailNew.md) and [CRDCoverageInformation](StructureDefinition-ext-coverage-information.md)
* [Diet](http://terminology.hl7.org/7.0.1/CodeSystem-diet.html): [NutritionOrder/example](NutritionOrder-example.md)
* [DoseAndRateType](http://terminology.hl7.org/7.0.1/CodeSystem-dose-rate-type.html): [MedicationRequest/example](MedicationRequest-example.md)
* [Enteral Formula Additive Type Code](http://terminology.hl7.org/7.0.1/CodeSystem-entformula-additive.html): [CRDNutritionOrder](StructureDefinition-profile-nutritionorder.md)
* [USCLS Codes](http://terminology.hl7.org/7.0.1/CodeSystem-ex-USCLS.html): [CRDCoverageInformation](StructureDefinition-ext-coverage-information.md)
* [Example Vision Prescription Product Codes](http://terminology.hl7.org/7.0.1/CodeSystem-ex-visionprescriptionproduct.html): [VisionPrescription/visionprescription-example](VisionPrescription-visionprescription-example.md)
* [Location type](http://terminology.hl7.org/7.0.1/CodeSystem-location-physical-type.html): [South Wing, second floor](Location-example.md)
* [Operation Outcome Codes](http://terminology.hl7.org/7.0.1/CodeSystem-operation-outcome.html): [CRDMetricData](StructureDefinition-CRDMetricData.md)
* [Service type](http://terminology.hl7.org/7.0.1/CodeSystem-service-type.html): [Appointment/example2](Appointment-example2.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/7.0.1/CodeSystem-subscriber-relationship.html): [Coverage/example](Coverage-example.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [CRDCoverage](StructureDefinition-profile-coverage.md), [Coverage/example](Coverage-example.md) and [Patient/example](Patient-example.md)
* [appointmentReason](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0276.html): [Appointment/example1](Appointment-example1.md) and [Appointment/example2](Appointment-example2.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Appointment/example2](Appointment-example2.md), [CRDAppointmentNoOrder](StructureDefinition-profile-appointment-no-order.md)... Show 8 more, [CRDDeviceRequest](StructureDefinition-profile-devicerequest.md), [CRDMedicationRequest](StructureDefinition-profile-medicationrequest.md), [CRDNutritionOrder](StructureDefinition-profile-nutritionorder.md), [CRDServiceRequest](StructureDefinition-profile-servicerequest.md), [CRDVisionPrescription](StructureDefinition-profile-visionprescription.md), [Coverage/example](Coverage-example.md), [DeviceRequest/example](DeviceRequest-example.md) and [Encounter/example](Encounter-example.md)
* [ActReason](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html): [MedicationRequest/example](MedicationRequest-example.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [CRDCoverageInformation](StructureDefinition-ext-coverage-information.md), [CRDDocReason](ValueSet-DocReason.md), [CRDInformationNeeded](ValueSet-informationNeeded.md) and [CRDMetricData](StructureDefinition-CRDMetricData.md)
* [ParticipationMode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationMode.html): [CommunicationRequest/example](CommunicationRequest-example.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [Appointment/example1](Appointment-example1.md), [Appointment/example2](Appointment-example2.md), [CRDAppointmentBase](StructureDefinition-profile-appointment-base.md), [CRDAppointmentNoOrder](StructureDefinition-profile-appointment-no-order.md) and [CRDAppointmentWithOrder](StructureDefinition-profile-appointment-with-order.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [South Wing, second floor](Location-example.md)
* [RouteOfAdministration](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RouteOfAdministration.html): [CRDNutritionOrder](StructureDefinition-profile-nutritionorder.md)
* [Orderable Drug Form](http://terminology.hl7.org/7.0.1/CodeSystem-v3-orderableDrugForm.html): [MedicationRequest/example](MedicationRequest-example.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core Category](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-category.html): [CRDAppointmentNoOrder](StructureDefinition-profile-appointment-no-order.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.2.0/CodeSystem-v3-rxNorm.html): [CRDBillingCodes](ValueSet-billingCodes.md), [CRDBillingOptions](StructureDefinition-ext-billing-options.md) and [MedicationRequest/annotated-example](MedicationRequest-annotated-example.md)


