# Change History - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Change History

This page describes the primary releases of the specification and summarizes the content for each:

### Release 2.2.0-snapshot

**Breaking changes**:

* [FHIR-52057](https://jira.hl7.org/browse/FHIR-52057) - Corrected single-digit CMS location codes to have a leading 0 **(correction)** [link](CodeSystem-temp.md), - Superceded by FHIR-53648
* [FHIR-49825](https://jira.hl7.org/browse/FHIR-49825) - Stripped language allowing coverage records to be added via a card or system action **(correction)** [link](cards.md#FHIR-49825)
* [FHIR-52535](https://jira.hl7.org/browse/FHIR-52535) - Tighened expectations around providing OperationOutcomes **(clarification)** [link](hooks.md#FHIR-52535)
* [FHIR-49974](https://jira.hl7.org/browse/FHIR-49974) - Made order-select support mandatory **(clarification)** [link](hooks.md#FHIR-49974)
* [FHIR-52444](https://jira.hl7.org/browse/FHIR-52444) - Made support for prefetch mandatory **(enhancement)** [link](foundation.md#FHIR-52444)
* [FHIR-53048](https://jira.hl7.org/browse/FHIR-53048) - Added CRD version extensions to service discovery and service invocation **(enhancement)** [link](deviations.md#crd-version-declaration)
* [FHIR-52588](https://jira.hl7.org/browse/FHIR-52588) - Added clearer rules about the use of the Form Completion Response Type **(clarification)** [link](cards.md#FHIR-52588)
* [FHIR-52059](https://jira.hl7.org/browse/FHIR-52059) - Add missing location code 66, add rule requiring sending CMS location codes if available, not just the required HL7 code **(correction, enhancement)** [link](StructureDefinition-profile-location.md), [link](CodeSystem-temp.md)
* [FHIR-54639](https://jira.hl7.org/browse/FHIR-54639) - Added bindings to Appointment without Order for serviceCategory and serviceType **(correction)** [link](StructureDefinition-profile-appointment-no-order.md)
* [FHIR-53646](https://jira.hl7.org/browse/FHIR-53646) - Changed coverage-information 'contact' extension to ContactDetail instead of ContactPoint **(enhancement)** [link](StructureDefinition-ext-coverage-information.md)
* [FHIR-53603](https://jira.hl7.org/browse/FHIR-53603), [FHIR-53604](https://jira.hl7.org/browse/FHIR-53604) - Removed references to CRD-specific search parameter expectations in capability statements **(correction)** [link](CapabilityStatement-crd-client3.1.md), [link](CapabilityStatement-crd-client6.1.md), [link](CapabilityStatement-crd-client7.0.md)
* [FHIR-53647](https://jira.hl7.org/browse/FHIR-53647) - Tightened expectations on appointment participant to limit must support to primary performer and patient **(correction)** [link](StructureDefinition-profile-appointment-with-order.md), [link](StructureDefinition-profile-appointment-no-order.md)
* [FHIR-52583](https://jira.hl7.org/browse/FHIR-52583) - Tightened expectations about recognizability of card source label **(correction)** [link](cards.md#FHIR-52583)
* [FHIR-52908](https://jira.hl7.org/browse/FHIR-52908) - Updated the spec to refer to the most recent version of the CDS Hooks specification (with new prefetch rules) **(correction)** [link](index.md#dependencies)
* [FHIR-53648](https://jira.hl7.org/browse/FHIR-53648), [FHIR-50276](https://jira.hl7.org/browse/FHIR-50276) - Dropped expectations for use of Location.typeCode (and associated value sets and concept map) and added support for ServiceRequest.locationCode with two mustSupport code bindings, including moving CMS location codes to use official URL **(correction)** [link](StructureDefinition-profile-servicerequest.md), [link](StructureDefinition-profile-location.md)
* [FHIR-49871](https://jira.hl7.org/browse/FHIR-49871) - Tightened mustSupport and terminology expectations on NutritionOrder profile **(correction)** [link](StructureDefinition-profile-nutritionorder.md)
* [FHIR-48946](https://jira.hl7.org/browse/FHIR-48946) - Added expectation for CRD clients to transmit ICD10-CM codes if they are available **(enhancement)** [link](StructureDefinition-profile-servicerequest.md)
* [FHIR-53653](https://jira.hl7.org/browse/FHIR-53653) - Corrected appointment to use HRex PractitionerRole rather than US Core *(correction) [link](StructureDefinition-profile-appointment-with-order.md), [link](StructureDefinition-profile-appointment-no-order.md)

**Substative changes**

* [FHIR-52452](https://jira.hl7.org/browse/FHIR-52452) - Added 'contained' as mustSupport to request resources and encounters **(enhancement)** many locations
* [FHIR-52060](https://jira.hl7.org/browse/FHIR-52060) - Allow MedicationRequest and DeviceRequest as supporting structures for Appointment **(enhancement)** [link](StructureDefinition-profile-appointment-with-order.md)
* [FHIR-49982](https://jira.hl7.org/browse/FHIR-49982) - Added support to capture speciality using performerType on ServiceRequest **(enhancement)** [link](StructureDefinition-profile-servicerequest.md)
* [FHIR-50216](https://jira.hl7.org/browse/FHIR-50216) - Added explicit guidance about the use of supplemental guides and clarified conformance expectations for interoperability **(clarification)** [link](conformance.md#FHIR-50216)
* [FHIR-51715](https://jira.hl7.org/browse/FHIR-51715) - Cleaned up language on SMART on FHIR security expectations **(correction)** [link](security.md#FHIR-51715)
* [FHIR-52326](https://jira.hl7.org/browse/FHIR-52326) - Added section on operational recommendations **(enhancement)** [link](foundation.md#FHIR-52326), [link](foundation.md#FHIR-52326b), [link](operational.md)
* [FHIR-52357](https://jira.hl7.org/browse/FHIR-52357) - Allow Organization as a target for ServiceRequest.performer **(enhancement)** [link](StructureDefinition-profile-servicerequest.md)
* [FHIR-52806](https://jira.hl7.org/browse/FHIR-52806) - Made clear that CRD invocation must not require transcription **(clarification)** [link](hooks.md#FHIR-52806)
* [FHIR-52447](https://jira.hl7.org/browse/FHIR-52447) - Caching language should be for same patient/ordering organization **(correction)** [link](foundation.md#FHIR-52447)
* [FHIR-50216](https://jira.hl7.org/browse/FHIR-50216) - Added expectations on interoperability **(clarification)** [link](conformance.md#interoperability-expectations)
* [FHIR-53651](https://jira.hl7.org/browse/FHIR-53651) - Made MedicationRequest.dispenseRequest and dispenseRequest.dispenser mustSupport **(enhancement)** [link](StructureDefinition-profile-medicationrequest.md)
* [FHIR-52454](https://jira.hl7.org/browse/FHIR-52454) - Added conformance expectations for the Timing data type and clarified US core conformance expectations **(enhancement, clarification)** [link](conformance.md#FHIR-52454), [link](StructureDefinition-profile-timing.md), [link](StructureDefinition-profile-medicationrequest.md), [link](StructureDefinition-profile-servicerequest.md)
* [FHIR-53996](https://jira.hl7.org/browse/FHIR-53996) - Clarified organization address rules, added mustSupport for TIN to practitioner, tightened ServiceRequest.performerType to only "individual or group" NUCC provider taxonomy codes. Added a mustSupport slice for ServiceRequest.locationCode pointing to "non-individual" NUCC provider taxonomy codes **(clarification, correction, enhancement)** [link](StructureDefinition-profile-practitioner.md)
* [FHIR-49129](https://jira.hl7.org/browse/FHIR-49129), [FHIR-50669](https://jira.hl7.org/browse/FHIR-50669), [FHIR-50892](https://jira.hl7.org/browse/FHIR-50892) - Added additional categories to request profiles other than CommunicationRequest to capture inpatient/outpatient and service type **(enhancement)** [link](StructureDefinition-profile-appointment-no-order.md), [link](StructureDefinition-profile-devicerequest.md), [link](StructureDefinition-profile-medicationrequest.md), [link](StructureDefinition-profile-nutritionorder.md), [link](StructureDefinition-profile-servicerequest.md), [link](StructureDefinition-profile-visionprescription.md)

**Non-substantive changes**:

* [FHIR-52002](https://jira.hl7.org/browse/FHIR-52002) - Updated ONC to ASTP/ONC **(correction)** [link](epa.md#FHIR-52002)
* [FHIR-52004](https://jira.hl7.org/browse/FHIR-52004), [FHIR-52069](https://jira.hl7.org/browse/FHIR-52069), [FHIR-52480](https://jira.hl7.org/browse/FHIR-52480), [FHIR-52441](https://jira.hl7.org/browse/FHIR-52441) - Fixed various minor typos **(correction)** many locations
* [FHIR-53177](https://jira.hl7.org/browse/FHIR-53177) - Put coverage-information back on Appointment w/ No Order, as it had accidentally been dropped **(correction)** [link](StructureDefinition-profile-appointment-no-order.md)
* [FHIR-52058](https://jira.hl7.org/browse/FHIR-52058) - Renamed "CMS Mappable Location Codes" to "CMS Supplemented US Core Location Codes" **(clarification)** Superceded by FHIR-53648
* [FHIR-52585](https://jira.hl7.org/browse/FHIR-52585) - Clarified expectations for when cards can be used in place of DTR **(clarification)** NOTE: Subsequently removed in FHIR-52586, below
* [FHIR-52531](https://jira.hl7.org/browse/FHIR-52531) - Changed example "recommended alternative therapies" to "payer-preferred alternative therapies” **(clarification)** [link](deviations.md#FHIR-52531)
* [FHIR-52533](https://jira.hl7.org/browse/FHIR-52533) - Indicated the profile the form completion example was of **(clarification)** [link](deviations.md#FHIR-52533)
* [FHIR-52314](https://jira.hl7.org/browse/FHIR-52314) - Clarified how systems are allowed to handle overly slow responses **(clarification)** [link](foundation.md#FHIR-52314)
* [FHIR-52739](https://jira.hl7.org/browse/FHIR-52739) - Made clear that what-if scenarios do not need to use SMART on FHIR **(clarification)** [link](foundation.md#FHIR-52739)
* [FHIR-52062](https://jira.hl7.org/browse/FHIR-52062) - Clarified language around 400 vs. 422 errors **(clarification)** [link](hooks.md#FHIR-52062)
* [FHIR-52784](https://jira.hl7.org/browse/FHIR-52784) - Made support for prefetch mandatory (and removed example queries showing how to retrieve the 'required' data by query instead). Also corrected "CRD Service" to "CRD server" **(correction)** [link](foundation.md#FHIR-52784a), [link](foundation.md#FHIR-52784b), [link](foundation.md#FHIR-52784c), [link](foundation.md#FHIR-52784d)
* [FHIR-52537](https://jira.hl7.org/browse/FHIR-52537) - Clarified language around CRD for member attribution **(clarification)** [link](hooks.md#FHIR-52537)
* [FHIR-52582](https://jira.hl7.org/browse/FHIR-52582) - Made list of resources into a bulleted list **(correction)** [link](hooks.md#FHIR-52582)
* [FHIR-52463](https://jira.hl7.org/browse/FHIR-52463) - Corrected language about launching DTR **(correction)** [link](usecases.md#FHIR-52463)
* [FHIR-52707](https://jira.hl7.org/browse/FHIR-52707) - Corrected language about if-none-exist example **(correction)** [link](deviations.md#FHIR-52707)
* [FHIR-53498](https://jira.hl7.org/browse/FHIR-53498) - Corrected titles and descriptions of several example artifacts **(correction)** [link](artifacts.md)
* [FHIR-53285](https://jira.hl7.org/browse/FHIR-53285) - Corrected logical model to refer to not say 'card' when it should say systemAction or both **(correction)** [link](StructureDefinition-CRDMetricData-definitions.md)
* [FHIR-52324](https://jira.hl7.org/browse/FHIR-52324) - Manually added reference to CPT IP rules in IP section **(correction)** [link](index.md#intellectual-property-considerations)
* [FHIR-49826](https://jira.hl7.org/browse/FHIR-49826) - Made clear that only the primary coverage can be included in prefetch, but multiple coverages are permitted over the FHIR API **(clarification)** [link](deviations.md#FHIR-49826)
* [FHIR-53067](https://jira.hl7.org/browse/FHIR-53067) - Clarify that CRD can be invoked by client as needed **(clarification)** [link](hooks.md#FHIR-53067)
* [FHIR-53579](https://jira.hl7.org/browse/FHIR-53579) - Clarified rules around profiles for hook invocation **(clarification)** [link](hooks.md#FHIR-53579-a), [link](hooks.md#FHIR-53579-b), [link](hooks.md#FHIR-53579-c), [link](hooks.md#FHIR-53579-d), [link](hooks.md#FHIR-53579-e), [link](hooks.md#FHIR-53579-f)
* [FHIR-52586](https://jira.hl7.org/browse/FHIR-52586) - Deleted language about portals **(correction)**
* [FHIR-53544](https://jira.hl7.org/browse/FHIR-53544) - Explicitly marked coverage-assertion-id value mandatory within extension **(correction)** [link](StructureDefinition-ext-coverage-information.md)
* [FHIR-51776](https://jira.hl7.org/browse/FHIR-51776), [FHIR-50897](https://jira.hl7.org/browse/FHIR-50897) - Encourage support for order-select and encounter-start hooks **(clarification)** [link](operational.md#FHIR-51776)
* [FHIR-52532](https://jira.hl7.org/browse/FHIR-52532) - Changed 'Best practices' to 'Planned therapy guidance' **(clarification)** [link](deviations.md#FHIR-52532)
* [FHIR-53607](https://jira.hl7.org/browse/FHIR-53607) - Corrected 'time shorter' to be 'time longer' **(correction)** [link](foundation.md#FHIR-53607)
* [FHIR-53605](https://jira.hl7.org/browse/FHIR-53605), [FHIR-53606](https://jira.hl7.org/browse/FHIR-53606) - Clarified expectations around 'update' for resources in client CapabilityStatements **(clarification)** [link](CapabilityStatement-crd-client3.1.md), [link](CapabilityStatement-crd-client6.1.md), [link](CapabilityStatement-crd-client7.0.md)
* [FHIR-45673](https://jira.hl7.org/browse/FHIR-45673) - Added guidance on how prior authorization cases are handled in CRD **(clarification)** [link](operational.md#FHIR-45673)
* [FHIR-53634](https://jira.hl7.org/browse/FHIR-53634) - Corrected typo where sentences said 'DTR' instead of 'CRD' **(correction)** [link](foundation.md#FHIR-52784b)
* [FHIR-53650](https://jira.hl7.org/browse/FHIR-53650) - Improved description of 'covered' code **(clarification)** [link](CodeSystem-coverage-information-codes.md)
* [FHIR-49757](https://jira.hl7.org/browse/FHIR-49757) - Added security guidance around sharing tokens **(clarification)** [link](security.md#FHIR-49757)
* [FHIR-53577](https://jira.hl7.org/browse/FHIR-53577), [FHIR-53578](https://jira.hl7.org/browse/FHIR-53578) - Corrected hyperlink for order-sign hook (and removed unnecessary references to old CDS Hook versions) **(correction)** [link](hooks.md#order-sign)
* [FHIR-53661](https://jira.hl7.org/browse/FHIR-53661) - Updated metrics logical model to group responses by requesting order and adjusted metric expressions accordingly **(correction)** [link](metrics.md) [link](StructureDefinition-CRDMetricData.md)
* [FHIR-53638](https://jira.hl7.org/browse/FHIR-53638), [FHIR-55381](https://jira.hl7.org/browse/FHIR-55381) - Added clarification about US Core support for CRD servers and removed direct US Core dependency **(clarification, correction)** [link](CapabilityStatement-crd-server.md)

### Release 2.2.0-ballot

**Breaking changes**:

* [FHIR-50276](https://jira.hl7.org/browse/FHIR-50276) - Moved codes out of the temporary code system to their permanent home **(correction)** **TODO**
* [FHIR-49897](https://jira.hl7.org/browse/FHIR-49897) - Clarify that CRD must not be called in 'patient pay' situations (if system is aware) **(clarification)** [link](deviations.md#FHIR-49897)
* [FHIR-49909](https://jira.hl7.org/browse/FHIR-49909) - Added expectations for handling unexpected content **(clarification)** [link](foundation.md#FHIR-49909)
* [FHIR-49128](https://jira.hl7.org/browse/FHIR-49128) - Clarified (and loosened) conformance language for prefetch syntax **(clarification)** [link](deviations.md#FHIR-49128) [link](foundation.md#FHIR-49128)
* [FHIR-50102](https://jira.hl7.org/browse/FHIR-50102) - Make explicit that Coverage Information system actions are prohibited from making changes other than adding or updating the coverage-information extension **(clarification)** [link](cards.md#FHIR-50102)
* [FHIR-49830](https://jira.hl7.org/browse/FHIR-49830) - Clarify that the requirement to provide access to DTR for clinicians is required for patient forms, not just clinical forms **(correction)** [link](cards.md#FHIR-49830)
* [FHIR-50492](https://jira.hl7.org/browse/FHIR-50492), [FHIR-50494](https://jira.hl7.org/browse/FHIR-50494), [FHIR-50495](https://jira.hl7.org/browse/FHIR-50495), [FHIR-50496](https://jira.hl7.org/browse/FHIR-50496) - Updated CommunicationRequest.reasonReference, DeviceRequest.reasonReference, ServiceRequest.reasonReference, Encounter.diagnosis to force most references (other than Observation) to refer to US Core profiles, and added guidance that US Core Observation profiles should be used when possible. **(correction)** multiple profiles
* [FHIR-50318](https://jira.hl7.org/browse/FHIR-50318) - Added expectation to put coverage-expectation extension on ServiceRequest for appointments based on ServiceRequest **(clarification)** [link](cards.md#FHIR-50318)
* [FHIR-51045](https://jira.hl7.org/browse/FHIR-51045) - Relaxed Location.address to be optional, added guidance expecting propagation of address to fine-grained components **(correction, enhancement)** [link](StructureDefinition-profile-location.md)
* **Coverage Information Extension** 
* [FHIR-49950](https://jira.hl7.org/browse/FHIR-49950) - Set expectations about coverage-information extension being used in subsequent CRD, DTR and PAS calls to serve as a linking mechanism **(clarification)** [link](cards.md#FHIR-49950)
* [FHIR-49637](https://jira.hl7.org/browse/FHIR-49637) - Defined explicit coverage-information.reason codes for 'no-member-found' and 'no-active-coverage', and required their use **(enhancement)** [link](cards.md#FHIR-49637), [link](ValueSet-coverageAssertionReasons.md)
* [FHIR-49754](https://jira.hl7.org/browse/FHIR-49754) - Moved detail-code code from 'reason' to 'info-needed' element **(correction)** [link](ValueSet-informationNeeded.md)
* [FHIR-49792](https://jira.hl7.org/browse/FHIR-49792) - Add coverage-information.detail.category, categorize the standard detail.code values, and advise on expectation to display certain categories to clinical staff **(enhancement)** [link](StructureDefinition-ext-coverage-information-definitions.md#diff_Extension.extension:detail.extension:category)
* [FHIR-51413](https://jira.hl7.org/browse/FHIR-51413) - Remove the auth-out-network-only code from coverage-information.detail and add auth-out-network to coverage-information.reason. Also added guidance on when to send multiple coverage information repetitions vs. a single 'conditional' repetition stating the rules. **(correction, clarification)** [link](cards.md#FHIR-51413)
* [FHIR-49827](https://jira.hl7.org/browse/FHIR-49827) - Update crd-ci-q4 contraint on coverage-information to say 'noauth' and 'not-covered' in addition to 'satisfied' as reasons why you cannot have a doc purpose of with-pa **(correction)** [link](StructureDefinition-ext-coverage-information.md#constraints)
* [FHIR-49829](https://jira.hl7.org/browse/FHIR-49829) - Added crd-ci-q8 to enforce that if doc-purpose is present with a value other than 'conditional', doc-reason must be present **(correction)** [link](StructureDefinition-ext-coverage-information.md#constraints)
 

**Substative changes**

* [FHIR-50051](https://jira.hl7.org/browse/FHIR-50051) - Updated specification to point to current version of CDS Hooks spec and individual hooks **(correction)** - throughout the spec
* [FHIR-49742](https://jira.hl7.org/browse/FHIR-49742) - Change logical model token 0..1 to 1..1, made expectation to provide a token 'SHALL' instead of 'will' **(correction)** [link](foundation.md#FHIR-49742)
* [FHIR-51420](https://jira.hl7.org/browse/FHIR-51420) - Allow coverage-information ids to be unique for the same coverage within a request resource. **(correction)** [link](cards.md#FHIR-51420)
* [FHIR-50009](https://jira.hl7.org/browse/FHIR-50009) - Relaxed expectations from SHALL to SHOULD for CRD response types other than coverage-information **(correction)** [link](cards.md#FHIR-50009)
* [FHIR-49983](https://jira.hl7.org/browse/FHIR-49983) - Added new 'BillingOptions' extension and allow its use on all Request resources. **(enhancement)** [link](StructureDefinition-ext-billing-options.md), many profiles
* [FHIR-49813](https://jira.hl7.org/browse/FHIR-49813) - Allow PractitionerRole as an Encounter.participant **(enhancement)** [link](StructureDefinition-profile-encounter-definitions.md#diff_Encounter.participant)
* [FHIR-51470](https://jira.hl7.org/browse/FHIR-51470), [FHIR-51488](https://jira.hl7.org/browse/FHIR-51488) - Removed expectations and constraints for inclusion of medical record numbers in the Patient profile **(correction)** [link](StructureDefinition-profile-patient.md)
* [FHIR-49794](https://jira.hl7.org/browse/FHIR-49794) - In Questionnaire task, prohibit Task.focus and require input[questionnaire] **(correction)** [link](StructureDefinition-profile-taskquestionnaire.md)
* [FHIR-50269](https://jira.hl7.org/browse/FHIR-50269) - Remove 'after completion' input from Questionnaire Task **(correction)** [link](StructureDefinition-profile-taskquestionnaire.md)
* [FHIR-49894](https://jira.hl7.org/browse/FHIR-49894) - Added more language around when to use doc-needed vs. info-needed, added example of both, made clear that if info-needed of OTH, one of the reasons need to indicate what type of information is needed **(clarification)** [link](StructureDefinition-ext-coverage-information.md#FHIR-49894)
* [FHIR-49801](https://jira.hl7.org/browse/FHIR-49801) - Update appointment prefetch to include ServiceRequest **(correction)** [link](Binary-CRDServices.md)

**Non-substantive changes**:

* [FHIR-49689](https://jira.hl7.org/browse/FHIR-49689) - Corrected change log hyperlink in menu **(correction)** all pages
* [FHIR-48553](https://jira.hl7.org/browse/FHIR-48553) - Improved language in first intro paragraph **(clarification)** [link](index.md#FHIR-48553)
* [FHIR-49753](https://jira.hl7.org/browse/FHIR-49753) - Provided recommendations for when CRD discovery should be called **(clarification)** [link](foundation.md#FHIR-49753)
* [FHIR-49833](https://jira.hl7.org/browse/FHIR-49833) - Reframed warnings about the _include search mechanism to reflect the fact that it is no longer used in prefetch. **(correction)** [link](foundation.md#FHIR-49833)
* [FHIR-49003](https://jira.hl7.org/browse/FHIR-49003) - Removed language implying that Task could be a focal request when submitting a CRD request or have coverage-information and provided clearer information about the purpose of CommunicationRequest **(correction, clarification)** - section no longer exists to link to
* [FHIR-49731](https://jira.hl7.org/browse/FHIR-49731) - Corrected prefetch syntax to be CDS Hooks-conformant **(correction)** [link](foundation.md#prefetch)
* [FHIR-48771](https://jira.hl7.org/browse/FHIR-48771) - Clarified prefetch references **(clarification)** [link](foundation.md#FHIR-48771a)
* [FHIR-49196](https://jira.hl7.org/browse/FHIR-49196) - Clarified that _include may not be supported when using non-prefetch queries. **(clarification)** NOTE: This is no longer relevant given FHIR-52444 in the 2.2.0 final release
* [FHIR-48797](https://jira.hl7.org/browse/FHIR-48797) - Clarified rules on multiple coverages **(clarification)** [link](foundation.md#FHIR-48797)
* [FHIR-49805](https://jira.hl7.org/browse/FHIR-49805) - Added CommunicationRequest and VisionPrescription to prefetch and non-prefetch queries **(correction)** [link](foundation.md#prefetch), [link](Binary-CRDServices.md), [link](hooks.md#FHIR-49805a), , [link](hooks.md#FHIR-49805b)
* [FHIR-49835](https://jira.hl7.org/browse/FHIR-49835) - Removed the "additional hook resources" section of the deviations page (because in the referenced version of the CDS Hooks, it is no longer a deviation). **(correction)** Nothing to link to anymore
* [FHIR-49762](https://jira.hl7.org/browse/FHIR-49762) - Added VisionPrescription to the list of supported 'Request' resources for order-select and order-dispatch. (They were already in the technical list, just not the HTML.) **(correction)** [link](hooks.md#order-dispatch) [link](hooks.md#order-select)
* [FHIR-49085](https://jira.hl7.org/browse/FHIR-49085) - In diagram, corrected "Payer CDA System" to "Payer CDS System" **(correction)** [link](hooks.md#hook-categories)
* [FHIR-50006](https://jira.hl7.org/browse/FHIR-50006) - Added additional examples for non-provided/insufficient information that is not considered an error **(clarification)** [link](cards.md#FHIR-50006)
* [FHIR-48625](https://jira.hl7.org/browse/FHIR-48625) - Added guidance on best CRD server available practices **(clarification)** [link](implementation.md#FHIR-48625)
* [FHIR-49799](https://jira.hl7.org/browse/FHIR-49799) - Corrected appointment profiles to not be abstract **(correction)** [link](StructureDefinition-profile-appointment-with-order.md), [link](StructureDefinition-profile-appointment-no-order.md)
* [FHIR-50206](https://jira.hl7.org/browse/FHIR-50206) - Removed patient as an allowed type of Coverage payer **(correction)** [link](StructureDefinition-profile-coverage-definitions.md#diff_Coverage.payor)
* [FHIR-49795](https://jira.hl7.org/browse/FHIR-49795) - Dropped Questionnaire Task reason value set and require inclusion of text **(correction)** [link](StructureDefinition-profile-taskquestionnaire-definitions.md#diff_Task.reasonCode)
* [FHIR-50225](https://jira.hl7.org/browse/FHIR-50225) - Added an introduction to the coverage-information extension providing a detailed overview and ensured all elements had proper descriptions **(clarification)** [link](StructureDefinition-ext-coverage-information.md#introduction)
* [FHIR-48773](https://jira.hl7.org/browse/FHIR-48773) - Clarified where coverage-information.coverage must exist **(clarification)** [link](StructureDefinition-ext-coverage-information-definitions.md#diff_Extension.extension:coverage)
* [FHIR-49711](https://jira.hl7.org/browse/FHIR-49711) - Fixed short description for 'info-needed' component of coverage-information extension **(correction)** [link](StructureDefinition-ext-coverage-information-definitions.md#diff_Extension.extension:info-needed)
* [FHIR-49791](https://jira.hl7.org/browse/FHIR-49791) - Fixed odd content in logical model instances **(correction)** all logical model files and fragments
* [FHIR-49153](https://jira.hl7.org/browse/FHIR-49153), [FHIR-51036](https://jira.hl7.org/browse/FHIR-51036), [FHIR-49094](https://jira.hl7.org/browse/FHIR-49094) - Corrected names and descriptions of CDS Hooks request and response examples **(correction)** [link](artifacts.md#example-cds-hooks-examples)
* [FHIR-49800](https://jira.hl7.org/browse/FHIR-49800) - Fixed bad brackets in CDS Hooks Service Response **(correction)** [link](Binary-CRDServices.md)
* [FHIR-51187](https://jira.hl7.org/browse/FHIR-51187) - Added links to examples zip files on the downloads page **(clarification)** [link](downloads.md#FHIR-51187)
* [FHIR-49041](https://jira.hl7.org/browse/FHIR-49041) - Added CommunicationRequest examples **(clarification)** [link](Binary-CRDServiceRequest3.md), [link](Binary-CRDServiceResponse3.md)
* [FHIR-50814](https://jira.hl7.org/browse/FHIR-50814), [FHIR-45672](https://jira.hl7.org/browse/FHIR-45672) - Added formal models for CDS Hooks components and improved validation of examples **(clarification, correction)** - many new models and links from various pages

In addition, there have been various miscellaneous non-substantive improvements to formatting, spelling, grammar, etc.

### Release 2.1.0

* [FHIR-47329](https://jira.hl7.org/browse/FHIR-47329), [FHIR-48622](https://jira.hl7.org/browse/FHIR-48622) - Added support for USCDI v4 (US Core 7.0.0) and clarify language about what multi-US-Core release implementation means
* [FHIR-48352](https://jira.hl7.org/browse/FHIR-48352) - Set mustSupport expectations for practitioner, practitionerRole and organization for multi-target relationships
* [FHIR-48430](https://jira.hl7.org/browse/FHIR-48430) - Set clearer expectations for handling failure states
* [FHIR-48559](https://jira.hl7.org/browse/FHIR-48559) - Make ability to bypass CRD servers that are running too long a 'SHALL'
* [FHIR-48560](https://jira.hl7.org/browse/FHIR-48560) - Make clear that clients need to constrain scopes provided to what's needed
* [FHIR-48722](https://jira.hl7.org/browse/FHIR-48722) - Collapse the 2 Encounter profiles (USCDI 1, USCDI 3+4) into one

### Release 2.1.0-preview

Significant Coverage Information changes:

* [FHIR-46088](https://jira.hl7.org/browse/FHIR-46088) - Set MS expectations (and general expectations too)
* [FHIR-46460](https://jira.hl7.org/browse/FHIR-46460) - Remove 'response' element
* [FHIR-46089](https://jira.hl7.org/browse/FHIR-46089) - Tightened invariants around info-needed
* [FHIR-44410](https://jira.hl7.org/browse/FHIR-44410) - Add support for policy links and information as qualifiers
* [FHIR-45440](https://jira.hl7.org/browse/FHIR-45440) - Added new configuration option for 'wanting information' ServiceRequest and one not
* [FHIR-44909](https://jira.hl7.org/browse/FHIR-44909) - Added support for additional information from patient

Significant other changes:

* [FHIR-46440](https://jira.hl7.org/browse/FHIR-46640), [FHIR-46603](https://jira.hl7.org/browse/FHIR-46603) - Set expectations for endpoints and endpoint discovery
* [FHIR-45551](https://jira.hl7.org/browse/FHIR-45551) - Removed the CRD Practitioner profile (use HRex instead)
* [FHIR-46254](https://jira.hl7.org/browse/FHIR-46254) - Define a Task profile for order-dispatch hook
* [FHIR-44891](https://jira.hl7.org/browse/FHIR-44891) - Clarified expectations for mandatory hook support
* [FHIR-46006](https://jira.hl7.org/browse/FHIR-46006) - Added PractitionerRole to Appointment profile
* [FHIR-44527](https://jira.hl7.org/browse/FHIR-44527) - Corrected contexts for order-dispatch
* [FHIR-46120](https://jira.hl7.org/browse/FHIR-46120), [FHIR-43435](https://jira.hl7.org/browse/FHIR-43435) - Made Location.type MS and require it to be present in the hierarchy
* [FHIR-46383](https://jira.hl7.org/browse/FHIR-46383) - Prohibit use of CRD to point to portal launch
* [FHIR-43182](https://jira.hl7.org/browse/FHIR-43182) - Add expiration date to Coverage-Information
* [FHIR-45295](https://jira.hl7.org/browse/FHIR-45295) - Relax expections on Request statuses to not have to be 'draft'
* [FHIR-44388](https://jira.hl7.org/browse/FHIR-44388) - Split Appointment profile into two - one pointing to
* [FHIR-45230](https://jira.hl7.org/browse/FHIR-45230) - Relaxed 'reason' constraints in profiles to align with US Core
* [FHIR-46793](https://jira.hl7.org/browse/FHIR-46793) - Set expectations for CRD clients to query data when possible

A variety of minor corrections and clarifications to wording and examples.

### Release 2.0.1

Corrected the embedded JSON examples to be technically correct and in line with other rules in the specification

### Release 2.0.0

A number of additional changes and enhancements. Key differences are:

* Renamed the 'Annotate' card to [Coverage Information](cards.md#coverage-information-response-type) and made it a system action rather than a card
* Removed the Unsolicited determination card type
* Added system action as an optional feature of the [form completion](cards.md#request-form-completion-response-type) and [update coverage information](cards.md#update-coverage-records-response-type) cards
* Removed guidance on deferring card actions (as it is no longer terribly relevant for CRD and SMART now defines a mechanism)
* Added additional properties to the [coverage-information](StructureDefinition-ext-coverage-information.md) extension including the ability to specify questionnaires and draft responses for DTR, authorized billing codes, dependencies on other orders, and other details.
* Removed support for 'de-identified' invocation of CRD
* Corrected ServiceRequest.location to be 0..1 instead of 1..1
* Dropped expectation for coverage information to be conveyed as part of orders
* Changed language to make clear that CRD does not provide prior authorizations
* Tightened general conformance expectations
* A few additional corrections and numerous clarifications and refinements

### Release 1.1.0

Added a number of enhancements and some changes to approach. Key differences are:

* [Clarified](burden.md#users) that CRD results can be returned to non-clinical users
* Highlighted the [challenges](implementation.md#impact-on-payer-processes) of CRD data coming in a different form and set of codes than payers have traditionally dealt with
* Explicit expectations with respect to [performance](foundation.md#performance) and [accuracy](foundation.md#accuracy) of CRD Servers
* Expectations around client ability to [flag sensitive orders](foundation.md#appropriate-use-of-hooks)
* Specified a starter set of codes for [configuration options](deviations.md#configuration-options-extension) and mandated the appearance of those codes in cards in a new [topic](cards.md) element
* Made support for a [minimal set of configuration options](deviations.md#configuration-options-extension) mandatory
* Added an extension to [link cards to requests](deviations.md#linking-cards-to-requests)
* Introduced the new [order-dispatch](hooks.md#order-dispatch) hook
* Added the Annotate and Unsolicited Determination card types
* Revamped how [Prefetch](foundation.md#prefetch) handles retrieving a patient's coverage information
* Provided explicit guidance around deferring card actions
* Added a section on registering DTR apps with CRD
* Updated to support CRD 2.0, which included changes to the 'topic' element within cards
* Added support for system actions and made their use mandatory for updates to orders and coverage
* Added a definition of [mustSupport](conformance.md#mustsupport) for this guide
* Acknowledged that CRD clients can be made up of [multiple systems](index.md#systems)
* Removed constraint prohibiting [ServiceRequest.doNotPerform])(StructureDefinition-profile-servicerequest.html#profile)
* Added guidance on [enabling a CRD server](foundation.md#enabling-a-crd-server)
* Added guidance on [CRD access tokens](foundation.md#crd-access-tokens)
* Clarified expectations about [controlling hook invocation](deviations.md#controlling-hook-invocation)
* Provided guidance on [external references](cards.md#external-reference-response-type)
* Corrected cardType codes to use the IG temporary code system, as it is likely that long-term these codes will not all live as part of the IG
* Added CapabilityStatements describing CRD client and CRD Server responsibilities

As well there were various other adjustments to specification language, profiles, and examples to align with these changes and to correct minor typos or improve wording.

### Release 1.0.0

Initial release of the CRD specification.

