# CRD Order Detail Codes Value Set - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## ValueSet: CRD Order Detail Codes Value Set 

 
Detail codes for products and services that are the focus of a CRD call 

 **References** 

* [CRD Metric Data](StructureDefinition-CRDMetricData.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "orderDetail",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/orderDetail",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.48.20"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "MetricOrderDetail",
  "title" : "CRD Order Detail Codes Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Detail codes for products and services that are the focus of a CRD call",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/service-type"]
      },
      {
        "valueSet" : ["http://hl7.org/fhir/us/davinci-crd/ValueSet/deviceRequest"]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4|20240606"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.org/fhir/us/davinci-crd/ValueSet/serviceRequestCodes"
        ]
      },
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/vision-product"]
      }
    ]
  }
}

```
