# Diet Codes - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## ValueSet: Diet Codes 

 
Codes that can be used to indicate the type of food being ordered for a patient. It includes codes from [SNOMED CT](http://snomed.info/sct) where concept is Dietary Regime (182922004) and its sub-concepts, Enteral Feeding (229912004) and its sub-concepts, Mixed Breast Milk and Bottle Feeding (35011000087100), Breast Milk Feeding (1297276008), Bottle Feeding of Patient (40043006). 

 **References** 

* [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "diet-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/diet-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.48.32"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "DietCodes",
  "title" : "Diet Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Codes that can be used to indicate the type of food being ordered for a patient.  It includes codes from [SNOMED CT](http://snomed.info/sct) where concept is Dietary Regime (182922004) and its sub-concepts, Enteral Feeding (229912004) and its sub-concepts, Mixed Breast Milk and Bottle Feeding (35011000087100), Breast Milk Feeding (1297276008), Bottle Feeding of Patient (40043006).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "182922004"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "229912004"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "35011000087100"
          },
          {
            "code" : "1297276008"
          },
          {
            "code" : "40043006"
          }
        ]
      }
    ]
  }
}

```
