# X12 Service Type - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## ValueSet: X12 Service Type 

 
This set of codes provides a high-level classification for what service is being requested. 

 **References** 

* [CRD Appointment without Order](StructureDefinition-profile-appointment-no-order.md)
* [CRD Device Request](StructureDefinition-profile-devicerequest.md)
* [CRD Medication Request](StructureDefinition-profile-medicationrequest.md)
* [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md)
* [CRD Service Request](StructureDefinition-profile-servicerequest.md)
* [CRD Vision Prescription](StructureDefinition-profile-visionprescription.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "X12ServiceType",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/X12ServiceType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.48.28"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "X12ServiceType",
  "title" : "X12 Service Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This set of codes provides a high-level classification for what service is being requested.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "X12 codes are listed within an X12 implementation guide (TR3) and maintained by X12. All X12 work products are copyrighted. See their website for licensing terms and conditions.",
  "compose" : {
    "include" : [
      {
        "system" : "https://codesystem.x12.org/005010/1365"
      }
    ]
  }
}

```
