# NUCC Healthcare Provider Taxonomy Non-Individual - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## ValueSet: NUCC Healthcare Provider Taxonomy Non-Individual 

 
All NUCC Healthcare Provider Taxonomy codes that fall within the Non-Individual heading 

 **References** 

* Excluded from [NUCCCareProviderTaxonomyIndividualOrGroups](ValueSet-NUCCCareProviderTaxonomyIndividualOrGroups.md)
* [CRD Service Request](StructureDefinition-profile-servicerequest.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "NUCCCareProviderTaxonomyNonIndividual",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/NUCCCareProviderTaxonomyNonIndividual",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.48.31"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "NUCCCareProviderTaxonomyNonIndividual",
  "title" : "NUCC Healthcare Provider Taxonomy Non-Individual",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "All NUCC Healthcare Provider Taxonomy codes that fall within the Non-Individual heading",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Agencies"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Ambulatory Health Care Facilities"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Hospital Units"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Hospitals"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Laboratories"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Managed Care Organizations"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Nursing & Custodial Care Facilities"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Other Service Providers"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Residential Treatment Facilities"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Respite Care Facility"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Suppliers"
          }
        ]
      },
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "grouping",
            "op" : "=",
            "value" : "Transportation Services"
          }
        ]
      }
    ]
  }
}

```
