# Questionnaire Task example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example Task: Questionnaire Task example

Language: en

**basedOn**: [MedicationRequest: identifier = http://example.org/portal/prescriptions#12345689 (use: official, ); status = draft; intent = order; medication[x] = ->Medication Azithromycin 250 mg oral tablet; authoredOn = 2015-01-15; reasonCode = Traveler's Diarrhea (disorder); note = Patient told to take with food](MedicationRequest-example.md)

**status**: Ready

**intent**: order

**code**: Complete Questionnaire

**for**: [Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**encounter**: [Encounter: identifier = http://example.org/zorgportal/identifiers/visits#v1451 (use: official, ); status = in-progress; class = ambulatory (ActCode#AMB); type = Patient-initiated encounter; priority = Non-urgent cardiological admission; reasonCode = Heart valve replacement](Encounter-example.md)

**authoredOn**: 2018-08-09

**requester**: [http://example.org/fhir/Organization/payer](http://example.org/fhir/Organization/payer)

**reasonCode**: Helps assess opioid appropriateness

> **input****type**: Questionnaire**value**: `http://example.org/Questionnaire/XYZ|2`

> **input****type**: Response Endpoint**value**: [http://example.org/somePayer](http://example.org/somePayer)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "questionnaire-example",
  "language" : "en",
  "basedOn" : [
    {
      "reference" : "MedicationRequest/example"
    }
  ],
  "status" : "ready",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/temp",
        "code" : "complete-questionnaire"
      }
    ]
  },
  "for" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "authoredOn" : "2018-08-09",
  "requester" : {
    "reference" : "http://example.org/fhir/Organization/payer"
  },
  "reasonCode" : {
    "text" : "Helps assess opioid appropriateness"
  },
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/temp",
            "code" : "questionnaire"
          }
        ]
      },
      "valueCanonical" : "http://example.org/Questionnaire/XYZ|2"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/temp",
            "code" : "response-endpoint"
          }
        ]
      },
      "valueUrl" : "http://example.org/somePayer"
    }
  ]
}

```
