# CRD Vision Prescription - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Vision Prescription 

 
This profile defines an initial profile on the VisionPrescription resource to support coverage requirements discovery. 

### Usage

§§prof-12^crd-client^exchange:CRD Clients **SHALL** use the CRD VisionPrescription profile to [resolve references](foundation.md#additional-data-retrieval) to VisionPrescription resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects.^

CRD Clients **SHALL** use the CRD VisionPrescription profile to [resolve references](foundation.md#additional-data-retrieval) to VisionPrescription resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:

* [order-select](hooks.md#order-select)
* [order-sign](hooks.md#order-sign)
* [order-dispatch](hooks.md#order-dispatch)

§§

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery.

NOTE: This profile is not currently based on US Core because US Core does not yet profile the VisionPrescription resource. If a future version of US-Core adds support for the resource, this profile will be revised to extend the US Core profile. 

**Usages:**

* Use this Profile: [CRD CDSHooks Additional Orders Response (Logical Definition)](StructureDefinition-CRDHooksResponse-additionalOrders.md), [CRD CDSHooks Alternate Request Response (Logical Definition)](StructureDefinition-CRDHooksResponse-alternateRequest.md), [CRD CDSHooks Coverage Information Response (Logical Definition)](StructureDefinition-CRDHooksResponse-coverageInformation.md) and [CRD Bundle of Request Resources](StructureDefinition-profile-bundle-request.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-visionprescription)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-visionprescription.csv), [Excel](../StructureDefinition-profile-visionprescription.xlsx), [Schematron](../StructureDefinition-profile-visionprescription.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-visionprescription",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-visionprescription",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.19"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDVisionPrescription",
  "title" : "CRD Vision Prescription",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile defines an initial profile on the VisionPrescription resource to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "VisionPrescription",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/VisionPrescription",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "VisionPrescription.contained",
        "path" : "VisionPrescription.contained",
        "comment" : "Any references found in this resource, with the exception of 'Patient' could potentially be resource-specific and thus transmitted as contained resources.",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.extension",
        "path" : "VisionPrescription.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            },
            {
              "type" : "value",
              "path" : "value"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "VisionPrescription.extension:Coverage-Information",
        "path" : "VisionPrescription.extension",
        "sliceName" : "Coverage-Information",
        "short" : "Coverage Info",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-coverage-information"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.extension:EncounterCategory",
        "path" : "VisionPrescription.extension",
        "sliceName" : "EncounterCategory",
        "short" : "Encounter Category",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-request-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.extension:EncounterCategory.value[x]",
        "path" : "VisionPrescription.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode|3.0.0"
        }
      },
      {
        "id" : "VisionPrescription.extension:ServiceCategory",
        "path" : "VisionPrescription.extension",
        "sliceName" : "ServiceCategory",
        "short" : "Service Category",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-request-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.extension:ServiceCategory.value[x]",
        "path" : "VisionPrescription.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/X12ServiceType"
        }
      },
      {
        "id" : "VisionPrescription.identifier",
        "path" : "VisionPrescription.identifier",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.status",
        "path" : "VisionPrescription.status",
        "comment" : "This will be 'draft' when using order-select or an initial order-sign, but may be 'active' or other values for order-sign representing edits to the order or for order-dispatch.",
        "example" : [
          {
            "label" : "General",
            "valueCode" : "draft"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.created",
        "path" : "VisionPrescription.created",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.patient",
        "path" : "VisionPrescription.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.encounter",
        "path" : "VisionPrescription.encounter",
        "comment" : "potentially relevant for CRD in some situations.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.dateWritten",
        "path" : "VisionPrescription.dateWritten",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.prescriber",
        "path" : "VisionPrescription.prescriber",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-practitionerrole"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification",
        "path" : "VisionPrescription.lensSpecification",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.extension",
        "path" : "VisionPrescription.lensSpecification.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "VisionPrescription.lensSpecification.extension:BillingOptions",
        "path" : "VisionPrescription.lensSpecification.extension",
        "sliceName" : "BillingOptions",
        "short" : "Expected Billing Code(s)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.product",
        "path" : "VisionPrescription.lensSpecification.product",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.eye",
        "path" : "VisionPrescription.lensSpecification.eye",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.sphere",
        "path" : "VisionPrescription.lensSpecification.sphere",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.cylinder",
        "path" : "VisionPrescription.lensSpecification.cylinder",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.axis",
        "path" : "VisionPrescription.lensSpecification.axis",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.prism",
        "path" : "VisionPrescription.lensSpecification.prism",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.prism.amount",
        "path" : "VisionPrescription.lensSpecification.prism.amount",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.prism.base",
        "path" : "VisionPrescription.lensSpecification.prism.base",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.add",
        "path" : "VisionPrescription.lensSpecification.add",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.power",
        "path" : "VisionPrescription.lensSpecification.power",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.backCurve",
        "path" : "VisionPrescription.lensSpecification.backCurve",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.diameter",
        "path" : "VisionPrescription.lensSpecification.diameter",
        "mustSupport" : true
      },
      {
        "id" : "VisionPrescription.lensSpecification.duration",
        "path" : "VisionPrescription.lensSpecification.duration",
        "mustSupport" : true
      }
    ]
  }
}

```
