# CRD Timing Data Type - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Data Type Profile: CRD Timing Data Type 

 
This profile specifies CRD-specific expectations on the use of the Timing data type 

**Usages:**

* Use this DataType Profile: [CRD Medication Request](StructureDefinition-profile-medicationrequest.md), [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md) and [CRD Service Request](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-timing)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-timing.csv), [Excel](../StructureDefinition-profile-timing.xlsx), [Schematron](../StructureDefinition-profile-timing.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-timing",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-timing",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.52"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDTiming",
  "title" : "CRD Timing Data Type",
  "status" : "active",
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies CRD-specific expectations on the use of the Timing data type",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Timing",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Timing",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Timing.event",
        "path" : "Timing.event",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat",
        "path" : "Timing.repeat",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]",
        "path" : "Timing.repeat.bounds[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsPeriod",
        "path" : "Timing.repeat.bounds[x]",
        "sliceName" : "boundsPeriod",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.count",
        "path" : "Timing.repeat.count",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.duration",
        "path" : "Timing.repeat.duration",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.durationUnit",
        "path" : "Timing.repeat.durationUnit",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.frequency",
        "path" : "Timing.repeat.frequency",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.period",
        "path" : "Timing.repeat.period",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.periodUnit",
        "path" : "Timing.repeat.periodUnit",
        "mustSupport" : true
      }
    ]
  }
}

```
