# CRD Questionnaire Task - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Questionnaire Task 

 
This profile specifies constraints on the Task resource to support requests for form (Questionnaire) completion. 

### Usage

 This profile on Task allows a response CDS Hooks Card to request a user to fill out a Questionnaire (pointed to as a Task.input). It supports the process described in the [Deferring Card Actions](cards.md#request-form-completion-response-type) portion of the spec.

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. </br> 

**Usages:**

* Use this Profile: [CRD CDSHooks Form Completion Response (Logical Definition)](StructureDefinition-CRDHooksResponse-formCompletion.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-taskquestionnaire)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-taskquestionnaire.csv), [Excel](../StructureDefinition-profile-taskquestionnaire.xlsx), [Schematron](../StructureDefinition-profile-taskquestionnaire.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-taskquestionnaire",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-taskquestionnaire",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.18"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDTaskQuestionnaire",
  "title" : "CRD Questionnaire Task",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies constraints on the Task resource to support requests for form (Questionnaire) completion.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task"
      },
      {
        "id" : "Task.basedOn",
        "path" : "Task.basedOn",
        "requirements" : "Allows linking the Questionnaire to the particular 'request' that triggered its creation.",
        "mustSupport" : true
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "patternCode" : "ready"
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "patternCode" : "order"
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "requirements" : "Questionnaire tasks resulting from decision support are never orders, merely to-dos",
        "max" : "0"
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
            ]
          }
        ]
      },
      {
        "id" : "Task.encounter",
        "path" : "Task.encounter",
        "comment" : "This should be set to the same encounter as specified in the launch context (if any).",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "short" : "Payer requesting form completion",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "comment" : "This can be populated within the CRD client to delegate responsibility for filling out the form to someone else.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Task.reasonCode.text",
        "path" : "Task.reasonCode.text",
        "mustSupport" : true
      },
      {
        "id" : "Task.input",
        "path" : "Task.input",
        "min" : 1
      },
      {
        "id" : "Task.input:questionnaire",
        "path" : "Task.input",
        "sliceName" : "questionnaire",
        "min" : 1
      }
    ]
  }
}

```
