# CRD Encounter - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Encounter 

 
This profile specifies additional extensions and constraints on the US Core Encounter profile to support coverage requirements discovery. 

### Usage

§§prof-7^crd-client^exchange:CRD Clients **SHALL** use the CRD Encounter profile to [resolve references](foundation.md#additional-data-retrieval) to Encounter resources passed to CRD Servers, including `encounterId` context references.^

CRD Clients **SHALL** use the CRD Encounter profile to [resolve references](foundation.md#additional-data-retrieval) to Encounter resources passed to CRD Servers, including `encounterId` context references when invoking the following CDS Hooks:

* [appointment-book](hooks.md#appointment-book)
* [encounter-start](hooks.md#encounter-start)
* [encounter-discharge](hooks.md#encounter-discharge)
* [order-select](hooks.md#order-select)
* [order-sign](hooks.md#order-sign)
* [order-dispatch](hooks.md#order-dispatch)

§§

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. 

**Usages:**

* Use this Profile: [CRD CDSHooks Coverage Information Response (Logical Definition)](StructureDefinition-CRDHooksResponse-coverageInformation.md) and [CRD Bundle of Request Resources](StructureDefinition-profile-bundle-request.md)
* Refer to this Profile: [CRD Communication Request](StructureDefinition-profile-communicationrequest.md), [CRD Device Request](StructureDefinition-profile-devicerequest.md), [CRD Encounter](StructureDefinition-profile-encounter.md), [CRD Medication Request](StructureDefinition-profile-medicationrequest.md)... Show 4 more, [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md), [CRD Service Request](StructureDefinition-profile-servicerequest.md), [CRD Questionnaire Task](StructureDefinition-profile-taskquestionnaire.md) and [CRD Vision Prescription](StructureDefinition-profile-visionprescription.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-encounter)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-encounter.csv), [Excel](../StructureDefinition-profile-encounter.xlsx), [Schematron](../StructureDefinition-profile-encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-encounter",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|3.1.1"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.10"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDEncounter",
  "title" : "CRD Encounter",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies additional extensions and constraints on the US Core Encounter profile to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter.contained",
        "path" : "Encounter.contained",
        "comment" : "Any references found in this resource, with the exception of 'Patient' could potentially be resource-specific and thus transmitted as contained resources.",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.extension",
        "path" : "Encounter.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Encounter.extension:Coverage-Information",
        "path" : "Encounter.extension",
        "sliceName" : "Coverage-Information",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-coverage-information"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.serviceType.extension:BillingOptions",
        "path" : "Encounter.serviceType.extension",
        "sliceName" : "BillingOptions",
        "short" : "Expected Billing Code(s)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.basedOn",
        "path" : "Encounter.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "comment" : "...  While the package for US Core 3.1.1 limits references to only Practitioner, there is a patch that indicates that PractitionerRole is also permitted"
      },
      {
        "id" : "Encounter.appointment",
        "path" : "Encounter.appointment",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-with-order",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-no-order"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.length",
        "path" : "Encounter.length",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.diagnosis.condition",
        "path" : "Encounter.diagnosis.condition",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location.location",
        "path" : "Encounter.location.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.location.status",
        "path" : "Encounter.location.status",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location.period",
        "path" : "Encounter.location.period",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.partOf",
        "path" : "Encounter.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
            ]
          }
        ]
      }
    ]
  }
}

```
