# Billing Options - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Extension: Billing Options 

Identifies billing codes that could potentially be used for this clinical code

**Context of Use**

### Introduction

§billopt-1?^crd-client^exchange:CRD clients **SHALL** use the billing-options extension to convey likely billing codes if they are known, but are not required to know billing codes (e.g. if ordering and performing systems will differ).§ §billopt-2?^crd-server^processing:CRD servers **SHALL NOT** depend on the billing-options extension being present in order to provide a response.§ §billopt-3^crd-server^processing:If codes are provided with the billing-options extension, CRD servers **SHALL** consider any codes provided and **MAY** consider additional codes determined by their own mapping when returning coverage information responses.§

**Usage info**

**Usages:**

* Use this Extension: [CRD Appointment without Order](StructureDefinition-profile-appointment-no-order.md), [CRD Communication Request](StructureDefinition-profile-communicationrequest.md), [CRD Device](StructureDefinition-profile-device.md), [CRD Device Request](StructureDefinition-profile-devicerequest.md)... Show 5 more, [CRD Encounter](StructureDefinition-profile-encounter.md), [CRD Medication](StructureDefinition-profile-medication.md), [CRD Medication Request](StructureDefinition-profile-medicationrequest.md), [CRD Service Request](StructureDefinition-profile-servicerequest.md) and [CRD Vision Prescription](StructureDefinition-profile-visionprescription.md)
* Examples for this Extension: [ServiceRequest/example](ServiceRequest-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/ext-billing-options)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-ext-billing-options.csv), [Excel](../StructureDefinition-ext-billing-options.xlsx), [Schematron](../StructureDefinition-ext-billing-options.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-billing-options",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.24"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDBillingOptions",
  "title" : "Billing Options",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Identifies billing codes that could potentially be used for this clinical code",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "Used to allow conveying multiple (possibly conflicting) billing codes that cannot be provided as translations because they do not necessarily all represent the same ordering concept.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Appointment.serviceType"
    },
    {
      "type" : "fhirpath",
      "expression" : "CommunicationRequest.payload.content.extension('http://hl7.org/fhir/5.0/StructureDefinition/extension-CommunicationRequest.payload.content%5Bx%5D')"
    },
    {
      "type" : "element",
      "expression" : "Device"
    },
    {
      "type" : "fhirpath",
      "expression" : "DeviceRequest.code.ofType(CodeableConcept)"
    },
    {
      "type" : "element",
      "expression" : "Encounter.serviceType"
    },
    {
      "type" : "element",
      "expression" : "Medication.code"
    },
    {
      "type" : "fhirpath",
      "expression" : "MedicationRequest.medication.ofType(CodeableConcept)"
    },
    {
      "type" : "element",
      "expression" : "NutritionOrder"
    },
    {
      "type" : "element",
      "expression" : "ServiceRequest.code"
    },
    {
      "type" : "element",
      "expression" : "VisionPrescription.lensSpecification.product"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Billing Options",
        "definition" : "Identifies billing codes that could potentially be used for this clinical code",
        "comment" : "This will typically only be populated if the ordering and performing systems are the same"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/billingCodes"
        }
      }
    ]
  }
}

```
