# CRD CDSHooks Coverage Information Response (Logical Definition) - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CRD CDSHooks Coverage Information Response (Logical Definition) ( Abstract ) 

 
Defines CRD-specific constraints for the Coverage Information response type 

**Usages:**

* Use this Logical Model Profile: [CRD CDSHooks Response (Logical Definition)](StructureDefinition-CRDHooksResponse.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CRDHooksResponse-coverageInformation)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CRDHooksResponse-coverageInformation.csv), [Excel](../StructureDefinition-CRDHooksResponse-coverageInformation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CRDHooksResponse-coverageInformation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-coverageInformation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.43"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDHooksResponseCoverageInformation",
  "title" : "CRD CDSHooks Coverage Information Response (Logical Definition)",
  "status" : "active",
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Defines CRD-specific constraints for the Coverage Information response type",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : true,
  "type" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponseBase",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHooksResponse",
        "path" : "CDSHooksResponse"
      },
      {
        "id" : "CDSHooksResponse.systemActions",
        "path" : "CDSHooksResponse.systemActions",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.systemActions.type",
        "path" : "CDSHooksResponse.systemActions.type",
        "patternCode" : "update"
      },
      {
        "id" : "CDSHooksResponse.systemActions.resource",
        "path" : "CDSHooksResponse.systemActions.resource",
        "type" : [
          {
            "code" : "Resource",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-no-order",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-communicationrequest",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-devicerequest",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-medicationrequest",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-nutritionorder",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-visionprescription"
            ]
          }
        ],
        "constraint" : [
          {
            "key" : "crd-respci1",
            "severity" : "error",
            "human" : "Updated resource must have at least one coverage-information extension",
            "expression" : "extension('http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-coverage-information').exists()"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.systemActions.resourceId",
        "path" : "CDSHooksResponse.systemActions.resourceId",
        "max" : "0"
      }
    ]
  }
}

```
