# CDS Hooks Services Configuration Extension - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CDS Hooks Services Configuration Extension 

 
An extension for the CDS Hooks 'services' object that indicates configuration options supported by the CDS server 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CDSHookServicesExtensionConfiguration)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CDSHookServicesExtensionConfiguration.csv), [Excel](../StructureDefinition-CDSHookServicesExtensionConfiguration.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CDSHookServicesExtensionConfiguration",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServicesExtensionConfiguration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.23"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CDSHookServicesExtensionConfiguration",
  "title" : "CDS Hooks Services Configuration Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "An extension for the CDS Hooks 'services' object that indicates configuration options supported by the CDS server",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CDSHooksServices.services.extension"
    }
  ],
  "type" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServicesExtensionConfiguration",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHookServicesExtensionConfiguration",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-name",
            "valueString" : "davinci-crd.configuration-options"
          }
        ],
        "path" : "CDSHookServicesExtensionConfiguration",
        "short" : "An allowed configuration option",
        "definition" : "A specific configuration option that is supported by the server and can be transmitted when invoking a hooks service"
      },
      {
        "id" : "CDSHookServicesExtensionConfiguration.code",
        "path" : "CDSHookServicesExtensionConfiguration.code",
        "short" : "Identifies the setting configuration when hook is invoked",
        "definition" : "A code that will be used when setting configuration during hook invocation, and has an (extensible) binding to the CRD Card Types ValueSet.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cardType"
        }
      },
      {
        "id" : "CDSHookServicesExtensionConfiguration.type",
        "path" : "CDSHookServicesExtensionConfiguration.type",
        "short" : "boolean | integer (JSON types)",
        "definition" : "A data type for the parameter.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/configTypes"
        }
      },
      {
        "id" : "CDSHookServicesExtensionConfiguration.name",
        "path" : "CDSHookServicesExtensionConfiguration.name",
        "short" : "A display name for the configuration option",
        "definition" : "A display name for the configuration option to appear in the client’s user interface when performing configuration",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "CDSHookServicesExtensionConfiguration.description",
        "path" : "CDSHookServicesExtensionConfiguration.description",
        "short" : "1-2 sentences - the effect of the configuration option",
        "definition" : "A description providing a 1-2 sentence description of the effect of the configuration option",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "CDSHookServicesExtensionConfiguration.default",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice",
            "valueBoolean" : true
          }
        ],
        "path" : "CDSHookServicesExtensionConfiguration.default",
        "short" : "Shows users what to expect when an override is not specified",
        "definition" : "A default value SHOULD also be provided to show users what to expect when an override is not specified",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          },
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
