# CDS Hooks Service Request Requested CRD Version Extension - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Data Type Profile: CDS Hooks Service Request Requested CRD Version Extension 

 
Allows indicating the desired CRD version when invoking CRD on a service that supports multiple versions 

**Usages:**

* This Primitive Type Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CDSHookServiceRequestExtensionRequestCRDVersion)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CDSHookServiceRequestExtensionRequestCRDVersion.csv), [Excel](../StructureDefinition-CDSHookServiceRequestExtensionRequestCRDVersion.xlsx), [Schematron](../StructureDefinition-CDSHookServiceRequestExtensionRequestCRDVersion.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CDSHookServiceRequestExtensionRequestCRDVersion",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServiceRequestExtensionRequestCRDVersion",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.49"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CDSHookServiceRequestExtensionRequestCRDVersion",
  "title" : "CDS Hooks Service Request Requested CRD Version Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Allows indicating the desired CRD version when invoking CRD on a service that supports multiple versions",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "primitive-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CDSHooksRequest.extension"
    }
  ],
  "type" : "string",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/string",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "string",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-name",
            "valueString" : "davinci-crd.requestedVersion"
          }
        ],
        "path" : "string",
        "short" : "CRD version requested by the client",
        "definition" : "Indicates the CRD version the service response needs to comply with.  (If this is not a version supported by the service, it **SHALL** return an error.)",
        "max" : "1"
      }
    ]
  }
}

```
