# MedicationRequest annotated example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example MedicationRequest: MedicationRequest annotated example

Language: en

> **Coverage Information**
> **url**coverage
**value**: [Coverage: identifier = Member Number; status = active; type = extended healthcare; dependent = 0; relationship = Self; period = 2011-05-23 --> 2012-05-23](Coverage-example.md)
> **url**covered
**value**: conditional
> **url**pa-needed
**value**: satisfied
> **url**doc-needed
**value**: admin
> **url**doc-purpose
**value**: withclaim
> **url**info-needed
**value**: performer
> **url**billingCode
**value**: [Current Procedural Terminology (CPT®): 77067](http://terminology.hl7.org/6.2.0/CodeSystem-CPT.html#CPT-77067) (Screening mammography, bilateral (2-view study of each breast), including computer-aided detection (CAD) when performed)
> **url**reason
**value**: Prior auth waved due to gold-card status**category**: cat-other**code**: Policy Link**value**: [http://example.org/somepayer/policy123.pdf#abc](http://example.org/somepayer/policy123.pdf#abc)**qualification**: Additional policy details can be found here
> **url**detail

> **url**questionnaire
**value**: `http://example.org/some-payer/Questionnaire/123|1.3.0`
> **url**[date](http://hl7.org/fhir/R4/datatypes.html#date)
**value**: 2019-02-15
> **url**coverage-assertion-id
**value**: 12345ABC
> **url**satisfied-pa-id
**value**: XXYYZ
> **url**contact
**value**: Help Desk: [http://some-payer.org/xyz-sub-org/get-help-here.html](http://some-payer.org/xyz-sub-org/get-help-here.html)
> **url**expiry-date
**value**: 2019-08-01

**status**: Draft

**intent**: Original Order

**medication**: mycophenolate mofetil 250 MG Oral Capsule [Cellcept]

**subject**: [Jane Smith](http://example.org/Patient/123)

**encounter**: [http://example.org/Encounter/ABC](http://example.org/Encounter/ABC)

**authoredOn**: 2019-02-15

**requester**: [Dr. Jones](http://example.org/PractitionerRole/987)

**note**: By XYZ Insurance @2019-02-15 15:07:18-0500

> 

Unsolicited prior authorization for Jane Smith to receive 6 tablets Cellcept 250 MG Oral Capsule BID granted. Please note prior authorization # 12345 on claim submission.


> **dosageInstruction****text**: 6 tablets every 12 hours.**timing**: Once per 12 hours

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 6 tablet |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "annotated-example",
  "language" : "en",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "coverage",
          "valueReference" : {
            "reference" : "Coverage/example"
          }
        },
        {
          "url" : "covered",
          "valueCode" : "conditional"
        },
        {
          "url" : "pa-needed",
          "valueCode" : "satisfied"
        },
        {
          "url" : "doc-needed",
          "valueCode" : "admin"
        },
        {
          "url" : "doc-purpose",
          "valueCode" : "withclaim"
        },
        {
          "url" : "info-needed",
          "valueCode" : "performer"
        },
        {
          "url" : "billingCode",
          "valueCoding" : {
            "system" : "http://www.ama-assn.org/go/cpt",
            "code" : "77067"
          }
        },
        {
          "url" : "reason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
                "code" : "gold-card"
              }
            ],
            "text" : "Prior auth waved due to gold-card status"
          }
        },
        {
          "extension" : [
            {
              "url" : "category",
              "valueCode" : "cat-other"
            },
            {
              "url" : "code",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
                    "code" : "policy-link"
                  }
                ]
              }
            },
            {
              "url" : "value",
              "valueUrl" : "http://example.org/somepayer/policy123.pdf#abc"
            },
            {
              "url" : "qualification",
              "valueString" : "Additional policy details can be found here"
            }
          ],
          "url" : "detail"
        },
        {
          "url" : "questionnaire",
          "valueCanonical" : "http://example.org/some-payer/Questionnaire/123|1.3.0"
        },
        {
          "url" : "date",
          "valueDate" : "2019-02-15"
        },
        {
          "url" : "coverage-assertion-id",
          "valueString" : "12345ABC"
        },
        {
          "url" : "satisfied-pa-id",
          "valueString" : "XXYYZ"
        },
        {
          "url" : "contact",
          "valueContactDetail" : {
            "name" : "Help Desk",
            "telecom" : [
              {
                "system" : "url",
                "value" : "http://some-payer.org/xyz-sub-org/get-help-here.html"
              }
            ]
          }
        },
        {
          "url" : "expiry-date",
          "valueDate" : "2019-08-01"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-coverage-information"
    }
  ],
  "status" : "draft",
  "intent" : "original-order",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "616447",
        "display" : "mycophenolate mofetil 250 MG Oral Capsule [Cellcept]"
      }
    ]
  },
  "subject" : {
    "reference" : "http://example.org/Patient/123",
    "display" : "Jane Smith"
  },
  "encounter" : {
    "reference" : "http://example.org/Encounter/ABC"
  },
  "authoredOn" : "2019-02-15",
  "requester" : {
    "reference" : "http://example.org/PractitionerRole/987",
    "display" : "Dr. Jones"
  },
  "note" : [
    {
      "authorString" : "XYZ Insurance",
      "time" : "2019-02-15T15:07:18-05:00",
      "text" : "Unsolicited prior authorization for Jane Smith to receive 6 tablets Cellcept 250 MG Oral Capsule BID granted.  Please note prior authorization # 12345 on claim submission."
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "6 tablets every 12 hours.",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 12,
          "periodUnit" : "h"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 6,
            "unit" : "tablet"
          }
        }
      ]
    }
  ]
}

```
