# Encounter example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example Encounter: Encounter example

Language: en

**identifier**: `http://example.org/zorgportal/identifiers/visits`/v1451 (use: official, )

**status**: In Progress

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**type**: Patient-initiated encounter

**priority**: Non-urgent cardiological admission

**subject**: [Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

### Participants

| | |
| :--- | :--- |
| - | **Individual** |
| * | [Practitioner Bone ](Practitioner-full.md) |

### Lengths

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Value** | **Unit** | **System** | **Code** |
| * | 140 | min | [http://unitsofmeasure.org](http://terminology.hl7.org/6.2.0/CodeSystem-v3-ucum.html) | min |

**reasonCode**: Heart valve replacement

### Hospitalizations

| | | | |
| :--- | :--- | :--- | :--- |
| - | **PreAdmissionIdentifier** | **AdmitSource** | **DischargeDisposition** |
| * | `http://example.org/zorgportal/identifiers/pre-admissions`/93042 (use: official, ) | Referral by physician | Discharge to home |

**serviceProvider**: [University Medical Center](Organization-example.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "example",
  "language" : "en",
  "identifier" : [
    {
      "use" : "official",
      "system" : "http://example.org/zorgportal/identifiers/visits",
      "value" : "v1451"
    }
  ],
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "270427003",
          "display" : "Patient-initiated encounter"
        }
      ]
    }
  ],
  "priority" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "310361003",
        "display" : "Non-urgent cardiological admission"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "participant" : [
    {
      "individual" : {
        "reference" : "Practitioner/full"
      }
    }
  ],
  "length" : {
    "value" : 140,
    "unit" : "min",
    "system" : "http://unitsofmeasure.org",
    "code" : "min"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "34068001",
          "display" : "Heart valve replacement"
        }
      ]
    }
  ],
  "hospitalization" : {
    "preAdmissionIdentifier" : {
      "use" : "official",
      "system" : "http://example.org/zorgportal/identifiers/pre-admissions",
      "value" : "93042"
    },
    "admitSource" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "305956004",
          "display" : "Referral by physician"
        }
      ]
    },
    "dischargeDisposition" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "306689006",
          "display" : "Discharge to home"
        }
      ]
    }
  },
  "serviceProvider" : {
    "reference" : "Organization/example",
    "display" : "University Medical Center"
  }
}

```
