# CommunicationRequest example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example CommunicationRequest: CommunicationRequest example

Language: en

**identifier**: `http://example.org/insurer/123456`/ABC123

**basedOn**: EligibilityRequest

**replaces**: prior CommunicationRequest

**groupIdentifier**: 12345

**status**: Draft

**category**: Instruction

**priority**: Routine

**medium**: written

**subject**: [Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**encounter**: [Encounter: identifier = http://example.org/zorgportal/identifiers/visits#v1451 (use: official, ); status = in-progress; class = ambulatory (ActCode#AMB); type = Patient-initiated encounter; priority = Non-urgent cardiological admission; reasonCode = Heart valve replacement](Encounter-example.md)

### Payloads

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Content[x]** |
| * |  | Liver pathology biopsy report |

**occurrence**: 2016-06-10 11:01:10-0800

**authoredOn**: 2016-06-10 11:01:10-0800

**requester**: [Practitioner Bone ](Practitioner-full.md)

**recipient**: [Organization University Medical Center](Organization-example.md)

**sender**: [http://example.org/fhir/someOtherProvider](http://example.org/fhir/someOtherProvider)



## Resource Content

```json
{
  "resourceType" : "CommunicationRequest",
  "id" : "example",
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://example.org/insurer/123456",
      "value" : "ABC123"
    }
  ],
  "basedOn" : [
    {
      "display" : "EligibilityRequest"
    }
  ],
  "replaces" : [
    {
      "display" : "prior CommunicationRequest"
    }
  ],
  "groupIdentifier" : {
    "value" : "12345"
  },
  "status" : "draft",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "instruction"
        }
      ]
    }
  ],
  "priority" : "routine",
  "medium" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationMode",
          "code" : "WRITTEN",
          "display" : "written"
        }
      ],
      "text" : "written"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "payload" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-CommunicationRequest.payload.content%5Bx%5D",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "65752-8",
                "display" : "Liver Pathology biopsy report"
              }
            ]
          }
        }
      ],
      "contentString" : "Liver pathology biopsy report"
    }
  ],
  "occurrenceDateTime" : "2016-06-10T11:01:10-08:00",
  "authoredOn" : "2016-06-10T11:01:10-08:00",
  "requester" : {
    "reference" : "Practitioner/full"
  },
  "recipient" : [
    {
      "reference" : "Organization/example"
    }
  ],
  "sender" : {
    "reference" : "http://example.org/fhir/someOtherProvider"
  }
}

```
