# CRD Temporary Codes - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CodeSystem: CRD Temporary Codes 

 
Codes temporarily defined as part of the CRD implementation guide. These will eventually migrate into an officially maintained terminology (likely either SNOMED CT or HL7's UTG code systems). 

This code system contains codes that are expected to be formally proposed as codes in other 'official' code systems in the future such as LOINC, SNOMED, etc. or as part of code systems managed in [http://terminology.hl7.org](http://terminology.hl7.org). The canonical URL (and possibly the codes themselves) for all codes appearing in this code system **ARE** expected to change in a future release. Implementers should prepare for this transition when they write their code, allowing for the possibility of checking for both the old and new code and ensuring it is straightforward to transmit both the old and new code when the time comes. Concept maps will likely be available to assist with this transition.

This Code system is referenced in the definition of the following value sets:

* [CRDCoverageAssertionReasons](ValueSet-coverageAssertionReasons.md)
* [CRDCoverageDetailCodes](ValueSet-coverageDetail.md)
* [CRDConformanceStatementCategories](ValueSet-cs-categories.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "temp",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.16.1"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDTempCodes",
  "title" : "CRD Temporary Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Codes temporarily defined as part of the CRD implementation guide.  These will eventually migrate into an officially maintained terminology (likely either SNOMED CT or HL7's UTG code systems).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 37,
  "property" : [
    {
      "code" : "abstract",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "gold-card",
      "display" : "Gold card",
      "definition" : "Ordering Practitioner has been granted 'gold card' status with this payer/coverage type."
    },
    {
      "code" : "no-member-found",
      "display" : "Member not found",
      "definition" : "The CRD server was unable to find a matching member, so no coverage information can be provided"
    },
    {
      "code" : "no-active-coverage",
      "display" : "Coverage not active",
      "definition" : "The referenced insurance coverage for the member is not active, so no coverage information can be provided"
    },
    {
      "code" : "auth-out-network",
      "display" : "Authorization needed out-of-network",
      "definition" : "Authorization is necessary if out-of-network."
    },
    {
      "code" : "_limitation",
      "display" : "Limitation details",
      "definition" : "Identifies detail codes that define limitations of coverage.  (Category should be 'cat-limitation')",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "allowed-quantity",
          "display" : "Maximum quantity",
          "definition" : "Indicates limitations on the number of services/products allowed (possibly per time period).  Value should be a Quantity"
        },
        {
          "code" : "allowed-period",
          "display" : "Maximum allowed period",
          "definition" : "Indicates the maximum period of time that can be covered in a single order.  Value should be a Period"
        }
      ]
    },
    {
      "code" : "_decisional",
      "display" : "Decisional details",
      "definition" : "Identifies detail codes that may impact patient and clinician decision making  (Category should be 'cat-decisional')",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "in-network-copay",
          "display" : "Copay for in-network",
          "definition" : "Indicates a percentage co-pay to expect if delivered in-network.  Value should be a Quantity."
        },
        {
          "code" : "out-network-copay",
          "display" : "Copay for out-of-network",
          "definition" : "Indicates a percentage co-pay to expect if delivered out-of-network.  Value should be a Quantity."
        },
        {
          "code" : "concurrent-review",
          "display" : "Concurrent review",
          "definition" : "Additional payer-defined documentation will be required prior to claim payment.  Value should be a boolean."
        },
        {
          "code" : "appropriate-use-needed",
          "display" : "Appropriate use",
          "definition" : "Payer-defined appropriate use process must be invoked to determine coverage.  Value should be a boolean."
        }
      ]
    },
    {
      "code" : "_other",
      "display" : "Other details",
      "definition" : "Identifies detail codes that are generally not relevant to clinicians/patients  (Category should be 'cat-other')",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "policy-link",
          "display" : "Policy Link",
          "definition" : "A URL pointing to the specific portion of a payer policy, coverage agreement or similar authoritative document that provides a portion of the basis for the decision documented in the coverage-information.  Value should be a url."
        }
      ]
    },
    {
      "code" : "instructions",
      "display" : "Instructions",
      "definition" : "Information to display to the user that gives guidance about what steps to take in achieving the recommended actions identified by this coverage-information (e.g. special instructions about requesting authorization, details about information needed, details about data retention, etc.).  Value should be a string.  (Category may vary.)"
    },
    {
      "code" : "_cardType",
      "display" : "Card Type (abstract)",
      "definition" : "A collector for different profiles on CDS Hooks card",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "coverage-info",
          "display" : "Coverage Information",
          "definition" : "Information related to the patient's coverage, including whether a service is covered, requires prior authorization, is approved without seeking prior authorization, and/or requires additional documentation or data collection",
          "concept" : [
            {
              "code" : "unsolicited-determ",
              "display" : "Unsolicited Determination",
              "definition" : "An unsolicited approval of the service as having prior authorization requirements met without a formal submission of a prior authorization request"
            }
          ]
        },
        {
          "code" : "claim",
          "display" : "Claim",
          "definition" : "Information about what steps need to be taken to submit a claim for the service"
        },
        {
          "code" : "insurance",
          "display" : "Insurance",
          "definition" : "Allows a provider to update the patient's coverage information with additional details from the payer (e.g. expiry date, coverage extensions)"
        },
        {
          "code" : "limits",
          "display" : "Limits",
          "definition" : "Messages warning about the patient approaching or exceeding their limits for a particular type of coverage or expiry date for coverage in general"
        },
        {
          "code" : "network",
          "display" : "Network",
          "definition" : "Providing information about in-network providers that could deliver the order (or in-network alternatives for an order directed out-of-network)"
        },
        {
          "code" : "appropriate-use",
          "display" : "Appropriate Use",
          "definition" : "Guidance on whether appropriate-use documentation is needed"
        },
        {
          "code" : "cost",
          "display" : "Cost",
          "definition" : "What is the anticipated cost to the patient based on their coverage"
        },
        {
          "code" : "therapy-alternatives-opt",
          "display" : "Optional Therapy Alternatives",
          "definition" : "Are there alternative therapies that have better coverage and/or are lower-cost for the patient"
        },
        {
          "code" : "therapy-alternatives-req",
          "display" : "Required Therapy Alternatives",
          "definition" : "Are there alternative therapies that must be tried first prior to coverage being available for the proposed therapy"
        },
        {
          "code" : "clinical-reminder",
          "display" : "Clinical Reminder",
          "definition" : "Reminders that a patient is due for certain screening or other therapy (based on payer recorded date of last intervention)"
        },
        {
          "code" : "duplicate-therapy",
          "display" : "Duplicate Therapy",
          "definition" : "Notice that the proposed intervention has already recently occurred with a different provider when that information is not already available in the provider system"
        },
        {
          "code" : "contraindication",
          "display" : "Contraindication",
          "definition" : "Notice that the proposed intervention may be contraindicated based on information the payer has in their record that the provider does not have in theirs"
        },
        {
          "code" : "guideline",
          "display" : "Guideline",
          "definition" : "Indication that there is a guideline available for the proposed therapy (with an option to view)"
        },
        {
          "code" : "off-guideline",
          "display" : "Off Guideline",
          "definition" : "Notice that the proposed therapy may be contrary to best-practice guidelines, typically with an option to view the relevant guideline"
        }
      ]
    },
    {
      "code" : "_reqcat",
      "display" : "Requirements Categories",
      "definition" : "Codes that help to categorize requirements statements",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "business",
          "display" : "business",
          "definition" : "Requirements relating to the business operations of the entities responsible for a system"
        },
        {
          "code" : "exchange",
          "display" : "exchange",
          "definition" : "Requirements relating to when or how data is exchanged with other systems"
        },
        {
          "code" : "processing",
          "display" : "processing",
          "definition" : "Requirements related to how data is dealt with internally to a system"
        },
        {
          "code" : "storage",
          "display" : "storage",
          "definition" : "Requirements relating to when or how data is or is not persisted within a system"
        },
        {
          "code" : "ui",
          "display" : "ui",
          "definition" : "Requirements relating to the appearance of information on a user interface"
        }
      ]
    }
  ]
}

```
