# CRD Metric Codes - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CodeSystem: CRD Metric Codes 

 
Codes used within 'code' elements in the CRD Metric logical model. 

This Code system is referenced in the definition of the following value sets:

* [CDSHookType](ValueSet-cdsHookType.md)
* [MetricDataSource](ValueSet-metricDataSource.md)
* [MetricTokenUse](ValueSet-metricTokenUse.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "crd-metric-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/crd-metric-codes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.16.3"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDMetricCodes",
  "title" : "CRD Metric Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Codes used within 'code' elements in the CRD Metric logical model.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 12,
  "property" : [
    {
      "code" : "abstract",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "used",
      "display" : "Authorization Token Used",
      "definition" : "An authorization token was used by the payer to access additional information from the provider system as part of the CDS Hooks call",
      "concept" : [
        {
          "code" : "rejected",
          "display" : "Authorization Token Rejected",
          "definition" : "The payer attempted to use an authorization token to access additional information from the provider system as part of the CDS Hooks call, however the access request failed.  (This is not used if the request succeeded but returned no records.)"
        }
      ]
    },
    {
      "code" : "not-used",
      "display" : "Authorization Token Not Used",
      "definition" : "The payer did not attempt to use an authorization token to access additional information from the provider system as part of the CDS Hooks call"
    },
    {
      "code" : "provider-src",
      "display" : "Provider-sourced",
      "definition" : "The metric information was captured from the provider system's perspective"
    },
    {
      "code" : "payer-src",
      "display" : "Payer-sourced",
      "definition" : "The metric information was captured from the payer system's perspective"
    },
    {
      "code" : "_HookType",
      "display" : "CDS Hooks Type (abstract)",
      "definition" : "A collector for the different types of CDS Hooks",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "appointment-book",
          "display" : "Appointment Book",
          "definition" : "CDS Hooks Appointment Book Hook"
        },
        {
          "code" : "encounter-start",
          "display" : "Encounter Start",
          "definition" : "CDS Hooks Encounter Start Hook"
        },
        {
          "code" : "encounter-discharge",
          "display" : "Encounter Discharge",
          "definition" : "CDS Hooks Encounter Discharge Hook"
        },
        {
          "code" : "order-dispatch",
          "display" : "Order Dispatch",
          "definition" : "CDS Hooks Order Dispatch Hook"
        },
        {
          "code" : "order-select",
          "display" : "Order Select",
          "definition" : "CDS Hooks Order Select Hook"
        },
        {
          "code" : "order-sign",
          "display" : "Order Sign",
          "definition" : "CDS Hooks Order Sign Hook"
        }
      ]
    }
  ]
}

```
