# Coverage Information Codes - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CodeSystem: Coverage Information Codes 

 
Codes used by 'code' elements within the Coverage-Information extension. 

This Code system is referenced in the definition of the following value sets:

* [CRDAdditionalDoc](ValueSet-AdditionalDocumentation.md)
* [CRDDocReason](ValueSet-DocReason.md)
* [CRDCoverageDetailCategories](ValueSet-coverageDetailCategories.md)
* [CRDCoveredInfo](ValueSet-coverageInfo.md)
* [CRDCoveragePaDetail](ValueSet-coveragePaDetail.md)
* [CRDInformationNeeded](ValueSet-informationNeeded.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coverage-information-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/coverage-information-codes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.16.2"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CoverageInformationCodes",
  "title" : "Coverage Information Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Codes used by 'code' elements within the Coverage-Information extension.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 23,
  "property" : [
    {
      "code" : "abstract",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "conditional",
      "display" : "Conditional",
      "definition" : "There is the potential for information requirements from a participant type not listed.  However, a decision on whether there in fact are additional information requirements cannot be made without more information (more detailed code, service rendering information, etc.)"
    },
    {
      "code" : "covered",
      "display" : "Covered",
      "definition" : "Regular coverage applies.  Coverage is still subject to normal plan limits, deductibles, and other considerations meaning there is no guarantee of payment.  This response does NOT replace any need for a pre-determination, if required."
    },
    {
      "code" : "not-covered",
      "display" : "Not covered",
      "definition" : "No coverage or possibility of coverage for this service"
    },
    {
      "code" : "no-auth",
      "display" : "No Prior Authorization",
      "definition" : "The ordered service does not require prior authorization"
    },
    {
      "code" : "auth-needed",
      "display" : "Prior Authorization Needed",
      "definition" : "The ordered service will require prior authorization",
      "concept" : [
        {
          "code" : "performpa",
          "display" : "Performer Prior Authorization",
          "definition" : "Prior authorization is needed for the service, however such prior authoriation must be initiated by the performing (rather than ordering) provider."
        }
      ]
    },
    {
      "code" : "satisfied",
      "display" : "Authorization Satisfied",
      "definition" : "While prior authorization would typically be needed, the conditions evaluated by prior authorization have already been evaluated and therefore prior authorization can be bypassed"
    },
    {
      "code" : "clinical",
      "display" : "Clinical Documentation",
      "definition" : "Details most likely to originate from a clinician are required to satisfy additional documentation requirements, determine coverage and/or prior auth applicability - e.g. via DTR by clinician.  Indicates that the CRD client should expose the need to launch DTR to clinical users."
    },
    {
      "code" : "admin",
      "display" : "Administrative Documentation",
      "definition" : "Administrative details not likely to require clinical expertise are needed to satisfy additional documentation requirements, determine coverage and/or prior auth applicability - e.g. via DTR by back-end staff.  Indicates that while the CRD client might expose the ability to launch DTR as an option for clinical users, it should be clear that clinical input is not necessary and deferring the use of DTR to back-end staff is perfectly appropriate.  Some CRD clients might be configured (based on provider preference) to not even show clinicians the option to launch."
    },
    {
      "code" : "patient",
      "display" : "Administrative & clinical doc",
      "definition" : "Details most likely to originate from the patient or their personal representative (e.g. parent, spouse, etc.) are required to satisfy additional documentation requirements, determine coverage and/or prior auth applicability.  For example, information about household composition, accessibility considerations, etc.  This should be used when the data needs to come from the patient themselves, rather than a clinician's assessment of the patient"
    },
    {
      "code" : "_docReason",
      "display" : "Additional Information Purposes",
      "definition" : "A collector for codes representing different reasons for capturing additional information",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "withpa",
          "display" : "Include in prior authorization",
          "definition" : "The information in this QuestionnaireResponse should be packaged into a Bundle and submitted as part of (or in association with) a prior authorization for the associated request resource(s)."
        },
        {
          "code" : "withclaim",
          "display" : "Include with claim",
          "definition" : "The information in this QuestionnaireResponse should be packaged into a Bundle and submitted as part of (or in association with) the insurance claim for the services ordered by the associated request resource(s)."
        },
        {
          "code" : "withorder",
          "display" : "Include with order",
          "definition" : "The information in this QuestionnaireResponse should be packaged into a Bundle and submitted along with (or referenced as supporting information to) the associated request resource(s) when transmitting the order to the fulfilling system."
        },
        {
          "code" : "retain-doc",
          "display" : "Medical necessity",
          "definition" : "The information in this QuestionnaireResponse should be retained within the EHR as supporting evidence of the medical necessity of the associated request resource(s)."
        }
      ]
    },
    {
      "code" : "performer",
      "display" : "Performer Needed",
      "definition" : "Information about who (specifically, or at least performer type and affiliation) is necessary to make a determination of coverage and/or prior auth expectations"
    },
    {
      "code" : "location",
      "display" : "Location Needed",
      "definition" : "Information about where (specific clinic/site or organization) is necessary to make a determination of coverage and/or prior auth expectations"
    },
    {
      "code" : "timeframe",
      "display" : "Timeframe Needed",
      "definition" : "Information about when the service will be performed that is more granular than the order effective period is necessary to make a determination of coverage and/or prior auth expectations"
    },
    {
      "code" : "contract-window",
      "display" : "New Contract Window",
      "definition" : "The target performance time for the event falls outside the contract window for the patient's current coverage.  Information will not be available until a contract is in place covering the service time period"
    },
    {
      "code" : "detail-code",
      "display" : "Detail code",
      "definition" : "The ordered code is at too high a level of granularity to make decisions about coverage/pa/etc.  Can only be present if something is 'conditional'"
    },
    {
      "code" : "cat-limitation",
      "display" : "Coverage Limitation",
      "definition" : "The statement being made about coverage or authorization that are being constrained in scope in some way.  I.e. It is not safe to interpret the statements of 'this is covered' or 'this does not require prior auth' without looking at this detail."
    },
    {
      "code" : "cat-decisional",
      "display" : "Decision Considerations",
      "definition" : "The statement does not qualify the coverage statement, however it does provide information that may be relevant to the patient & caregiver decision of whether a therapy is appropriate/reasonable."
    },
    {
      "code" : "cat-other",
      "display" : "Other Details",
      "definition" : "The statement does not limit the coverage statement being made and is unlikely to influence a decision to proceed with care.  For example, instructions on how to submit a claim, reference to to policy, etc."
    }
  ]
}

```
