# CRD Server USCDI 1, 3, 4 - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CapabilityStatement: CRD Server USCDI 1, 3, 4 

 
This statement defines the expected capabilities of systems wishing to conform to the ''CRD Server'' role. This role is responsible for responding to CDS Hooks calls and responding with appropriate decision support. Much of its interactions will be with payer back-end systems over non-FHIR protocols. This CapabilityStatement does not describe these 'server <-> payer' interactions. Instead, it focuses on the ability of the CRD server to interact with the CRD client's FHIR endpoint to retrieve additional data. All such interactions are optional, as their necessity is dependent on what types of information is needed to support payer rules, the types of coverage the payer offers, and the degree of sophistication of the decision support offered by the CRD server. All resources and search parameters supported by US Core are fair game, though the [3.1.1](CapabilityStatement-crd-client3.1.md), [6.1.0](CapabilityStatement-crd-client6.1.md), and [7.0.0](CapabilityStatement-crd-client7.0.md) clients might vary in which resources, search parameters, and search parameter combinations they support. CRD servers will need to access the CapabilityStatement of the server they are communicating with to determine what search and read capabilities are available. 

This capability statement imports requirements from US Core 7.0 as the most all-encompassing of the versions. However, all resources treat support for all resources as optional. I.e. CRD servers are not obligated to be able to search or read any particular resource. Expectations for support for Note that irrespective of support via the RESTful API, CRD servers will need to handle resources for prefetch must still be met.

 [Raw OpenAPI-Swagger Definition file](../crd-server.openapi.json) | [Download](../crd-server.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "crd-server",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/CapabilityStatement/crd-server",
  "version" : "2.2.0-snapshot",
  "name" : "CRDServer",
  "title" : "CRD Server USCDI 1, 3, 4",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-11-25",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This statement defines the expected capabilities of systems wishing to conform to the ''CRD Server'' role.  This role is responsible for responding to CDS Hooks calls and responding with appropriate decision support.  Much of its interactions will be with payer back-end systems over non-FHIR protocols.  This CapabilityStatement does not describe these 'server <-> payer' interactions.  Instead, it focuses on the ability of the CRD server to interact with the CRD client's FHIR endpoint to retrieve additional data.  All such interactions are optional, as their necessity is dependent on what types of information is needed to support payer rules, the types of coverage the payer offers, and the degree of sophistication of the decision support offered by the CRD server.  All resources and search parameters supported by US Core are fair game, though the [3.1.1](CapabilityStatement-crd-client3.1.html), [6.1.0](CapabilityStatement-crd-client6.1.html), and [7.0.0](CapabilityStatement-crd-client7.0.html) clients might vary in which resources, search parameters, and search parameter combinations they support.  CRD servers will need to access the CapabilityStatement of the server they are communicating with to determine what search and read capabilities are available.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "A CRD server acts as a client, soliciting patient information from the FHIR endpoint of the CRD client, retrieving additional information needed to provide decision support.",
      "security" : {
        "description" : "Implementations **SHALL** meet the general security requirements documented in the [HRex implementation guide](http://hl7.org/fhir/us/davinci-hrex/STU1.2.0-snapshot/security.html)."
      }
    }
  ]
}

```
