<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CRDHooksResponseBase
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:CDSHooksResponse</sch:title>
    <sch:rule context="f:CDSHooksResponse">
      <sch:assert test="count(f:systemActions) &gt;= 1">systemActions: minimum cardinality of 'systemActions' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:CDSHooksResponse/f:systemActions</sch:title>
    <sch:rule context="f:CDSHooksResponse/f:systemActions">
      <sch:assert test="count(f:resourceId) &lt;= 0">resourceId: maximum cardinality of 'resourceId' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
