# hl7.fhir.us.davinci-crd#2.2.0-snapshot: Da Vinci - Coverage Requirements Discovery(en)

## Pages

* [CRD IG Home Page](index.md)
* [](Requirements-fromNarrative.change.history.md)
* [CRD Client](ActorDefinition-crd-client-testing.md)
* [CRD Server Organization - XML Representation](ActorDefinition-crd-server-org.xml.md)
* [Privacy, Safety, and Security](security.md)
* [CRD Client](ActorDefinition-crd-client.ai.md)
* [Conformance Details](conformancedetails.md)
* [CRD Server](ActorDefinition-crd-server.md)
* [CRD Server](ActorDefinition-crd-server-testing.md)
* [Narrative Conformance Statements - JSON Representation](Requirements-fromNarrative.json.md)
* [CRD Client Organization](ActorDefinition-crd-client-org.ai.md)
* [CRD Client Organization](ActorDefinition-crd-client-org.md)
* [CRD Server - JSON Representation](ActorDefinition-crd-server.json.md)
* [Use Cases](usecases.md)
* [CRD Server - XML Representation](ActorDefinition-crd-server.xml.md)
* [Operational Considerations](operational.md)
* [CRD Client](ActorDefinition-crd-client.md)
* [](ActorDefinition-crd-server.change.history.md)
* [ePA Coordinators](epa.md)
* [FHIR Artifacts](allartifacts.md)
* [Downloads](downloads.md)
* [Reading this IG](background.md)
* [CRD Metrics](metrics.md)
* [Change History](history.md)
* [CRD Server](ActorDefinition-crd-server.ai.md)
* [CRD Client Organization - JSON Representation](ActorDefinition-crd-client-org.json.md)
* [Narrative Conformance Statements - TTL Representation](Requirements-fromNarrative.ttl.md)
* [CDS Hooks Deviations and Enhancements](deviations.md)
* [Narrative Conformance Statements](Requirements-fromNarrative.md)
* [CRD Server Organization](ActorDefinition-crd-server-org-testing.md)
* [CRD Client - TTL Representation](ActorDefinition-crd-client.ttl.md)
* [CRD Server Organization](ActorDefinition-crd-server-org.ai.md)
* [Supported Hooks](hooks.md)
* [CRD Client Organization - XML Representation](ActorDefinition-crd-client-org.xml.md)
* [CRD Server Organization](ActorDefinition-crd-server-org.md)
* [CRD Server Organization - JSON Representation](ActorDefinition-crd-server-org.json.md)
* [Narrative Conformance Statements - XML Representation](Requirements-fromNarrative.xml.md)
* [](ActorDefinition-crd-client-org.change.history.md)
* [Narrative Conformance Statements](Requirements-fromNarrative.ai.md)
* [CRD Client Organization](ActorDefinition-crd-client-org-testing.md)
* [CRD Server - TTL Representation](ActorDefinition-crd-server.ttl.md)
* [](ActorDefinition-crd-server-org.change.history.md)
* [Conformance Expectations](conformance.md)
* [Foundational Requirements](foundation.md)
* [CRD Client - JSON Representation](ActorDefinition-crd-client.json.md)
* [CRD Client - XML Representation](ActorDefinition-crd-client.xml.md)
* [Artifact List](artifacts.md)
* [Implementation Considerations](implementation.md)
* [Project and Participants](credits.md)
* [](ActorDefinition-crd-client.change.history.md)
* [Narrative Conformance Statements](Requirements-fromNarrative-testing.md)
* [CDS Hooks Response Profiles](cards.md)
* [CRD Server Organization - TTL Representation](ActorDefinition-crd-server-org.ttl.md)
* [CRD Client Organization - TTL Representation](ActorDefinition-crd-client-org.ttl.md)
* [Burden Reduction](burden.md)

## Resources

### CodeSystems

* [Coverage Information Codes](CodeSystem-coverage-information-codes.md)
* [CRD Metric Codes](CodeSystem-crd-metric-codes.md)
* [CRD Temporary Codes](CodeSystem-temp.md)

### ValueSets

* [CRD Coverage Information Additional Documentation Value Set](ValueSet-AdditionalDocumentation.md)
* [CRD Coverage Information Documentation Reason Value Set](ValueSet-DocReason.md)
* [ICD10CM Disease codes](ValueSet-ICD10CM.md)
* [NUBC Type of Bill](ValueSet-NUBCTypeOfBill.md)
* [NUCC Healthcare Provider Taxonomy Individual or Groups](ValueSet-NUCCCareProviderTaxonomyIndividualOrGroups.md)
* [NUCC Healthcare Provider Taxonomy Non-Individual](ValueSet-NUCCCareProviderTaxonomyNonIndividual.md)
* [X12 Service Type](ValueSet-X12ServiceType.md)
* [CRD Billing Codes Value Set](ValueSet-billingCodes.md)
* [CDS Hooks Card Suggestion Action Types Value Set](ValueSet-cardActions.md)
* [CRD Response Types Value Set](ValueSet-cardType.md)
* [CDS Hook Types Value Set](ValueSet-cdsHookType.md)
* [CMS Location Codes Value Set](ValueSet-cmslocationcodes.md)
* [CRD Configuration Code Data Types Value Set](ValueSet-configTypes.md)
* [CRD Coverage Assertion Reasons Value Set](ValueSet-coverageAssertionReasons.md)
* [CRD Coverage Classes Value Set](ValueSet-coverageClass.md)
* [Deprecated CRD Coverage Detail Codes Value Set](ValueSet-coverageDetail.md)
* [CRD Coverage Detail Categories Value Set](ValueSet-coverageDetailCategories.md)
* [Official CRD Coverage Detail Codes Value Set](ValueSet-coverageDetailNew.md)
* [CRD Coverage Information Covered Value Set](ValueSet-coverageInfo.md)
* [CRD Coverage Information Prior Authorization Value Set](ValueSet-coveragePaDetail.md)
* [CRD Conformance Statement Categories](ValueSet-cs-categories.md)
* [CRD Device Request Codes Value Set](ValueSet-deviceRequest.md)
* [Diet Codes](ValueSet-diet-type.md)
* [Types of Edible Substances](ValueSet-edible-substance-type.md)
* [CRD Information Needed Value Set](ValueSet-informationNeeded.md)
* [CRD Location Address Types Value Set](ValueSet-locationAddressType.md)
* [CRD Metric Data Source Value Set](ValueSet-metricDataSource.md)
* [CRD Metric Token Use Value Set](ValueSet-metricTokenUse.md)
* [Nutrient Codes](ValueSet-nutrient-code.md)
* [CRD Order Detail Codes Value Set](ValueSet-orderDetail.md)
* [CRD Service Request Codes Value Set](ValueSet-serviceRequestCodes.md)

### Logicals

* [CDS Hooks Service Request Configuration Extension](StructureDefinition-CDSHookServiceRequestExtensionRequestConfig.md)
* [CDS Hooks Services Configuration Extension](StructureDefinition-CDSHookServicesExtensionConfiguration.md)
* [CRD Metric Data](StructureDefinition-CRDMetricData.md)

### Complex-type Profiles

* [CDS Hooks Service Response Associated Resource Extension](StructureDefinition-CDSHookServiceResponseExtensionAssociatedResource.md)
* [CRD Timing Data Type](StructureDefinition-profile-timing.md)

### Logical Profiles

* [CRD CDS Hooks Specific Context for appointment-book (Logical Definition)](StructureDefinition-CRDAppointmentBookContext.md)
* [CRD CDSHooks Request (Logical Definition)](StructureDefinition-CRDHooksRequest.md)
* [CRD CDSHooks Additional Orders Response (Logical Definition)](StructureDefinition-CRDHooksResponse-additionalOrders.md)
* [CRD CDSHooks Adjust Coverage Response (Logical Definition)](StructureDefinition-CRDHooksResponse-adjustCoverage.md)
* [CRD CDSHooks Alternate Request Response (Logical Definition)](StructureDefinition-CRDHooksResponse-alternateRequest.md)
* [CRD CDSHooks Coverage Information Response (Logical Definition)](StructureDefinition-CRDHooksResponse-coverageInformation.md)
* [CRD CDSHooks External Reference Response (Logical Definition)](StructureDefinition-CRDHooksResponse-externalReference.md)
* [CRD CDSHooks Form Completion Response (Logical Definition)](StructureDefinition-CRDHooksResponse-formCompletion.md)
* [CRD CDSHooks Instructions Response (Logical Definition)](StructureDefinition-CRDHooksResponse-instructions.md)
* [CRD CDSHooks SMART App Response (Logical Definition)](StructureDefinition-CRDHooksResponse-launchSMART.md)
* [CRD CDSHooks Response (Logical Definition)](StructureDefinition-CRDHooksResponse.md)
* [CRD CDSHooks Base for Response (Logical Definition)](StructureDefinition-CRDHooksResponseBase.md)
* [CRD CDS Hooks Specific Context for order-dispatch (Logical Definition)](StructureDefinition-CRDOrderDispatchContext.md)
* [CRD CDS Hooks Specific Context for order-select (Logical Definition)](StructureDefinition-CRDOrderSelectContext.md)
* [CRD CDS Hooks Specific Context for order-sign (Logical Definition)](StructureDefinition-CRDOrderSignContext.md)

### Primitive-type Profiles

* [CDS Hooks Service Request Requested CRD Version Extension](StructureDefinition-CDSHookServiceRequestExtensionRequestCRDVersion.md)
* [CDS Hooks Service Response If-None-Exist Extension](StructureDefinition-CDSHookServiceResponseExtensionIfNoneExist.md)
* [CDS Hooks Services Discovery CRD Version Extension](StructureDefinition-CDSHookServicesExtensionCRDVersion.md)

### Resource Profiles

* [CRD Base Appointment](StructureDefinition-profile-appointment-base.md)
* [CRD Appointment without Order](StructureDefinition-profile-appointment-no-order.md)
* [CRD Appointment with Order](StructureDefinition-profile-appointment-with-order.md)
* [CRD Bundle of Appointments](StructureDefinition-profile-bundle-appointment.md)
* [CRD Base Bundle](StructureDefinition-profile-bundle-base.md)
* [CRD Bundle of Request Resources](StructureDefinition-profile-bundle-request.md)
* [CRD Bundle of Dispatch Tasks](StructureDefinition-profile-bundle-task.md)
* [CRD Communication Request](StructureDefinition-profile-communicationrequest.md)
* [CRD Coverage](StructureDefinition-profile-coverage.md)
* [CRD Device](StructureDefinition-profile-device.md)
* [CRD Device Request](StructureDefinition-profile-devicerequest.md)
* [CRD Encounter](StructureDefinition-profile-encounter.md)
* [CRD Location](StructureDefinition-profile-location.md)
* [CRD Medication](StructureDefinition-profile-medication.md)
* [CRD Medication Request](StructureDefinition-profile-medicationrequest.md)
* [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md)
* [CRD Organization](StructureDefinition-profile-organization.md)
* [CRD Patient](StructureDefinition-profile-patient.md)
* [CRD Practitioner](StructureDefinition-profile-practitioner.md)
* [CRD Service Request](StructureDefinition-profile-servicerequest.md)
* [CRD Dispatch Task](StructureDefinition-profile-task-dispatch.md)
* [CRD Questionnaire Task](StructureDefinition-profile-taskquestionnaire.md)
* [CRD Vision Prescription](StructureDefinition-profile-visionprescription.md)

### Extensions

* [Billing Options](StructureDefinition-ext-billing-options.md)
* [Coverage Information](StructureDefinition-ext-coverage-information.md)
* [Request Category](StructureDefinition-ext-request-category.md)

### Basics

* [crd-client-org](Basic-crd-client-org.md)
* [crd-client](Basic-crd-client.md)
* [crd-server-org](Basic-crd-server-org.md)
* [crd-server](Basic-crd-server.md)
* [fromNarrative](Basic-fromNarrative.md)

### Binaries

* [CRDServiceRequest](Binary-CRDServiceRequest.md)
* [CRDServiceRequest2](Binary-CRDServiceRequest2.md)
* [CRDServiceRequest3](Binary-CRDServiceRequest3.md)
* [CRDServiceRequest4](Binary-CRDServiceRequest4.md)
* [CRDServiceResponse](Binary-CRDServiceResponse.md)
* [CRDServiceResponse2](Binary-CRDServiceResponse2.md)
* [CRDServiceResponse3](Binary-CRDServiceResponse3.md)
* [CRDServices](Binary-CRDServices.md)

### CapabilityStatements

* [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md)
* [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md)
* [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)
* [CRD Server USCDI 1, 3, 4](CapabilityStatement-crd-server.md)

### ImplementationGuides

* [Da Vinci - Coverage Requirements Discovery](ImplementationGuide-hl7.fhir.us.davinci-crd.md)

### Examples

* [example1 (Appointment)](Appointment-example1.md)
* [example2 (Appointment)](Appointment-example2.md)
* [example (CommunicationRequest)](CommunicationRequest-example.md)
* [example (Coverage)](Coverage-example.md)
* [example (Device)](Device-example.md)
* [example (DeviceRequest)](DeviceRequest-example.md)
* [example (Encounter)](Encounter-example.md)
* [South Wing, second floor (Location)](Location-example.md)
* [annotated-example (MedicationRequest)](MedicationRequest-annotated-example.md)
* [example (MedicationRequest)](MedicationRequest-example.md)
* [example (NutritionOrder)](NutritionOrder-example.md)
* [University Medical Center (Organization)](Organization-example.md)
* [example (Patient)](Patient-example.md)
* [full (Practitioner)](Practitioner-full.md)
* [example (ServiceRequest)](ServiceRequest-example.md)
* [questionnaire-example (Task)](Task-questionnaire-example.md)
* [task-dispatch-example (Task)](Task-task-dispatch-example.md)
* [visionprescription-example (VisionPrescription)](VisionPrescription-visionprescription-example.md)
