# Supported Hooks - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Supported Hooks

Each CDS Hook corresponds to a point in the workflow/business process within a CRD Client system where a specific type of decision support is relevant. For example, the `order-select` hook ought to be fired whenever a user of a CRD Client creates a new order or referral. In many CRD Clients, the same hook might fire in multiple different workflows. (For example, a CRD client might have different screens for ordering regular medications vs. vaccinations vs. chemotherapy, not to mention distinct screens for lab orders, imaging orders and referrals. An order-select hook might be initiated from any or all of these screens/workflows.)

Within this implementation guide, CDS Hooks are used by CRD Clients to perform coverage requirements discovery from CRD Servers used by patients' payers. Six hooks are identified that cover the main situations where coverage requirements discovery is likely to be needed: [appointment-book](#appointment-book), [encounter-start](#encounter-start), [encounter-discharge](#encounter-discharge), [order-dispatch](#order-dispatch), [order-select](#order-select), and [order-sign](#order-sign). Payers and respective CRD Servers will vary between patients. §hook-1^crd-client^processing:CRD Clients conforming to this implementation guide **SHALL** be able to determine the correct payer CRD server to use for each request.§

  Not all CRD Clients will support all hook types or order resource types. For example, community CRD client systems will not likely support `encounter-discharge`. Community pharmacy systems would not likely support `appointment-book`. Some EHRs might not support VisionPrescription when using order-sign. §hook-2^crd-client^exchange:CRD Clients conforming to this implementation guide **SHALL** support at least one of the hooks and (for order-centric hooks), at least one of the order resource types listed below, and **SHOULD** support all that apply to the context of their system.§ Future releases of this specification may increase expectations to support additional hooks. §hook-3?^crd-client^exchange:For systems that support ordering products or services covered by one of the CRD-supported request types, such clients **SHALL** support the order-sign hook for the order types they support.§

Similarly, not all payers will necessarily provide coverage that is relevant to all hook types or order resource types. For example, a payer that only provides drug coverage would be unlikely to have coverage information to return for an `encounter-discharge` event or a VisionPrescription order. §hook-4?^crd-server^exchange:CRD Servers conforming to this implementation guide **SHALL** provide a service for all hooks and order resource types required of CRD clients by this implementation guide unless the server has determined that the hook will not be reasonably useful in determining coverage or documentation expectations for the types of coverage provided.§

§hook-5^crd-client,crd-server^exchange:CRD Clients and CRD Servers **MAY** choose to support additional hooks available in the registry on the [CDS Hooks continuous integration build](https://build.fhir.org/ig/HL7/cds-hooks-library) or custom hooks defined elsewhere.§ §hook-6?^crd-client,crd-server^exchange:When supporting hooks not covered by this guide, systems **SHOULD** adhere to the general conformance expectations defined in this specification for those additional hooks.§

 §hook-7^crd-client^ui:CRD clients **SHALL** allow hook invocation to occur transparently as part of user workflow.§ §hook-8?^crd-client^ui:CRD clients **SHALL NOT** require transcription of order, appointment, or other data into a separate interface distinct from regular provider workflow unless performing "what if" situations.§

In the absence of guidance from the CDS Hooks specification, CRD Servers are expected to conform to the following rules when responding to requests from a CRD Client:

* §hook-9?^crd-server^exchange:If the CRD Server encounters an error when processing the request, the system **SHALL** return an appropriate error HTTP Response Code, starting with the digit "4" or "5", indicating that there was an error.§
*  §hook-10?^crd-server^exchange:If an issue is identified at a layer of the CRD Server that is FHIR aware (e.g. not a "wrong endpoint" or "not authorized" issue), the server **SHALL** provide an OperationOutcome for internal issue tracking by the client system.§
* §hook-11^crd-client^ui:The CRD Client **MAY** display to the user that the Coverage Requirements Discovery Service is unavailable.§ §hook-12?^crd-client^ui:If additional information (e.g. number to call) is available, it **MAY** also be included in the message to the user.§

§§hook-13^crd-server^exchange:CRD Servers **SHALL** use the 400 and 422 codes in a manner consistent with the FHIR RESTful [Create Action](http://hl7.org/fhir/R4/http.html#create)^

* While any 4xx or 5xx response code could be raised, the CRD Server **SHALL** use the 400 and 422 codes in a manner consistent with the FHIR RESTful Create Action, specifically: 
* 400 - Bad Request - The request is not parsable as JSON or the content fails validation against FHIR core or CDS Hooks specification rules. Also used if a CRD server receives a call where the primary Coverage (either provided by prefetch or queried by the payer) does not have a payer.identifier that identifies a payer that is handled by that CRD server endpoint, the server SHALL return a 400 error and SHOULD provide an OperationOutcome. This includes situations where no Coverage is accessible, multiple Coverages are accessible, or the provided Coverage does not have a payer.identifier at all.
* 422 - Unprocessable Entity - The request is valid JSON and meets FHIR and CDS Hook validation rules, but fails to adhere to constraints imposed by this specification.
 

§§

* §hook-14?^crd-server^processing:If a CRD server's validation process does not differentiate between validation issues stemming from the JSON syntax validation, FHIR core validation, CDS Hooks validation, and CRD-specific validation, it **MAY** treat all validation rules as 400 errors.§
*  §hook-15?^crd-client^processing:A CRD client **MAY** opt to re-invoke a CRD hook either due to manual user intervention or automatically in the background if there is a reason to believe that a substantive change in the patient's record and/or coverage might produce a different CRD response.§ If such workflows are invoked without first calling an X12 271, there should be business processes in place to ensure that CRD is invoked with the correct/current patient coverage.

A profile defining the general expectations of a CRD CDS Hooks request can be found [here](StructureDefinition-CRDHooksRequest.md).

### Hook Categories

The hooks supported by this guide can be categorized into two types: 'primary' hooks and 'supporting' hooks.

The 'primary' hooks are [Appointment Book](#appointment-book), [Orders Sign](#order-sign), and [Order Dispatch](#order-dispatch). §hook-16^crd-server^exchange:CRD Servers **SHALL**, at minimum, return a [Coverage Information](StructureDefinition-ext-coverage-information.md) system action for 'primary' hooks, even if the response indicates that further information is needed or that the level of detail provided is insufficient to determine coverage.§

The 'secondary' hooks are [Orders Select](#order-select), [Encounter Start](#encounter-start), and [Encounter Discharge](#encounter-discharge). §hook-17^crd-client^exchange:These hooks **MAY** return cards or system actions, but are not expected to, and CRD clients are free to ignore any cards or actions returned.§ (§hook-18?^crd-client^exchange:CRD clients **SHOULD** use the [configuration options](deviations.md#new-hook-configuration-mechanism) to instruct CRD servers to not even try to return responses if the client does not intend to display/process them.§) §hook-19?^crd-server^exchange:If Coverage Information is returned for these hooks, it **SHALL NOT** include messages indicating a need for [clinical](ValueSet-AdditionalDocumentation.md) or [administrative](ValueSet-AdditionalDocumentation.md) information, as such information is expected to be made available later in the process and therefore such guidance is not useful.§

The following sections describe the hooks covered by this implementation guide as well as setting conformance expectations related to those hooks.

§hook-20^crd-client^exchange:Where profiles are provided in a table for the hook sections below, CRD clients **SHALL** ensure that data included in the hook invocation complies with the listed profiles.§ §hook-21^crd-server^processing:CRD servers **SHALL NOT** depend on data not covered by the identified profiles in order to return valid coverage-information responses.§

The hooks listed on the CDS hooks website are subject to update by the community at any time until they go through the ballot process. However, all substantive changes are noted in the **Change Log** section at the bottom of the page describing each hook. For each hook listed below, this specification identifies a specific version. For the sake of interoperability, implementers are expected to adhere to the interface defined in the specified version of each hook, though compatible changes from future versions can also be supported. §hook-22^crd-server^processing:CRD Servers **SHALL** handle unrecognized context elements by ignoring them.§

Below is a summary diagram that outlines all the hooks, indicating when responses are mandatory or optional, and provides insights into what contributes to caching and attribution.

 Note: As a side effect, CRD calls can be used by a payer to 'attribute' a patient to an organization, which may allow the clinical organization to query patient clinical data via [Payer Data Exchange (PDex)] or other mechanisms to be considered as part of patient care delivery. The diagram below identifies two hooks as particularly appropriate to this use. Any hook can theoretically be used to assert a relationship from a member attribution perspective. The two hooks highlighted are the most appropriate ones as they could theoretically allow information to flow from the payer as part of the 'current' care delivery. Hooks later in the workflow would typically be too late to allow data to flow in a way that would allow that information to be taken into account in the current care event.

** Figure 2: Hooks Summary Diagram**

### appointment-book

This hook is described in the CDS Hooks specification [here](http://cds-hooks.hl7.org/hooks/STU1/appointment-book.html). This version of the CRD implementation guide refers to version 1.0 of the hook.

This hook would be triggered when the user of a CRD Client books a future appointment for a patient with themselves, with someone else within their organization, or with another organization. Note that whether the CRD Client will create an appointment (triggering the `appointment-book` hook) or a ServiceRequest (triggering an `order-select` or `order-sign` hook) can vary depending on the service being booked and the organizations involved.

Potentially relevant CRD advice related to this hook might include:

* Requirements related to the intended location and/or participants (e.g. warnings about out-of-network)
* Requirements related to the service being booked (e.g. Is prior authorization needed? Is the service covered? Is the indication appropriate? Is special documentation required?)
* Requirements related to the timing of the service (e.g. is the coverage still expected to be in effect? is the service too soon since the last service of that type?)
* Reminders about additional services that are recommended to be scheduled or booked for the same patient - either as part of the scheduled encounter or as part of additional appointments that could be created at the same time

While this hook supports userIds of Patient and RelatedPerson, for CRD purposes it is enough to support Practitioner and PractitionerRole. Support for Patient and RelatedPerson as users is optional. (Note that Practitioner and PractitionerRole include both licensed healthcare professionals as well as administrative staff.)

 The following table contains the essential profiles relevant to the invocation of the hook, including the resources passed in the the appointments context element, as well as those retrieved via mandatory prefetch. The conformance rules stated in [Hook Categories](#FHIR-53579-a) above apply to the use of these profiles.

| | |
| :--- | :--- |
| [profile-appointment-with-order](StructureDefinition-profile-appointment-with-order.md)or[profile-appointment-no-order](StructureDefinition-profile-appointment-no-order.md) |  |
| [profile-encounter](StructureDefinition-profile-encounter.md) |  |
| [profile-patient](StructureDefinition-profile-patient.md) |  |
|  | [US Core practitioner](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html) |
|  | [hrex-practitionerrole](https://build.fhir.org/ig/HL7/davinci-ehrx//StructureDefinition-hrex-practitionerrole.html) |

Notes:

* §hook-23^crd-server^processing:CRD Servers **MAY** use the appointment-book hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective.§
* §hook-24^crd-client,crd-server^exchange,processing:CRD clients and servers **SHALL**, at minimum, support returning and processing the [Coverage Information](StructureDefinition-ext-coverage-information.md) system action for all invocations of the appointment-book hook.§

### encounter-start

This hook is described in the CDS Hooks specification [here](http://cds-hooks.hl7.org/hooks/STU1/encounter-start.html). This version of the CRD implementation guide refers to version 1.0 of the hook.

This hook would be triggered when a patient is admitted, a patient arrives for an out-patient visit, and/or when a provider first engages with a patient during an encounter. The `encounter-start` hook serves a similar purpose to the [appointment-book](#appointment-book) hook, though it provides less lead time to react to recommendations. If the purpose of the appointment is to perform a service that requires a 2-week prior authorization process, it is more efficient to identify prior-authorization requirements proactively through the use of the appointment-book hook to prevent the patient from showing up for an appointment that will need to be canceled and rescheduled.

The advice returned for this hook would include the same sorts of advice as provided for using [appointment-book](#appointment-book). However, the hook is still necessary because not all encounters will be the result of appointments, not all systems that schedule appointments will necessarily have checked for coverage requirements, and the patient's circumstances and/or coverage as well as the payer's guidelines could have evolved since the appointment was scheduled.

Note that Practitioner and PractitionerRole include both licensed healthcare professionals, as well as administrative staff.

 The following table contains the essential profiles relevant to the invocation of the hook, including the resources passed in the the appointments context element, as well as those retrieved via mandatory prefetch. The conformance rules stated in [Hook Categories](#FHIR-53579-a) above apply to the use of these profiles.

| | |
| :--- | :--- |
| [profile-encounter](StructureDefinition-profile-encounter.md) |  |
| [profile-patient](StructureDefinition-profile-patient.md) |  |
|  | [US Core practitioner](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html) |
|  | [hrex-practitionerrole](https://build.fhir.org/ig/HL7/davinci-ehrx//StructureDefinition-hrex-practitionerrole.html) |

Notes:

* §hook-25^crd-server^processing:CRD Servers **MAY** use the appointment-book hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective.§

### encounter-discharge

This hook is described in the CDS Hooks specification [here](http://cds-hooks.hl7.org/hooks/STU1/encounter-discharge.html). This version of the CRD implementation guide refers to version 1.0 of the hook.

This hook would generally be specific to an in-patient encounter and would be fired when a provider is performing the discharge process within the CRD Client.

Potentially relevant CRD advice related to this hook might include:

* Verifying that documentation requirements for the services performed have been met to ensure the services provided can be reimbursed
* Ensuring that required follow-up planning is complete and appropriate transfer of care has been arranged, particularly for accountable care models

 The following table contains the essential profiles relevant to the invocation of the hook, including the resources passed in the the appointments context element, as well as those retrieved via mandatory prefetch. The conformance rules stated in [Hook Categories](#FHIR-53579-a) above apply to the use of these profiles.

| | |
| :--- | :--- |
| [profile-encounter](StructureDefinition-profile-encounter.md) |  |
| [profile-patient](StructureDefinition-profile-patient.md) |  |
|  | [US Core practitioner](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html) |
|  | [hrex-practitionerrole](https://build.fhir.org/ig/HL7/davinci-ehrx//StructureDefinition-hrex-practitionerrole.html) |

### order-dispatch

This hook is described in the CDS Hooks specification [here](http://cds-hooks.hl7.org/hooks/STU1/order-dispatch.html). This version of the CRD implementation guide refers to version 1.0 of the hook.

This is a new hook that allows for decision support to be provided when the intended performer of a service is not chosen when the order is written, but instead at some later time-point, quite frequently by someone other than the practitioner who wrote the order. Because knowing 'who' will perform the service is often relevant when determining coverage and prior authorization requirements, and because it is also a useful point for providing guidance such as suggesting alternative "in-network" providers, this is a useful point in client workflow to provide decision support.

This hook will fire at some point after (possibly well after) the [order-sign](#order-sign) hook fires. It only passes the patient id, order id, performer, and (optionally) the Task that describes the fulfillment request as part of the context. This specification does not require use of the Task resource.

This hook allows multiple resource types to be present. Resources provided could all be the same type or be a mixture of types. §hook-26^crd-server^processing:Coverage requirements **SHOULD** be limited only to those resources that are included in the `dispatchedOrders` context, though the content of other resources **SHOULD** also be considered before making recommendations about what additional actions are necessary.§ (I.e. do not recommend an action if there's already an order to perform that action.)

The different relevant resource types are as follows (support can vary between clients):

* **CommunicationRequest**: Used when a provider requests that another provider transfer patient records or other supporting information to another organization or agency.
* **DeviceRequest**: Used for durable medical equipment orders, such as wheelchairs, prosthetics, diabetic supplies, etc. It can also be used to order glasses and other vision-correction devices.
* **MedicationRequest**: Used to order inpatient and outpatient medications.* Can also be used to order vaccinations.
* **ServiceRequest**: Used to order a referral, lab tests, diagnostic imaging, and sometimes to schedule a future appointment (also see [appointment-book](#appointment-book)).
* **NutritionOrder**: Used to order the preparation of specific meal types. Generally used for in-patient care, but potentially also relevant for homecare.
*  **Vision Prescription**: Used to order eyeglasses, contacts, and similar vision-related prosthetics.

* - Note: in the medication space, regulations may mandate alternate standards for some of the functionality covered by CRD for certain classes of medications. E.g. NCPDP Script

CRD responses might include:

* Information about preauthorization and clinical documentation requirements, including forms to be completed
* Alternative performers (e.g. in-network providers)

 The following table contains the essential profiles relevant to the invocation of the hook, including the resources passed in the the appointments context element, as well as those retrieved via mandatory prefetch. The conformance rules stated in [Hook Categories](#FHIR-53579-a) above apply to the use of these profiles.

| | |
| :--- | :--- |
| [profile-devicerequest](StructureDefinition-profile-devicerequest.md) |  |
| [profile-encounter](StructureDefinition-profile-encounter.md) |  |
| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.md) |  |
| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.md) |  |
| [profile-patient](StructureDefinition-profile-patient.md) |  |
|  | [US Core practitioner](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html) |
|  | [hrex-practitionerrole†](https://build.fhir.org/ig/HL7/davinci-ehrx//StructureDefinition-hrex-practitionerrole.html) |
| [profile-servicerequest](StructureDefinition-profile-servicerequest.md) |  |
| [profile-task-dispatch](StructureDefinition-profile-task-dispatch.md) |  |
| [profile-visionprescription](StructureDefinition-profile-visionprescription.md) |  |

† While this hook does not explicitly list PractitionerRole as an expected resource type for userId, it is not prohibited and is included to allow linking the user to a Practitioner in a specific role acting on behalf of a specific Organization.

Notes:

* §hook-27^crd-server^processing:CRD Servers **MAY** use the order-dispatch hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective.§
* §hook-28^crd-client,crd-server^exchange,processing:CRD clients and servers **SHALL**, at minimum, support returning and processing the [Coverage Information](StructureDefinition-ext-coverage-information.md) system action for all invocations of the order-dispatch hook.§

### order-select

This hook is described in the CDS Hooks specification [here](http://cds-hooks.hl7.org/hooks/STU1order-select.html). This version of the CRD implementation guide refers to version 1.0 of the hook.

Support for this hook is optional, as not all information will necessarily be available when this hook is invoked. Therefore, the [Order Sign](#order-sign) and [Order Dispatch](#order-dispatch) hooks are more critical to implement because they fire when information is required to be more complete and also represent the 'end' of the user engagement in their respective processes. That said, the "Order Select" hook is still quite useful.

First, because it fires earlier in the user's system interactions, it provides an opportunity for CRD servers to initiate back-end queries that might take time to complete so that relevant information is already retrieved and cached before Order Sign is reached. This increases performance and makes it easier for CRD servers to respond in the required timeframe.

Second, when a CRD server can provide guidance to providers earlier in the process (e.g. upon selection of a service but before entering detailed instructions), it can help to make the provider's experience more efficient. (If a provider knows up-front that a service will not be paid for, but an alternative would be, they might be happier if they can save the time on entering full details before finding this out.) Not all providers or EHRs will necessarily want to receive 'proactive' decision support during the order entry process. EHRs can be configured as to what types of cards they are interested in receiving back for this hook, including no cards at all if the hook is invoked solely for performance or caching reasons.

This hook allows multiple resource types to be present. Resources provided could all be the same type or be a mixture of types. §hook-29^crd-server^processing:Coverage requirements **SHOULD** be limited only to those resources that are included in the `selections` context, though the content of other resources **SHOULD** also be considered before making recommendations about what additional actions are necessary.§ (I.e. do not recommend an action if there's already a draft order to perform that action.)

The different relevant resource types are as follows (support can vary between clients):

* **CommunicationRequest**: Used when a provider requests that another provider transfer patient records or other supporting information to another organization or agency.
* **DeviceRequest**: Used for durable medical equipment orders, such as wheelchairs, prosthetics, diabetic supplies, etc. It can also be used to order glasses and other vision-correction devices.
* **MedicationRequest**: Used to order inpatient and outpatient medications.* Can also be used to order vaccinations.
* **ServiceRequest**: Used to order a referral, lab tests, diagnostic imaging, and sometimes to schedule a future appointment (also see [appointment-book](#appointment-book)).
* **NutritionOrder**: Used to order the preparation of specific meal types. Generally used for in-patient care, but potentially also relevant for homecare.
*  **Vision Prescription**: Used to order eyeglasses, contacts, and similar vision-related prosthetics.

* - Note: in the medication space, regulations may mandate alternate standards for some of the functionality covered by CRD for certain classes of medications. E.g. NCPDP Script

CRD responses might include:

* Information about preauthorization and clinical documentation requirements, including forms to be completed
* Alternative therapies that are covered or required first-line therapies
* Potential drug-drug interactions based on existing payer knowledge
* Recommendations about in-network vs. out-of-network providers for referrals

 The following table contains the essential profiles relevant to the invocation of the hook, including the resources passed in the the appointments context element, as well as those retrieved via mandatory prefetch. The conformance rules stated in [Hook Categories](#FHIR-53579-a) above apply to the use of these profiles.

| | |
| :--- | :--- |
| [profile-devicerequest](StructureDefinition-profile-devicerequest.md) |  |
| [profile-encounter](StructureDefinition-profile-encounter.md) |  |
| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.md) |  |
| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.md) |  |
| [profile-patient](StructureDefinition-profile-patient.md) |  |
|  | [US Core practitioner](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html) |
|  | [hrex-practitionerrole†](https://build.fhir.org/ig/HL7/davinci-ehrx//StructureDefinition-hrex-practitionerrole.html) |
| [profile-servicerequest](StructureDefinition-profile-servicerequest.md) |  |
| [profile-visionprescription](StructureDefinition-profile-visionprescription.md) |  |

† While this hook does not explicitly list PractitionerRole as an expected resource type for userId, it is not prohibited and is included to allow linking the user to a Practitioner in a specific role acting on behalf of a specific Organization.

Notes:

* While this hook is defined for use when ordering, it is still relevant when proposing (e.g. as part of a consult note) or planning (e.g. as part of a care plan) the use of an intervention. All the 'Request' resources support differentiation between plans, proposals, and orders. §hook-30?^crd-client^processing:Where CRD Clients have an appropriate workflow and data capture mechanism, the order-select hook **MAY** be used in scenarios that do not involve creating a true order.§

### order-sign

This hook is described in the CDS Hooks specification [here](http://cds-hooks.hl7.org/hooks/STU1/order-sign.html). This version of the CRD implementation guide refers to version 1.1 of the hook which, at the time of publication, was not available as a snapshot. Therefore, the preceding link refers to the CDS hooks current build.

This hook serves a very similar purpose to [order-select](#order-select). The main difference is that all the listed draft orders are considered 'complete'. That means that it is appropriate to provide warnings if there is insufficient information to determine coverage requirements. Also, all `draftOrders` are appropriate to comment on when using order-sign as the `selections` field found in in order-select is not used in order-sign.

Use and profiles for [order-select](#order-select) also apply to `order-sign`.

Notes:

* §hook-31^crd-server^processing:CRD Servers **MAY** use the order-select hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective.§
* §hook-32^crd-client,crd-server^exchange,processing:CRD clients and servers **SHALL**, at minimum, support returning and processing the [Coverage Information](StructureDefinition-ext-coverage-information.md) system action for all invocations of the order-select hook.§

