# Project and Participants - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Project and Participants

### Da Vinci

[Da Vinci](https://www.hl7.org/about/davinci/index.cfm) is an HL7-sponsored project that brings together U.S. payers, providers, and technology suppliers to help payers and providers improve clinical, quality, cost, and care management outcomes using FHIR-related technologies. The project organizes meetings (face-to-face and conference calls) and connectathons to find ways to leverage FHIR technologies to support and integrate value-based care (VBC) data exchange across communities. Da Vinci identifies value-based care use cases of interest to its members and to the broader community.

The process that Da Vinci has adopted includes:

1. identifying business, clinical, technical, and testing requirements
1. developing and balloting a FHIR-based implementation guide (IG)
1. developing reference implementations (RIs) to demonstrate that the concepts in the IG are possible to implement
1. piloting the standard
1. supporting the production use of the IG to enable exchange of data to support interoperability for value-based care

All Da Vinci work adheres to a common set of [guiding principles](https://build.fhir.org/ig/HL7/davinci-ehrx//davinci-guiding-principles.html).

Additional information about Da Vinci, its members, the use cases, and the implementation guides being developed can all be found on the [HL7 website](http://www.hl7.org/about/davinci). Meeting minutes and other materials can be found on the [Da Vinci Confluence page](https://confluence.hl7.org/display/DVP).

### The Da Vinci CRD project

CRD is part of a set of projects in the [Burden Reduction](burden.md) space that was first initiated by Da Vinci members in May of 2019. Project participants have included major EHR vendors, payers, provider organizations, and others involved in the prior authorization space. The first standard for trial use version of the specification was published in 2020 and the specification has undergone considerable testing at various connectathons, pilots, and production implementations since then. Further details about the project, including minutes of meetings can be found on the [project Confluence page](https://confluence.hl7.org/pages/viewpage.action?pageId=21857602).

### Credits

Technical Lead and Primary Author:

* Lloyd McKenzie (Dogwood Health Consulting)

Additional Authors:

* Raman Dhanoa (Dogwood Health Consulting)
* Russell Buchanan (Gevity Consulting/Accenture)

Project leads:

* Robert Dieterle (Enable Care, LLC)
* Viet Nguyen (Stratametrics, LLC)

Project management and coordination:

* Crystal Kalem (Point of Care Partners)
* Vanessa Candelora (Point of Care Partners)
* Jocelyn Keegan (Point of Care Partners)

Technical support and guidance:

* Grahame Grieve (Health Intersections)

This implementation guide was initiated by the twenty-two founding [Da Vinci Project](http://hl7.org/about/davinci) member organizations.

Regular project participants included:

* 1upHealth (Joe McCaffrey)
* Aegis (Richard Ettema, Carie Hammond, Jamie Parker, Sandra Vance)
* Aetna CVS (Janice Hsieh, Kathy Berne, Kiba Polk, Muhammad Ali, Ron Health, Shilpi Jain, Sudhansu Mishra)
* American Hospital Association (Andrea Preisler, Terrence Cunningham)
* American Medical Association (Meryl Bloomrosen, Celine Lefebvre, Heather McComas)
* Allscripts (Emma Jones, Jeffrey Danford)
* Availity (Ian Vankirk)
* Blue Cross Blue Shield Association (Karuna Relwani)
* Blue Cross Blue Shield of Alabama (Tony Benson, Kevin Lambert, Chris Johnson, Gini McGlothin, Morry Payne, Clarissa Winchester)
* Blue Cross Blue Shield of Arkansaw (Brian Reed)
* Blue Cross Blue Shield Florida (Sudhakar Reddy)
* Blue Cross Blue Shield North Carolina (Bhanu Vemuri)
* Blue Cross Blue Shield Tennessee (Susan Langford)
* CAQH Core (Don Taylor)
* Centers for Medicare and Medicaid Services - CMS (Jessica Czulewicz)
* Cognizant (Alyson Broxton, James Bound)
* Cognosante (Mary Kay McDaniel)
* Dogwood Health Consulting (Jean Duteau)
* Drummond (Tim Bennett)
* Edifecs (Michelle Benz, Artim Sopin)
* eHealth Exchange (Keith Brick, Scott Rossignol, Tiffanie Hickman)
* Elevance Health (Chris Cioffi, Christol Green, Shawn Turk)
* Epic (Danielle Friend, Kyle Johnsen, Alexander Longo, Edward Micklos, Rachael McCormick, Xavier SevcikCooper Thompson, Spencer Utley, November Valentine, Mathew Varghese, Isaac Vetter)
* Evernorth (Stuart Kirchner, Tiffany Tann, Steve Whitney)
* Evicore (Anup Mahansaria)
* Health Care Data Standards (Mary Kay McDaniel)
* Health Chain (Nikita Ravindran)
* HealthLX (David Riddle)
* Independent Health (Christopher Gracon)
* Infor (Brian Lind, Rob Brull)
* InterSystems (James Derrickson)
* Kaiser Permanente (Walter Suarez)
* Lantana (Jeff Brown, Jeffrey Danford, Ruby Nash, SueAnn Svaby)
* MCG (Ganesh Mittapally)
* Meditech (Dan Murphy)
* Mettles Solutions (Sreekanth Puram)
* Microsoft (Joshua Mandel)
* Mitre (Kathleen Connor, Jeffrey Danford, Larry Decelles, Andrew Gregorowicz, Corey Spears)
* MultiCare (Karen Ashton)
* Optum (Aaron Cruver, Benet Devereux, David Hansen, Josh Lamb, Linda Michaelsen, Nick Radov, Richa Singh, Tara Frappy)
* Oracle Health (Hans Buitendijk, Kevin Shekleton, Michelle Miller)
* Peraton (Michael Cabral)
* Philips (Bas van den Heuvel)
* RFA Ltd (Rachel Foerster)
* Smile Digital Health (Jonell Sakyi, Marie Casimina, Thao Michaels)
* Surescripts (Brian Morris)
* Quest Diagnostics (Freida Hall)
* United Healthcare (Nicholas Radov)
* U.S. Dept. of Veterans Affairs (Freida Hall, Ken Lord, MaryKay McDaniel)
* University of Utah (Kensaku Kawamoto)
* Versaggi Consulting (Serafina Versaggi)
* Washington State Healthcare Authority (Brittany Rowlett)
* ZeOmega (Michael Gould)

Our thanks to these and to the many others not explicitly listed who contributed their time, enthusiasm and expertise to this work.

