# Conformance Details - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Conformance Details

This page contains a table listing all the free-text conformance statements found in the IG. This table is provided as a useful summary for implementers for the purpose of evaluating key features and to support testing. However, reading this table alone is insufficient to understand or successfully implement the specification:

1. The table only includes conformance expectations expressed as free text. It does not include the computable expectations represented in capability statements, profiles, value sets, etc.
1. The text text in the table only includes the 'formal' requirement. It does not provide the contextual language around the statement that will be needed for successful explanation. The 'id' of each statement is a hyperlink to the place it appears in the text to assist with gathering the needed context.

A few other notes:

* The ids are generally specific to the pages on which the requirements appear, but not always. If content is moved from one page to another, the id will remain the same.
* While ids start as contiguous, as the specification is updated, it is possible some conformance statements will be removed, which will create a gap in the numbers. This is not an error.
* Ids are not final until published in an official release. At that point, ids will not be changed.
* It is possible for the text of a given rules to change somewhat from one release to another so long as the intention of the rule is the same. If the intent has a significant change, the old rule will be removed and a new one added in its place.
* The actors are broken down into 'client' and 'server'. There may be multiple systems that actually compose those logical entities which will vary from implementation. It will be up to implementers to determine how the various conformance statements will apply to the actal systems in their architecture.
* The categorizations are general. In practice, all 'exchange', 'ui', and 'storage' requirements are some aspect of 'processing' requirements. The categories will give hints as to the architectural layer a requirement will apply to, but there is nothing definitive implied by the category(ies) listed.

The controls at the top of the table allow filtering the content to particular requirement subsets that may be of interest. As well, a computable representation (XML and JSON) of the requirements can be found [here](Requirements-fromNarrative.md).

§§§

