# CDS Hooks Response Profiles - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CDS Hooks Response Profiles

CDS Hooks defines two different mechanisms for services to respond to a hook call: cards and system actions. This page profiles (constrains) the general rules for these responses from the CDS Hooks specification to reflect how they must be used when complying with this CRD specification.

### General Card and SystemAction rules

In addition to the [guidance provided in the CDS Hooks specification](http://cds-hooks.hl7.org/2026Jan/index.html#card-attributes), the following additional guidance applies to CRD servers when constructing cards:

* §resp-1^crd-server^exchange:The `Card.indicator` **SHOULD** be populated from the perspective of the clinical decision maker, not the payer§. While failure to procure a prior authorization might be 'critical' from the perspective of payment, it would be - at best - a 'warning' from the perspective of clinical care. 'critical' must be reserved for reporting life or death or serious clinical outcomes. Issues where the proposed course of action will negatively affect the ability of the payer or patient to be reimbursed would generally be a 'warning'. §resp-2^crd-server^exchange:Most Coverage Requirements **SHOULD** be marked as 'info'.§
* §resp-3^crd-server^exchange:All `Card.suggestion` elements **SHALL** populate the Suggestion.uuid element.§
*  §resp-4^crd-server^exchange:The `Card.source.label` **SHALL** be populated with an insurer name that the user and patient are likely to recognize (i.e., the responsible insurer on the patient's insurance card), including in situations where coverage recommendations are being returned by a benefits manager or intermediary operating the CRD server on behalf of the payer.§ If an insurer provides recommendations from another authority (e.g., a clinical society), the society's name and logo might be displayed, though usually only with the permission of that organization.
* §resp-5^crd-server^exchange:`Card.source.topic` **SHALL** be populated, and has an [extensible](http://www.hl7.org/fhir/terminologies.html#extensible) binding to the ValueSet [CRD Response Types](ValueSet-cardType.md).§ The rationale is to allow CRD clients to filter or track the usage of different types of cards.
* Users are busy. Time spent reading a payer-returned card is time taken from reviewing other information or interacting with the patient. If not useful or relevant, users will quickly learn to ignore - or even demand the disabling of - payer-provided alerts. Therefore, information must be delivered efficiently and be tuned to provide maximum relevance. Specifically:
* §resp-11^crd-server^exchange:CRD client systems might not support all card capabilities, therefore card options **SHOULD** provide sufficient information for a user to perform record changes manually if automated support is not available.§
* §resp-12?^crd-server^exchange:Where [systemActions](http://cds-hooks.hl7.org/2026Jan/index.html#system-action) are used, CRD servers **SHOULD NOT** return equivalent information in a card for user display.§ It is the responsibility of the CRD client to determine how best to present the results of the newly created or revised records.

A profile defining the generic constraints that apply to all CRD responses can be found [here](StructureDefinition-CRDHooksResponseBase.md).

### Potential CRD Response Types

 The sections below describe the different types of [responses](http://cds-hooks.hl7.org/2026Jan/index.html#cds-service-response) that CRD servers can use when returning coverage requirements to CRD clients, including CRD-specific profiles on cards to describe CRD-expected behavior. It is possible that some CRD servers and CRD clients will support response types other than those listed here (i.e. other allowed sets of constraints on Card and/or SystemAction). Such behavior is outside the scope of this specification. Future versions of this specification might standardize additional response types. 

§resp-13^crd-client,crd-server^exchange:Conformant CRD clients and services **SHALL** support the [Coverage Information](#coverage-information-response-type) response type.§ (See specific support expectations documented there.) §resp-14^crd-client,crd-server^exchange:Conformant CRD clients and services **SHOULD** support the additional (non-coverage information) types defined by this guide.§

NOTE: Support for a response type does not mean that all orders, appointments, etc. will necessarily receive card guidance, merely that it must be able to return those response types for at least a subset of CRD invocations.

Provision of and acceptance of decision support cards outside the coverage and documentation requirements space is optional (for both server and client). CRD servers that provide decision support for domains outside of coverage and/or documentation requirements are expected to only provide decision support that the CRD client cannot do alone. To minimize duplicate alerts and provider burden, §resp-15?^crd-server^exchange:CRD servers that provide decision support for domains outside of coverage and/or documentation requirements **SHOULD** take reasonable steps to check that the CRD client does not have the information within its store that would allow it to detect the issue itself.§ If the information already exists in the CRD client, then the obligation is on the CRD client to manage the issue detection and reporting in its own manner and CRD servers should not get involved.

Response types are listed from least sophisticated to most sophisticated, and potentially more useful or powerful. As a rule, the more a response can automate manual processes and the more context-specific the behavior is, the more useful the decision support will be to the clinician and the more likely it will be used.

Notes:

* CRD clients will provide resources, such as MedicationRequest, in the context object of the CDS Hooks request. These resources might be temporary in the context in which the CDS Hook is triggered, such as when a proposed medication order is being reviewed. In this case, the CDS client must maintain a stable identifier for these temporary resources to allow CRD responses to refer to them in CDS Hook actions.
* Hook responses may contain multiple cards and/or system actions corresponding to a mixture of the response types defined in this IG. For example, providing links, textual guidance, as well as suggestions for alternative orders.
* The response types listed here are **not** the same as the [Configuration Options](deviations.md#configuration-options-extension) specified above. A single response type could correspond to multiple configuration options. For example, [External Reference](#external-reference-response-type) could apply to clinical practice guidelines, prior authorization requirements, claims attachment requirements, and other things. Similarly, one configuration option could be satisfied with multiple response types. For example, required prior authorization forms could include both [External References](#external-reference-response-type) and explicit [Request Form Completion](#request-form-completion-response-type) responses.

### External Reference Response Type

This response type presents a card with one or more links to external web pages, PDFs, or other resources that provide relevant coverage information. The links might provide clinical guidelines, prior authorization requirements, printable forms, etc. Typically, these references would be links to information available from the payer's website, though pointers to other authoritative sources are possible too. §resp-16^crd-server^exchange:CRD servers **SHALL NOT** use "External Reference" cards to direct users to a portal for the purpose of initiating prior authorization or determining coverage.§ Use the [Coverage Information](#coverage-information-response-type) response instead.

§resp-17^crd-server^exchange:The card **SHALL** have at least one `Card.link`.§ §resp-18^crd-server^exchange:The `Link.type` **SHALL** have a type of "absolute".§

§resp-19?^crd-server^exchange:When reasonable, an "External Reference" card **SHOULD** contain a summary of the actionable information from the external reference in the `detail` element.§

For example, this CDS Hooks [Card](http://cds-hooks.hl7.org/2026Jan/index.html#cds-service-response) contains two [Links](http://cds-hooks.hl7.org/2026Jan/index.html#link) - a standard and a printer-friendly version.

§resp-20?^crd-server^exchange:As much as technically possible, links provided **SHOULD** be 'deep' links that take the user to the specific place in the documentation relevant to the current hook context to minimize provider reading and navigation time.§

A profile defining the expectations of an External Reference response can be found [here](StructureDefinition-CRDHooksResponse-externalReference.md).

### Instructions Response Type

This response type presents a card with textual guidance to display to the user making the decisions. The text might provide clinical guidelines, suggested changes, or rules around prior authorization. It can be generated in a more sophisticated context for the payer, while remaining easy to consume for the provider because it allows returned information to be tuned to the specific context of the order/encounter that triggered the hook. In some cases, the text returned might be generated uniquely each time a hook is fired. §resp-21^crd-server^exchange:CRD servers **SHALL NOT** use Instructions Response cards to direct users to a portal for the purpose of initiating prior authorization or determining coverage. Use the [Coverage Information](#coverage-information-response-type) response instead.§

This example CDS Hooks [card](http://cds-hooks.hl7.org/2026Jan/index.html#cds-service-response) just contains a message:

A profile defining the expectations of an Instructions response can be found [here](StructureDefinition-CRDHooksResponse-instructions.md).

### Coverage Information Response Type

This response type uses a [systemAction](http://cds-hooks.hl7.org/2026Jan/index.html#system-action) to automatically update the order or other resource in the CRD client with an extension that conveys information related to the coverage of the order. As discussed on the [home page](index.md#cmsdiscretion), the functionality of this response type has been enhanced to allow directly returning a prior authorization number as part of a CRD response. §resp-22^crd-server^exchange:Regardless of the content, this "Coverage Information" response type **SHALL NOT** use a card.§

Support expectations for this hook by CRD servers are as follows:

1. §resp-23^crd-server^exchange:CRD servers**SHALL**support supplying coverage information for all primary hooks: order-sign, order-dispatch, and appointment-book.§
1. §resp-24^crd-server^exchange:CRD servers**MAY**support supplying coverage information for all other (non-primary) hooks.§
1. §resp-25?^crd-server^exchange:CRD servers**SHALL**supply coverage information for all hooks where they support it unless the EHR sends a configuration option asking them not to.§
1. §resp-26?^crd-server^exchange:If coverage information is evaluated, a system action**SHALL**be returned for each in-scope request resource unless that request resource already has a coverage-information extension, and the CRD server has no new information to add.§

A new FHIR [coverage-information](StructureDefinition-ext-coverage-information.md) extension is defined that allows assertions around coverage and prior authorization to also be captured computably, including what assertion is made, what coverage the assertion is made with respect to, when the assertion was made, and - optionally - a trace ID that can be used for audit purposes.  

 The extension generally gets added to the request resource that was passed to the CDS server (the Appointment, Encounter, ServiceRequest, etc.). There is one exception, which is if an Appointment is 'basedOn' a ServiceRequest, the system action requesting a resource update to add or change the coverage-information extension(s) will be against the ServiceRequest, not the appointment. 

Assertions about coverage, prior authorization requirements, etc. are contingent on the eventual claim for the ordered service being aligned with payer expectations. Because the order/appointment/etc. will not have the same information that would typically be included in a formal request for prior authorization or pre-determination, the payer will need to infer from the order what billing codes, qualifiers, dollar amounts, etc. would typically be involved. In some cases, the answer might differ depending on factors such as in/out of network, when the service is delivered, etc. §resp-27^crd-server^exchange:Such qualifiers around when the coverage assertion is considered valid **SHALL** be included as part of the annotation.§

If a CRD server has provided limitations about when a coverage assertion applies that turn out to not be consistent with what the provider intends to do (e.g., payer says "covered if billed as X", but provider intends to bill as Y), then the provider can always use the normal prior authorization process to solicit an authorization that more precisely aligns with their expectations for how the service will eventually be billed.

§resp-28?^crd-client^exchange:If a CRD client submits a claim related to an order for which it has received a coverage-information extension for the coverage type associated with the claim, that claim **SHALL** include the `coverage-assertion-id` and, if applicable, the `satisfied-pa-id` in the X12 837 K3 segment.§ Further details about the specific location of each element will be available in the X12 specifications. These identifiers will provide the necessary context to allow the payer to respect any commitments made as part of the CRD call and also to link together CRD results and eventual claims for analytics purposes.  

In some cases, multiple **coverage-information** extension repetitions may be added by the CRD server. This might represent different guidance for different coverages the service supports for the same patient or different expectations (related to coverage, prior auth, or additional information) for different billing codes, different qualifiers (e.g., in-network vs out-of-network), etc. §resp-29?^crd-server^exchange:If multiple extension repetitions of the coverage-information extension are present, all repetitions referencing differing insurance (coverage-information.coverage) **SHALL** have distinct coverage-assertion-ids and satisfied-pa-ids, if present.§ §resp-30?^crd-server^exchange:Where multiple repetitions apply to the same coverage, they **MAY** have the same coverage-assertion-ids and satisfied-pa-ids (if present).§ It is possible that some repetitions for a coverage might have satisfied prior authorization with an ID, while others will not.

§resp-31^crd-client^exchange:Systems **MAY** make CRD calls to servers related to orders even if there is already a coverage assertion recorded on the order.§ There is always the possibility that context has changed or new information available in the order will result in a new decision or additional guidance. The payer might also have other useful information not related to coverage or authorization. Information about the order or context might change between an initial `order-select` or `order-sign` and a subsequent `order-dispatch` or other hook invocation.

§resp-32^crd-server^exchange:However, CRD servers **SHALL NOT** send a `systemAction` to update the order unless something is new or changed.§ §resp-33^crd-server^processing:CRD servers **SHOULD** take into account the previous decision in deciding how much processing is necessary before returning a response.§  

§resp-34?^crd-server^exchange:When returning a `systemAction` to update a resource with the "Coverage Information" response type, the resource content **SHALL NOT** make changes to any data elements other than adding or modifying coverage-information extensions.§

§resp-35?^crd-server^exchange:If a **coverage-information** extension indicates the need to collect additional information (via 'doc-needed'), the extension **SHOULD** include a reference to the questionnaire(s) to be completed.§ If the payer supports Da Vinci DTR, the indicated forms will be the ones completed within the DTR form filler. If no Questionnaires are specified, DTR will determine the needed forms itself. For systems that do not support DTR (e.g. because the coverage is not subject to regulation mandating DTR), the indicated Questionnaire canonicals can be used to determine data to be gathered in some other (non-DTR) way.  

§resp-36?^crd-client^ui:When a **coverage-information** response type indicates that additional clinical or patient documentation is needed and the CRD client supports DTR, CRD clients **SHALL** ensure that clinical users have an opportunity to launch their DTR solution as part of the current workflow.§ Where a **coverage-information** response indicates that additional administrative documentation is needed, §resp-37^crd-client^ui:CRD clients **SHOULD** allow clinical users to have an opportunity to launch their DTR solution but **SHOULD** make it clear that the information to be captured is non-clinical.§

NOTE: Launching DTR does not necessarily mean launching a SMART on FHIR application. Some CRD clients might incorporate DTR client functionality natively rather than using an app.  

When invoking CRD, there may be situations where 'needed' information is not available. For example, the date of birth might be 'unknown' and there might only be a subscriber id but not a member id. Alternatively, the payer may not be able to find a member with the specified identifier, the payer might want a location and none is provided, or the payer needs a diagnosis code, but the provided code is free text. In such situations, this is NOT considered an error with the CDS Hooks invocation. A successful response with a coverage-information system action is still necessary.

§resp-38^crd-server^exchange:The CRD server **SHOULD** either prompt for the additional needed information using DTR or return a coverage-information extension indicating that the patient is not covered with a reason indicating the issue (e.g. the member could not be found/resolved).§

§resp-39?^crd-server^exchange:If the CRD server is unable to resolve the patient, the Coverage Information **SHALL** indicate "not covered" with a reason code of [no-member-found](ValueSet-coverageAssertionReasons.md#x-http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp-no-member-found).§

§resp-40?^crd-server^exchange:If the CRD is able to resolve the patient but they do not have active coverage, the Coverage Information **SHALL** indicate "not covered" with a reason of [no-active-coverage](ValueSet-coverageAssertionReasons.md#x-http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp-no-active-coverage).§

  This specification allows returning either a single coverage-information repetition that says "conditional" or multiple coverage-information repetitions with specific assumptions that then indicate "covered", "auth-needed", etc.  The recommended criteria for deciding whether to return a single or multiple are as follows:

* If the decision is driven by different subsets of billing codes or different timeframes (i.e. discrete information that can be conveyed using coverage-information.billingCode or detail codes of allowed-period), then use multiple repetitions.
* If the decision is driven by other information that cannot be easily listed in the coverage-information (e.g. what specific provider delivers the service, where it happens, etc.) then use 'Conditional' and indicate the specific additional information needed to make a decision.

For example, if the payer does not know whether authorization is necessary (or if the service is covered at all) because it is necessary to know whether the performer will be in network or not, this ought to be conveyed as a single coverage-information extension that is marked as 'conditional' for authorization and/or coverage with info-needed set to at least include provider and/or location, with a 'reason' indicating the authorization rules.  This might be the standard code of auth-out-network-only.

 §resp-41?^crd-client^storage,ui:If a system action containing a coverage-information extension is returned, the CRD client **SHALL** retain that coverage-information extension and expose it as part of the Request resource in all subsequent communications with that payer, including communications made using DTR and PAS.§ The coverage-information.coverage-assertion-id will service as a 'linking' id allowing the payer to associate any cached information they have retained relating to the processing of this Request.

§§resp-42^crd-client^exchange:When using the "Coverage Information" response type, the proposed order or appointment being submitted for update **SHALL** comply with the required profiles^

When using the "Coverage Information" response type, the proposed order or appointment being submitted **SHALL** comply with the following profiles:

| | |
| :--- | :--- |
| [profile-appointment-with-order](StructureDefinition-profile-appointment-with-order.md) |  |
| [profile-appointment-no-order](StructureDefinition-profile-appointment-no-order.md) |  |
| [profile-devicerequest](StructureDefinition-profile-devicerequest.md) |  |
| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.md) |  |
| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.md) |  |
| [profile-servicerequest](StructureDefinition-profile-servicerequest.md) |  |
| [profile-visionprescription](StructureDefinition-profile-visionprescription.md) |  |

§§

For example, this response indicates that a prior authorization has been satisfied for a planned procedure:

§resp-43^crd-client,crd-server^exchange,storage:CRD clients and servers **SHALL** support the new CDS Hooks system action functionality to cause annotations to automatically be stored on the relevant request, appointment, etc. without any user intervention.§ §resp-44^crd-client^ui:In this case, the discrete information propagated into the order extension **SHALL** be available to the user for viewing. However, this might be managed with icons, flyovers, or alternate mechanisms than traditional CDS Hooks card rendering.§ The key consideration is that the user is aware that information is available and they can easily access it. Client implementations will be responsible for ensuring that the only changes made to the CRD client record are to add the annotations contemplated here. §resp-45^crd-client^exchange:CRD clients **MAY** be configured to not execute system actions under some circumstances, for example if the order has been cancelled or abandoned.§

The information added to the order here is often going to be relevant/important not only to the creator of the order, but also to its eventual performer. This guide does not define how information around coverage is conveyed from the ordering system to the performing system. However, the [Post-acute Orders implementation guide](http://hl7.org/fhir/us/dme-orders) does provide a mechanism for electronic sharing of orders and could be used to convey the additional notes or extensions envisioned here as well.

Payers with existing tools that process prior authorization requests may have dependencies on data elements that are not found in the clinical orders being submitted as part of CRD such as service type or modifier codes. §resp-46^crd-server^exchange:Where CRD servers need for data that was not transmitted, they **SHOULD** attempt to infer values from elements that are present.§ For example, 'service type' can often be inferred based on the nature of the service, the location, the performer, etc. In situations where the inferred element has an impact on the results, payers should document that as part of their 'coverage-information' extension. In situations where inference is not possible and an element must be known; the payer may indicate that formal prior authorization is necessary. This situation should be minimized as much as possible.

A profile defining the expectations of an Coverage Information response can be found [here](StructureDefinition-CRDHooksResponse-coverageInformation.md).

### Propose Alternate Request Response Type

This response type can be used by payers to present a card with suggested alternatives to the current proposed therapy. This might be updating the order to change certain information or proposing replacing the order completely with one or more alternatives. This might be used to propose a change to a first-line treatment, to alter therapy frequency or drug dosage to be consistent with coverage guidelines, to propose covered products or services as substitutes for a non-covered service, or to propose therapeutically equivalent treatments that will have a lower cost to the patient.

Multiple alternatives can be proposed by providing multiple suggestions. §resp-47^crd-server^exchange:Each suggestion **SHOULD** contain either a single "update" action to revise the existing proposed order; or a "delete" action for the current proposed order and a "create" action for the new proposed order.§ In some cases, additional "create" actions might be needed if there is a need to convey a non-[contained](http://hl7.org/fhir/R4/references.html#contained) Medication, Device, or other resource. The "delete" action resource element is not expected to adhere to any profile, as it is only expected to contain the "id" property of the resource being replaced. Any other elements will be ignored.

§resp-48^crd-server^exchange:The choice of "update" vs. "delete + create" **SHOULD** be based on how significant the change is and how relevant the other decision support on the original request will still be.§ If cards returned by other service providers might still be relevant (e.g., because there was just a small change in dose or frequency), then performing an update will allow updates from other decision support cards to also be applied. If the change is significant enough that other decision support will not be relevant, a "delete + create" will allow the client to suppress decision support cards that no longer apply.

§§resp-49^crd-server^exchange:When using the "Propose Alternate Request" response type, the proposed orders (and any associated resources) **SHALL** comply with the required profiles.^

When using the "Propose Alternate Request" response type, the proposed orders (and any associated resources) **SHALL** comply with the following profiles:

| | |
| :--- | :--- |
| [profile-device](StructureDefinition-profile-device.md) |  |
| [profile-devicerequest](StructureDefinition-profile-devicerequest.md) |  |
| [profile-encounter†](StructureDefinition-profile-encounter.md) |  |
|  | [us-core-medication](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medication.html) |
| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.md) |  |
| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.md) |  |
| [profile-servicerequest](StructureDefinition-profile-servicerequest.md) |  |
| [profile-visionprescription](StructureDefinition-profile-visionprescription.md) |  |

† Only used if updating an Encounter (e.g., to add a note)

§§

For example, this card proposes replacing the draft prescription for a brand-name drug (shown only as the 'resourceType' and 'id' from the `draftOrders` entry) and instead creating an equivalent prescription with a lower-cost medication.

A profile defining the expectations of an Alternate Request response can be found [here](StructureDefinition-CRDHooksResponse-alternateRequest.md).

### Identify Additional Orders Response Type

This response type can be used to present a card that recommends the introduction of additional orders as companions or prerequisites for the current order. For example, the payer might recommend that certain lab tests be ordered along with a medication that is known to affect liver function. This will normally involve additional 'create' actions. The fact that there is no 'delete' for the original order conveys that these are supplemental actions rather than replacement actions. As with the [Propose Alternate Request](#propose-alternate-request-response-type) response type, in some cases multiple resources will need to be created to convey the full suggestion such as 'medication', 'device', etc.

§§resp-50^crd-server^exchange:When using the "Identify Additional Orders" response type, the proposed orders and any associated resources **SHALL** comply with the required profiles^

When using the "Identify Additional Orders" response type, the proposed orders and any associated resources **SHALL** comply with the following profiles:

| | |
| :--- | :--- |
| [profile-communicationrequest](StructureDefinition-profile-communicationrequest.md) |  |
| [profile-device](StructureDefinition-profile-device.md) |  |
| [profile-devicerequest](StructureDefinition-profile-devicerequest.md) |  |
|  | [us-core-medication](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medication.html) |
| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.md) |  |
| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.md) |  |
| [profile-servicerequest](StructureDefinition-profile-servicerequest.md) |  |
| [profile-visionprescription](StructureDefinition-profile-visionprescription.md) |  |

§§

This example proposes adding a monthly test to check liver function:

A profile defining the expectations of an Additional Orders response can be found [here](StructureDefinition-CRDHooksResponse-additionalOrders.md).

### Request Form Completion Response Type

NOTE: DTR is the preferred solution where forms are needed for capturing information for payer purposes including, but not limited to, prior authorization, claims submission, or audit because of its ability to minimize data entry burden.

  The Request Form Completion response type **SHALL NOT** be used if:

1. DTR is applicable to the use case (i.e. the form relates to prior auth, claim submission, appropriate use, or order fulfillment),
1. DTR is supported by the CRD client (whether voluntarily or as required by regulation), and
1. DTR is available from the server (e.g. not temporarily unavailable or not supported by a payer not subject to regulation).

This response type can be used to present a card that indicates that there are forms that need to be completed. The indicated forms might indicate additional documentation that must be submitted for prior authorization, attachments for claims submission, documentation that must be completed and retained as proof that clinical need protocols have been followed, or that must otherwise be retained and available for future audits. While forms can also be expressed as static or active PDFs referenced by [External References](#external-reference-response-type), or within a [SMART Application](#launch-smart-application-response-type), this response type provides the form definition as a FHIR Questionnaire and creates a Task within the CRD client allowing the completion of the form to be appropriately scheduled and/or delegated. Alternatively, the provider could choose to execute the task and fill out the form immediately if that makes more sense from a clinical workflow perspective.

This suggestion will always include a create action for the Task. The Task will point to the Questionnaire to be completed using a `Task.input` element with a `Task.input.type` of "questionnaire" and the canonical URL for the questionnaire in `Task.input.valueCanonical`. Additional `Task.input` elements will provide information about how the completed questionnaire response is to be submitted to the payer with a service endpoint if required. The `Task.code` will always include the CRD-specific `complete-questionnaire` code. The reason for completion will be conveyed in `Task.reasonCode`. The Questionnaire might also be included with a separate conditional create action or it might be excluded with the presumption it will already be available or retrievable by the client via its canonical URL, either from the original source or from a local registry.

§resp-52^crd-server^exchange:Instead of using a card for "Request Form Completion", CRD servers **MAY** opt to use a [systemAction](http://cds-hooks.hl7.org/2026Jan/index.html#system-action).§ §resp-53?^crd-client^exchange:CRD clients supporting the Request Form Completion response type **SHALL** support both the card and systemAction approach.§

§§resp-54^crd-server^exchange:When using the "Request Form Completion" response type, the resources in the card or system action **SHALL** comply with the required profiles^

When using the "Request Form Completion" response type, the resources in the card or system action **SHALL** comply with the following profiles:

| | |
| :--- | :--- |
| [profile-taskquestionnaire](StructureDefinition-profile-taskquestionnaire.md) |  |

§§

No profile is provided for the questionnaires pointed to by the Task. §resp-55^crd-server^exchange:CRD servers **SHOULD** use questionnaires that are compliant with either the [Argonaut questionnaire profiles](https://github.com/argonautproject/questionnaire) (for forms to be completed within the CRD client) or the [Structured Data Capture (SDC) profiles](http://hl7.org/fhir/uv/sdc/index.html) (for more sophisticated forms to be created within a SMART on FHIR app or through an external service).§

Note:

* Where CRD servers use the SDC profiles, they have the option of indicating an endpoint for submission of the questionnaire using Task.input or the SDC Questionnaire.endpoint extension to specify a service endpoint to submit completed questionnaires. If an endpoint is specified in both locations, both apply.
* §resp-56^crd-client^storage:CRD clients **SHOULD** retain a copy of all completed forms for future reference.§

The following is an example CDS Hooks [Suggestion](http://cds-hooks.hl7.org/2026Jan/index.html#suggestion), where the specified questionnaire is either expected to be available within the CRD client or available for retrieval through its canonical URL. As such, the [Action](http://cds-hooks.hl7.org/2026Jan/index.html#action) only contains the FHIR [Task](http://hl7.org/fhir/R4/task.html) resource. An example showing inclusion of both the Task and the referenced Questionnaire can be found [above](deviations.md#if-none-exist).

A profile defining the expectations of an Form Completion response can be found [here](StructureDefinition-CRDHooksResponse-formCompletion.md).

### Update Coverage Records Response Type

This response type is used when the CRD server has updates or corrections to make to the primary insurance coverage record held by the CRD client eing used for the CRD call. For example, the CRD client might be aware that a patient has coverage with a provider, but have incorrect details such as expiry date, coverage types, etc. This response allows the CRD server to convey that information to the CRD client and link it to the current/proposed action. In theory, this type of response could also be used to convey corrected/additional prior authorization information the payer was aware of, however that functionality is out of scope for this release of the implementation guide.

§resp-57^crd-server^exchange:Instead of using a card for "Update Coverage Records", CRD servers **MAY** opt to use a [systemAction](http://cds-hooks.hl7.org/2026Jan/index.html#system-action) instead.§ §resp-58^crd-client^exchange:CRD clients supporting the Update Coverage Records response type **SHALL** support both the card and system action approach.§ §resp-59?^crd-client^processing:If receiving a system action, a CRD client **MAY** opt to place the updated record in a holding area for human review rather than directly modifying their source of truth.§

NOTE: This functionality is somewhat redundant with the capabilities of the X12 270/271 transactions. §resp-60^crd-server^exchange:This Update Coverage Records capability **SHALL NOT** be used in situations where regulation dictates the use of the X12 functionality.§

This response will contain a single suggestion. The primary action will be a suggestion to update an existing coverage instance.

For example, this CDS Hooks [card](http://cds-hooks.hl7.org/2026Jan/index.html#cds-service-response) includes a single [suggestion](http://cds-hooks.hl7.org/2026Jan/index.html#suggestion) with an [action](http://cds-hooks.hl7.org/2026Jan/index.html#action) to update the [Coverage](http://hl7.org/fhir/R4/coverage.html).

§resp-61?^crd-server^exchange:If returning a card rather than a system action, the "Update Coverage Records" response type **SHOULD NOT** be returned for hook types that are likely to be triggered by clinical users rather than administrative staff. Cards of this type would be appropriate for hooks such as encounter-start or appointment-book but would not be appropriate for order-select or order-sign.§

A profile defining the expectations of an Adjust Coverage response can be found [here](StructureDefinition-CRDHooksResponse-adjustCoverage.md).

### Launch SMART Application Response Type

SMART apps allow more sophisticated interaction between payers and providers. They provide full control over user interface, workflow, etc. With permission, they can also access patient clinical data to help guide the interactive experience and minimize data entry. Apps can provide a wide variety of functions, including eligibility checking, guiding users through form entry, providing education, etc.

All such apps will need to go through the approval processes for the client's provider organization and typically also the associated software vendor. This response type can cause the launching of such apps to occur in the context in which they are relevant to patient care and/or to payment-related decision making.

This response type is just a modified version of the [External Reference](#external-reference-response-type) response type. However, the `Link.type` will be "smart" instead of "absolute". The `Link.appContext` will typically also be present.

NOTE: This mechanism is no longer to be used for launching [DTR applications](http://hl7.org/fhir/us/davinci-dtr). That process is now handled entirely through the [Coverage Information](#coverage-information-response-type) response type above. It can still be used for launching other types of SMART apps not focused on gathering data for payer use with questionnaires.

For example, this [card](http://cds-hooks.hl7.org/2026Jan/index.html#cds-service-response) contains a SMART app [link](http://cds-hooks.hl7.org/2026Jan/index.html#link) to perform an opioid assessment:

A profile defining the expectations of an Launch SMART response can be found [here](StructureDefinition-CRDHooksResponse-launchSMART.md).

