# Reading this IG - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Reading this IG

### Underlying Technologies

This guide is based on the [HL7 FHIR](http://hl7.org/fhir/R4/index.html) standard, as well as the [CDS Hooks](http://cds-hooks.hl7.org/2026Jan) and [SMART on FHIR](http://hl7.org/fhir/smart-app-launch/index.html) specifications, which build additional capabilities on top of FHIR. This architecture is intended to maximize the number of provider systems that conform to this guide, as well as to allow for easy growth and extensibility of system capabilities in the future.

Implementers of this specification therefore need to understand some basic information about these referenced specifications.

#### FHIR

This implementation guide uses terminology, notations and design principles that are specific to FHIR. Before reading this implementation guide, it is important to be familiar with some of the basic principles of FHIR as well as general guidance on how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to read (or at least skim) the following prior to reading the rest of this implementation guide.

* [FHIR Overview](http://hl7.org/fhir/R4/overview.html)
* [Developer's Introduction](http://hl7.org/fhir/R4/overview-dev.html) (or [Clinical Introduction](http://hl7.org/fhir/R4/overview-clinical.html))
* [FHIR Data Types](http://hl7.org/fhir/R4/datatypes.html)
* [Using Codes](http://hl7.org/fhir/R4/terminologies.html)
* [References Between Resources](http://hl7.org/fhir/R4/references.html)
* [How to Read Resource & Profile Definitions](http://hl7.org/fhir/R4/formats.html) and additional [IG reading guidance](https://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html)
* [Base Resource](http://hl7.org/fhir/R4/resource.html)

This implementation guide supports the [R4](http://hl7.org/fhir/R4/index.html) version of the FHIR standard and builds on the US Core [3.1 (USCDI v1)](http://hl7.org/fhir/us/core/STU3.1.1), [6.1 (USCDI v3)](http://hl7.org/fhir/us/core/STU6.1) and [7.0 (USCDI v4)](http://hl7.org/fhir/us/core/STU7) implementation guides and implementers need to familiarize themselves with the profiles in those guides. The profiles in this IG conform with all three releases of US Core.

This IG also draws on content from the [Davinci Health Record Exchange (HRex)](https://build.fhir.org/ig/HL7/davinci-ehrx/) and [Structured Data Capture (SDC)](http://hl7.org/fhir/uv/sdc/STU3) implementation guides.

Implementers should also familiarize themselves with the FHIR resources used within the guide:

| | |
| :--- | :--- |
| [ActorDefinition](http://hl7.org/fhir/r5/actordefinion.html) | Used to help identify the entities that are subject to conformance expectations (pre-adopted from R5) |
| [Appointment](http://hl7.org/fhir/R4/appointment.html) | One of the resources that can trigger payer decision support |
| [Binary](http://hl7.org/fhir/R4/binary.html) | Used to represent example instances of CDS Hooks JSON structures |
| [Bundle](http://hl7.org/fhir/R4/bundle.html) | Used when delivering collections of resources in a CDS Hooks call, also used for queries |
| [CapabilityStatement](http://hl7.org/fhir/R4/capabilitystatement.html) | Used to define conformance expectations for this guide |
| [CodeSystem](http://hl7.org/fhir/R4/codesystem.html) | Used to define custom codes specific to this guide |
| [ConceptMap](http://hl7.org/fhir/R4/conceptmap.html) | Used to map location codes between terminologies |
| [Coverage](http://hl7.org/fhir/R4/coverage.html) | Used to identify the member and the relevant insurance coverage to a payer |
| [CommunicationRequest](http://hl7.org/fhir/R4/communicationrequest.html) | One of the resources that can trigger payer decision support |
| [Device](http://hl7.org/fhir/R4/device.html) | Supporting information for device requests |
| [DeviceRequest](http://hl7.org/fhir/R4/devicerequest.html) | One of the resources that can trigger payer decision support |
| [Encounter](http://hl7.org/fhir/R4/encounter.html) | Oner of the resources that can trigger payer decision support, and also provides context for other resources |
| [Location](http://hl7.org/fhir/R4/location.html) | Supporting information for encounters and request resources |
| [Organization](http://hl7.org/fhir/R4/organization.html) | Used when identifying providers in Encounters, Tasks, and all requests |
| [Medication](http://hl7.org/fhir/R4/medication.html) | Supporting information for medication requests |
| [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) | One of the resources that can trigger payer decision support |
| [NutritionOrder](http://hl7.org/fhir/R4/nutritionorder.html) | One of the resources that can trigger payer decision support |
| [Patient](http://hl7.org/fhir/R4/patient.html) | Demographic information relevant to all requests |
| [Practitioner](http://hl7.org/fhir/R4/practitioner.html) | Used when identifying providers in Encounters, Tasks, and all requests |
| [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) | Used when identifying providers in Encounters, Tasks, and all requests |
| [Questionnaire](http://hl7.org/fhir/R4/questionnaire.html) | Used to support the capture of additional information not covered by DTR |
| [Requirements](http://hl7.org/fhir/r5/requirements.html) | Provides a computable listing of the text-based conformance expectations of the guide (pre-adopted from R5) |
| [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | One of the resources that can trigger payer decision support |
| [StructureDefinition](http://hl7.org/fhir/R4/structuredefinition.html) | Used when profiling resources, defining extensions, and defining profiles and extensions on CDS Hooks models |
| [Task](http://hl7.org/fhir/R4/task.html) | Used to manage dispatching orders to performing providers or locations |
| [ValueSet](http://hl7.org/fhir/R4/valueset.html) | Used to define collections of codes used by CRD profiles |
| [VisionPrescription](http://hl7.org/fhir/R4/visionprescription.html) | One of the resources that can trigger payer decision support |

#### CDS Hooks

Provider systems will use the specification and workflows defined by [CDS Hooks 2.0](http://cds-hooks.hl7.org/2026Jan) to initiate Coverage Requirements Discovery with the payers. Implementers must be familiar with all aspects of this specification.

#### SMART on FHIR

SMART on FHIR is expected to be used in two principal ways:

##### Ad Hoc Coverage Requirements Discovery

CDS Hooks provides a mechanism for payers to advise clinicians on coverage requirements as part of their regular workflow: when ordering medications, making referrals, scheduling appointments, discharging patients, etc. However, sometimes clinicians may be interested in learning about coverage requirements without going through the workflow steps within their CRD client. In this case, they do not want to actually create a referral, they just want to ask the question "what would the requirements or recommendations be if I **wanted** to create a referral?

Such recommendations might be from decision support (such as ImmunizationRecommendation or a CarePlan with an intent of 'proposed') or from standard protocols (e.g. "this patient is due for a pap smear"). In such cases, the EHR can support automated generation of 'draft' requests (such as MedicationRequest or ServiceRequest) based on the decision support or protocol resources and use them when invoking CRD. Alternatively, the EHR might support launching a SMART on FHIR app that would capture the key information needed to drive a CRD response.

Discussion of how a SMART on FHIR app can be used to trigger CDS Hooks from within an CRD client to perform such what-if scenarios can be found [here](foundation.md#what-if-hook-invocation).

##### Apps for Decision Support

Payers may recommend the launch of SMART apps that are relevant to the activity the user is performing. For example, an app might help guide order creation for specialized patient needs, help evaluate alternative therapies, determine whether complementary therapy is necessary/appropriate, etc. These might have clinical or administrative purposes. Recommendations for such apps would be returned by the [SMART app response type](cards.md#launch-smart-application-response-type).

### Architectural Approach

The approach taken to meet the requirements of the CRD use-case was selected after evaluating the various interoperability choices provided by FHIR. Specifically, the project team evaluated the possible architectural approaches as described in the HRex specification's [Approaches to Exchanging FHIR Data](https://build.fhir.org/ig/HL7/davinci-ehrx//exchanging.html) guide. The following bullets describe the path choices driven by use-case requirements:

* **Direct connection?** - Yes - it was presumed that CRD client systems could connect directly either with the payer or with a payer-provided service.
* **Consumer initiates?** - Yes - the provider system needing decision support would trigger the support, because only the provider system would know when support was needed.
* **Human intervention?** - No - there was no expectation that a human would need to be involved on the data source (payer) side to determine what guidance should be provided. The requirement was for real-time guidance, which meant any guidance provided had to be automatic.
* **Is data pre-existing?** - No - in decision support, we are generating context-specific guidance that did not previously exist, even if some of the resources pointed to might have been pre-existing.
* **CDS Hooks?** - Yes - CDS Hooks were a good fit for the workflow we needed. There was no need to define custom operations or messages to meet our use cases.

NOTE: Because of the sensitivity around disclosure of clinical information to payer-controlled systems during the clinical workflow process, this IG imposes a number of safeguards around the use of the selected CDS Hooks technology to help ensure that providers and their systems have an appropriate degree of control over disclosure and that information cannot be used in inappropriate ways.

