# Types of Edible Substances - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## ValueSet: Types of Edible Substances 

 
Copied from FHIR Core R6 draft. This value set represents codes for types of edible substances. It include codes from [SNOMED CT](http://snomed.info/sct) where concept 762766007 Edible Substance (substance) and its sub-concepts, Infant Formula (412413001) and its sub-concepts, Enteral and Supplement Feeds (346415002) and its sub-concepts, Water (11713004), Potable Water (890302005) and its sub-concepts, and Tap Water (444923006). 

 **References** 

* [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "edible-substance-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/edible-substance-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.48.33"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "TypesOfEdibleSubstances",
  "title" : "Types of Edible Substances",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Copied from FHIR Core R6 draft.  This value set represents codes for types of edible substances.  It include codes from [SNOMED CT](http://snomed.info/sct) where concept 762766007 Edible Substance (substance) and its sub-concepts, Infant Formula (412413001) and its sub-concepts, Enteral and Supplement Feeds (346415002) and its sub-concepts, Water (11713004), Potable Water (890302005) and its sub-concepts, and Tap Water (444923006).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "762766007"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "412413001"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "346415002"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "890302005"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "11713004"
          },
          {
            "code" : "444923006"
          }
        ]
      }
    ]
  }
}

```
