# CRD Dispatch Task - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Dispatch Task 

 
This profile specifies constraints on the Task resource to capture details of dispatching a request to a particular performer. 

**Usages:**

* Use this Profile: [CRD Bundle of Dispatch Tasks](StructureDefinition-profile-bundle-task.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-task-dispatch)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-task-dispatch.csv), [Excel](../StructureDefinition-profile-task-dispatch.xlsx), [Schematron](../StructureDefinition-profile-task-dispatch.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-task-dispatch",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-task-dispatch",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.17"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDTaskDispatch",
  "title" : "CRD Dispatch Task",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies constraints on the Task resource to capture details of dispatching a request to a particular performer.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "constraint" : [
          {
            "key" : "crd-tsk-d1",
            "severity" : "error",
            "human" : "Must have at least one of owner and location",
            "expression" : "owner.exists() or location.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-task-dispatch"
          }
        ]
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "fixedCode" : "draft",
        "mustSupport" : true
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "fixedCode" : "order",
        "mustSupport" : true
      },
      {
        "id" : "Task.code",
        "path" : "Task.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/CodeSystem/task-code",
              "code" : "fulfill"
            }
          ]
        }
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.location",
        "path" : "Task.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.restriction",
        "path" : "Task.restriction",
        "mustSupport" : true
      },
      {
        "id" : "Task.restriction.repetitions",
        "path" : "Task.restriction.repetitions",
        "mustSupport" : true
      },
      {
        "id" : "Task.restriction.period",
        "path" : "Task.restriction.period",
        "mustSupport" : true
      }
    ]
  }
}

```
