# CRD Practitioner - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Practitioner 

 
This profile specifies additional constraints on the US Core Practitioner profile to support coverage requirements discovery. 

**Usages:**

* Refer to this Profile: [CRD Base Appointment](StructureDefinition-profile-appointment-base.md), [CRD Communication Request](StructureDefinition-profile-communicationrequest.md), [CRD Device Request](StructureDefinition-profile-devicerequest.md), [CRD Medication Request](StructureDefinition-profile-medicationrequest.md)... Show 5 more, [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md), [CRD Service Request](StructureDefinition-profile-servicerequest.md), [CRD Dispatch Task](StructureDefinition-profile-task-dispatch.md), [CRD Questionnaire Task](StructureDefinition-profile-taskquestionnaire.md) and [CRD Vision Prescription](StructureDefinition-profile-visionprescription.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-practitioner)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-practitioner.csv), [Excel](../StructureDefinition-profile-practitioner.xlsx), [Schematron](../StructureDefinition-profile-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|3.1.1"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.53"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDPractitioner",
  "title" : "CRD Practitioner",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies additional constraints on the US Core Practitioner profile to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner"
      },
      {
        "id" : "Practitioner.identifier:tin",
        "path" : "Practitioner.identifier",
        "sliceName" : "tin",
        "short" : "U.S. Personal Tax Id Number",
        "comment" : "This is used only for TIN's that are specific to the individual.  TINs for groups **SHALL** only be communicated on Organization.",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "urn:oid:2.16.840.1.113883.4.4"
        },
        "mustSupport" : true
      }
    ]
  }
}

```
