# CRD Patient - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Patient 

 
This profile specifies additional constraints on the US Core Patient profile to support coverage requirements discovery. 

### Usage

 CRD Clients will use this profile to [resolve references](foundation.md#additional-data-retrieval) to Patient resources passed to CRD Servers, including `patientId` context references when invoking the following CDS Hooks:

* [appointment-book](hooks.md#appointment-book)
* [encounter-start](hooks.md#encounter-start)
* [encounter-discharge](hooks.md#encounter-discharge)
* [order-select](hooks.md#order-select)
* [order-sign](hooks.md#order-sign)
* [order-dispatch](hooks.md#order-dispatch)

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. 

**Usages:**

* Refer to this Profile: [CRD Base Appointment](StructureDefinition-profile-appointment-base.md), [CRD Communication Request](StructureDefinition-profile-communicationrequest.md), [CRD Coverage](StructureDefinition-profile-coverage.md), [CRD Device Request](StructureDefinition-profile-devicerequest.md)... Show 7 more, [CRD Encounter](StructureDefinition-profile-encounter.md), [CRD Medication Request](StructureDefinition-profile-medicationrequest.md), [CRD Nutrition Order](StructureDefinition-profile-nutritionorder.md), [CRD Service Request](StructureDefinition-profile-servicerequest.md), [CRD Dispatch Task](StructureDefinition-profile-task-dispatch.md), [CRD Questionnaire Task](StructureDefinition-profile-taskquestionnaire.md) and [CRD Vision Prescription](StructureDefinition-profile-visionprescription.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-patient)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-patient.csv), [Excel](../StructureDefinition-profile-patient.xlsx), [Schematron](../StructureDefinition-profile-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|3.1.1"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.15"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDPatient",
  "title" : "CRD Patient",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies additional constraints on the US Core Patient profile to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "definition" : "This profile specifies additional constraints on the US Core Patient profile to support coverage requirements discovery."
      },
      {
        "id" : "Patient.address.country",
        "path" : "Patient.address.country",
        "mustSupport" : true
      }
    ]
  }
}

```
