# CRD Location - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Location 

 
This profile specifies constraints on the US Core Location profile to support coverage requirements discovery. 

### Usage

§prof-8^crd-client^exchange:CRD Clients **SHALL** use the CRD Location profile to [resolve references](foundation.md#additional-data-retrieval) to insurance Location resources passed to CRD Servers.§

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. 

**Usages:**

* Refer to this Profile: [CRD Base Appointment](StructureDefinition-profile-appointment-base.md), [CRD Encounter](StructureDefinition-profile-encounter.md), [CRD Location](StructureDefinition-profile-location.md), [CRD Service Request](StructureDefinition-profile-servicerequest.md) and [CRD Dispatch Task](StructureDefinition-profile-task-dispatch.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-location)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-location.csv), [Excel](../StructureDefinition-profile-location.xlsx), [Schematron](../StructureDefinition-profile-location.sch) 

### Notes:

 §prof-13?^crd-client^exchange:If a Location is a fine-grained location such as a bed or room, the address **SHALL** be propagated from the higher-level location it is part of.§ I.e. If there's an address on a building or campus level, that address must appear on the Location instance for a room or bed within that building/campus. 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-location",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|3.1.1"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.11"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDLocation",
  "title" : "CRD Location",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies constraints on the US Core Location profile to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "constraint" : [
          {
            "key" : "crd-loc1",
            "severity" : "error",
            "human" : "Must either have a type or must have a parent (meaning there must be a type somewhere in the hierarchy)",
            "expression" : "type.exists() or partOf.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
          }
        ]
      },
      {
        "id" : "Location.address.type",
        "path" : "Location.address.type",
        "short" : "physical | both",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Address Type for CRD",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/locationAddressType"
        }
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Location.partOf",
        "path" : "Location.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
            ]
          }
        ],
        "condition" : ["crd-loc1"]
      }
    ]
  }
}

```
