# CRD Device Request - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Device Request 

 
This profile specifies extensions and constraints on the DeviceRequest resource to support coverage requirements discovery. 

### Usage

§§prof-6^crd-client^exchange:CRD Clients **SHALL** use the CRD DeviceRequest profile to [resolve references](foundation.md#additional-data-retrieval) to DeviceRequest resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects.^

CRD Clients **SHALL** use the CRD DeviceRequest profile to [resolve references](foundation.md#additional-data-retrieval) to DeviceRequest resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:

* [order-select](hooks.md#order-select)
* [order-sign](hooks.md#order-sign)
* [order-dispatch](hooks.md#order-dispatch)

§§

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. 

**Usages:**

* Use this Profile: [CRD CDSHooks Additional Orders Response (Logical Definition)](StructureDefinition-CRDHooksResponse-additionalOrders.md), [CRD CDSHooks Alternate Request Response (Logical Definition)](StructureDefinition-CRDHooksResponse-alternateRequest.md), [CRD CDSHooks Coverage Information Response (Logical Definition)](StructureDefinition-CRDHooksResponse-coverageInformation.md) and [CRD Bundle of Request Resources](StructureDefinition-profile-bundle-request.md)
* Refer to this Profile: [Coverage Information](StructureDefinition-ext-coverage-information.md) and [CRD Appointment with Order](StructureDefinition-profile-appointment-with-order.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-devicerequest)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-devicerequest.csv), [Excel](../StructureDefinition-profile-devicerequest.xlsx), [Schematron](../StructureDefinition-profile-devicerequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-devicerequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-devicerequest",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.9"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDDeviceRequest",
  "title" : "CRD Device Request",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies extensions and constraints on the DeviceRequest resource to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceRequest.contained",
        "path" : "DeviceRequest.contained",
        "comment" : "Any references found in this resource, with the exception of 'Patient' could potentially be resource-specific and thus transmitted as contained resources.",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.extension",
        "path" : "DeviceRequest.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            },
            {
              "type" : "value",
              "path" : "value"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "DeviceRequest.extension:Coverage-Information",
        "path" : "DeviceRequest.extension",
        "sliceName" : "Coverage-Information",
        "short" : "Coverage Info",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-coverage-information"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.extension:EncounterCategory",
        "path" : "DeviceRequest.extension",
        "sliceName" : "EncounterCategory",
        "short" : "Encounter Category",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-request-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.extension:EncounterCategory.value[x]",
        "path" : "DeviceRequest.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode|3.0.0"
        }
      },
      {
        "id" : "DeviceRequest.extension:ServiceCategory",
        "path" : "DeviceRequest.extension",
        "sliceName" : "ServiceCategory",
        "short" : "Service Category",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-request-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.extension:ServiceCategory.value[x]",
        "path" : "DeviceRequest.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/X12ServiceType"
        }
      },
      {
        "id" : "DeviceRequest.identifier",
        "path" : "DeviceRequest.identifier",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.basedOn",
        "path" : "DeviceRequest.basedOn",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.status",
        "path" : "DeviceRequest.status",
        "comment" : "This will be 'draft' when using order-select or an initial order-sign, but may be 'active' or other values for order-sign representing edits to the order or for order-dispatch.",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueCode" : "draft"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.code[x]",
        "path" : "DeviceRequest.code[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-device"
            ]
          },
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/deviceRequest"
        }
      },
      {
        "id" : "DeviceRequest.code[x]:codeCodeableConcept",
        "path" : "DeviceRequest.code[x]",
        "sliceName" : "codeCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.code[x]:codeCodeableConcept.extension:BillingOptions",
        "path" : "DeviceRequest.code[x].extension",
        "sliceName" : "BillingOptions",
        "short" : "Expected Billing Code(s)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.code[x]:codeReference",
        "path" : "DeviceRequest.code[x]",
        "sliceName" : "codeReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.parameter",
        "path" : "DeviceRequest.parameter",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.subject",
        "path" : "DeviceRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.encounter",
        "path" : "DeviceRequest.encounter",
        "comment" : "potentially relevant for CRD in some situations.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "DeviceRequest.occurrence[x]",
        "path" : "DeviceRequest.occurrence[x]",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.authoredOn",
        "path" : "DeviceRequest.authoredOn",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.requester",
        "path" : "DeviceRequest.requester",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-practitionerrole"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.performer",
        "path" : "DeviceRequest.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-practitionerrole"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.reasonCode",
        "path" : "DeviceRequest.reasonCode",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.reasonReference",
        "path" : "DeviceRequest.reasonReference",
        "comment" : "Observations **SHOULD** use US Core profiles when applicable, but not all relevant observations have appropriate US Core profiles (and there are too many to practically list all US Core profiles).",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0",
              "http://hl7.org/fhir/StructureDefinition/Observation"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
