# CRD Bundle of Request Resources - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Bundle of Request Resources 

 
This profile defines the Bundle used to convey the relevant orders for the order-select, order-sign, and order-dispatch hooks. 

**Usages:**

* Use this Profile: [CRD CDS Hooks Specific Context for order-dispatch (Logical Definition)](StructureDefinition-CRDOrderDispatchContext.md), [CRD CDS Hooks Specific Context for order-select (Logical Definition)](StructureDefinition-CRDOrderSelectContext.md) and [CRD CDS Hooks Specific Context for order-sign (Logical Definition)](StructureDefinition-CRDOrderSignContext.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-bundle-request)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-bundle-request.csv), [Excel](../StructureDefinition-profile-bundle-request.xlsx), [Schematron](../StructureDefinition-profile-bundle-request.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-bundle-request",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-bundle-request",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.28"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDRequestBundle",
  "title" : "CRD Bundle of Request Resources",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile defines the Bundle used to convey the relevant orders for the order-select, order-sign, and order-dispatch hooks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-bundle-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Appointment",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-with-order",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-no-order"
            ]
          },
          {
            "code" : "CommunicationRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-communicationrequest"
            ]
          },
          {
            "code" : "DeviceRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-devicerequest"
            ]
          },
          {
            "code" : "Encounter",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
            ]
          },
          {
            "code" : "MedicationRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-medicationrequest"
            ]
          },
          {
            "code" : "NutritionOrder",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-nutritionorder"
            ]
          },
          {
            "code" : "ServiceRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest"
            ]
          },
          {
            "code" : "VisionPrescription",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-visionprescription"
            ]
          }
        ]
      }
    ]
  }
}

```
