# CRD Appointment with Order - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Appointment with Order 

 
An appointment where the details of what the appointment is being booked for are provided in the associated ServiceRequest 

### Usage

§prof-2^crd-client^exchange:CRD Clients **SHALL** use either this Appointment without Order and/or the [no-order](StructureDefinition-profile-appointment-no-order.md) to provide `appointments` context objects to CRD Servers when invoking the [appointment-book](hooks.md#appointment-book) hook as well as to [resolve other references](foundation.md#additional-data-retrieval) to Appointment resources.§

This profile conveys the details of the appointment in an associated [ServiceRequest](StructureDefinition-profile-servicerequest.md).

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. 

**Usages:**

* Use this Profile: [CRD CDSHooks Additional Orders Response (Logical Definition)](StructureDefinition-CRDHooksResponse-additionalOrders.md), [CRD CDSHooks Alternate Request Response (Logical Definition)](StructureDefinition-CRDHooksResponse-alternateRequest.md), [CRD Bundle of Appointments](StructureDefinition-profile-bundle-appointment.md) and [CRD Bundle of Request Resources](StructureDefinition-profile-bundle-request.md)
* Refer to this Profile: [Coverage Information](StructureDefinition-ext-coverage-information.md) and [CRD Encounter](StructureDefinition-profile-encounter.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-appointment-with-order)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-appointment-with-order.csv), [Excel](../StructureDefinition-profile-appointment-with-order.xlsx), [Schematron](../StructureDefinition-profile-appointment-with-order.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-appointment-with-order",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-with-order",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.5"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDAppointmentWithOrder",
  "title" : "CRD Appointment with Order",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "An appointment where the details of what the appointment is being booked for are provided in the associated ServiceRequest",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "ical",
      "uri" : "http://ietf.org/rfc/2445",
      "name" : "iCalendar"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Appointment",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Appointment",
        "path" : "Appointment"
      },
      {
        "id" : "Appointment.basedOn",
        "path" : "Appointment.basedOn",
        "comment" : "Potentially relevant for CRD in some situations.  Must Support only applies if the client supports the given type of order and also ties their appointments directly to that type of order.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.basedOn.extension:AlternateReference",
        "path" : "Appointment.basedOn.extension",
        "sliceName" : "AlternateReference",
        "comment" : "Allows supporting referencing resources enabled in R5 but not officially supported in R4",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/alternate-reference|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.basedOn.extension:AlternateReference.value[x]",
        "path" : "Appointment.basedOn.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-medicationrequest",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-devicerequest"
            ]
          }
        ]
      }
    ]
  }
}

```
