# CRD Appointment without Order - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Appointment without Order 

 
An appointment where the details of what the appointment is being booked for are provided inline and there is no associated ServiceRequest 

### Usage

 §prof-1^crd-client^exchange:CRD Clients **SHALL** use either this Appointment with Order profile and/or the [with-order](StructureDefinition-profile-appointment-with-order.md) to provide `appointments` context objects to CRD Servers when invoking the [appointment-book](hooks.md#appointment-book) hook as well as to [resolve other references](foundation.md#additional-data-retrieval) to Appointment resources.§

This profile conveys the details of the appointment within the resource itself and does not make reference to a ServiceRequest.

Information provided in [Must Support](http://hl7.org/fhir/R4/profiling.html#mustsupport) elements will commonly be required for CRD Servers to perform coverage requirements discovery. 

**Usages:**

* Use this Profile: [CRD CDSHooks Additional Orders Response (Logical Definition)](StructureDefinition-CRDHooksResponse-additionalOrders.md), [CRD CDSHooks Alternate Request Response (Logical Definition)](StructureDefinition-CRDHooksResponse-alternateRequest.md), [CRD CDSHooks Coverage Information Response (Logical Definition)](StructureDefinition-CRDHooksResponse-coverageInformation.md), [CRD Bundle of Appointments](StructureDefinition-profile-bundle-appointment.md) and [CRD Bundle of Request Resources](StructureDefinition-profile-bundle-request.md)
* Refer to this Profile: [Coverage Information](StructureDefinition-ext-coverage-information.md) and [CRD Encounter](StructureDefinition-profile-encounter.md)
* CapabilityStatements using this Profile: [CRD Client USCDI 1](CapabilityStatement-crd-client3.1.md), [CRD Client USCDI 3](CapabilityStatement-crd-client6.1.md) and [CRD Client USCDI 4](CapabilityStatement-crd-client7.0.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-appointment-no-order)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-appointment-no-order.csv), [Excel](../StructureDefinition-profile-appointment-no-order.xlsx), [Schematron](../StructureDefinition-profile-appointment-no-order.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-appointment-no-order",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-no-order",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.4"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDAppointmentNoOrder",
  "title" : "CRD Appointment without Order",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "An appointment where the details of what the appointment is being booked for are provided inline and there is no associated ServiceRequest",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "ical",
      "uri" : "http://ietf.org/rfc/2445",
      "name" : "iCalendar"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Appointment",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Appointment",
        "path" : "Appointment"
      },
      {
        "id" : "Appointment.extension",
        "path" : "Appointment.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Appointment.extension:Coverage-Information",
        "path" : "Appointment.extension",
        "sliceName" : "Coverage-Information",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-coverage-information"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.identifier",
        "path" : "Appointment.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.serviceCategory",
        "path" : "Appointment.serviceCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Appointment.serviceCategory:us-core",
        "path" : "Appointment.serviceCategory",
        "sliceName" : "us-core",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-servicerequest-category|7.0.0"
        }
      },
      {
        "id" : "Appointment.serviceCategory:encounterType",
        "path" : "Appointment.serviceCategory",
        "sliceName" : "encounterType",
        "short" : "inpatient, outpatient, etc.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode|3.0.0"
        }
      },
      {
        "id" : "Appointment.serviceCategory:serviceType",
        "path" : "Appointment.serviceCategory",
        "sliceName" : "serviceType",
        "short" : "X-ray, Lab, consulation, surgical, etc.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/X12ServiceType"
        }
      },
      {
        "id" : "Appointment.serviceType",
        "path" : "Appointment.serviceType",
        "short" : "Codes to identify requested services. (CPT, SNOMED CT or LOINC)",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Codes describing the type of  Service",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/serviceRequestCodes"
        }
      },
      {
        "id" : "Appointment.serviceType.extension:BillingOptions",
        "path" : "Appointment.serviceType.extension",
        "sliceName" : "BillingOptions",
        "short" : "Expected Billing Code(s)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.specialty",
        "path" : "Appointment.specialty",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.appointmentType",
        "path" : "Appointment.appointmentType",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.reasonReference",
        "path" : "Appointment.reasonReference",
        "comment" : "Potentially relevant for CRD in some situations.",
        "mustSupport" : true
      }
    ]
  }
}

```
